/*
 * Decompiled with CFR 0.152.
 */
package org.jglfont;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.jglfont.JGLFont;
import org.jglfont.impl.JGLFontImpl;
import org.jglfont.impl.ResourceLoaderImpl;
import org.jglfont.impl.format.JGLFontLoader;
import org.jglfont.impl.format.angelcode.AngelCodeJGLFontLoader;
import org.jglfont.impl.format.angelcode.AngelCodeLineProcessors;
import org.jglfont.impl.format.awt.AwtJGLFontLoader;
import org.jglfont.spi.JGLFontRenderer;
import org.jglfont.spi.ResourceLoader;

public class JGLFontFactory {
    private static final Logger log = Logger.getLogger(JGLFontFactory.class.getName());
    public static final int FONT_STYLE_NONE = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int FONT_STYLE_ITALIC = 2;
    private final JGLFontRenderer fontRenderer;
    private final ResourceLoader resourceLoader;
    private static final String defaultSuffix = "fnt";
    private static JGLFontLoader systemLoader;
    private static final Map<String, JGLFontLoader> loaders;

    public static void enableAwt() {
        loaders.put("ttf", new AwtJGLFontLoader());
        systemLoader = new AwtJGLFontLoader();
    }

    public static void addLoader(String suffix, JGLFontLoader loader) {
        loaders.put(suffix, loader);
    }

    public static void setSystemLoader(JGLFontLoader loader) {
        systemLoader = loader;
    }

    public JGLFontFactory(JGLFontRenderer fontRenderer) {
        this(fontRenderer, new ResourceLoaderImpl());
    }

    public JGLFontFactory(JGLFontRenderer fontRenderer, ResourceLoader resourceLoader) {
        this.fontRenderer = fontRenderer;
        this.resourceLoader = resourceLoader;
    }

    public JGLFont loadFont(String fontName) throws IOException {
        return this.loadFont(null, fontName);
    }

    public JGLFont loadFont(InputStream stream, String filenameWithHash) throws IOException {
        String[] blocks;
        String hash = "";
        String filename = filenameWithHash;
        int i = filenameWithHash.lastIndexOf(35);
        int sep = filenameWithHash.lastIndexOf(File.separatorChar);
        int dot = filenameWithHash.lastIndexOf(46);
        if (i > 0 && i > sep && i > dot) {
            hash = filenameWithHash.substring(i + 1);
            filename = filenameWithHash.substring(0, i);
        }
        if (hash.isEmpty()) {
            return this.loadFont(stream, filename, 16);
        }
        int size = 16;
        int style = 0;
        StringBuilder sb = new StringBuilder();
        for (String block : blocks = hash.split(";")) {
            String[] keyvalue = block.split("=");
            if (keyvalue.length == 2) {
                if (keyvalue[0].equalsIgnoreCase("size")) {
                    try {
                        size = Integer.parseInt(keyvalue[1]);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                this.append(sb, block);
                continue;
            }
            if (keyvalue.length == 1) {
                if (keyvalue[0].equalsIgnoreCase("bold")) {
                    style |= 1;
                    continue;
                }
                if (keyvalue[0].equalsIgnoreCase("italic")) {
                    style |= 2;
                    continue;
                }
                this.append(sb, block);
                continue;
            }
            this.append(sb, block);
        }
        return this.loadFont(stream, filename, size, style, sb.toString());
    }

    private void append(StringBuilder sb, String block) {
        if (sb.length() == 0) {
            sb.append(block);
        } else {
            sb.append(';').append(block);
        }
    }

    public JGLFont loadFont(InputStream stream, String filename, int size) throws IOException {
        return this.loadFont(stream, filename, size, 0);
    }

    public JGLFont loadFont(InputStream stream, String filename, int size, int style) throws IOException {
        return this.loadFont(stream, filename, size, style, "");
    }

    public JGLFont loadFont(InputStream stream, String filename, int size, int style, String params) throws IOException {
        String suffix = "";
        int i = filename.lastIndexOf(46);
        if (i > 0) {
            suffix = filename.substring(i + 1).toLowerCase();
        }
        JGLFontLoader loader = loaders.get(suffix);
        InputStream is = stream;
        if (is == null) {
            is = this.resourceLoader.load(filename);
        }
        if (loader == null) {
            loader = is == null ? systemLoader : loaders.get(defaultSuffix);
        }
        return new JGLFontImpl(loader.load(this.fontRenderer, this.resourceLoader, is, filename, size, style, params));
    }

    static {
        loaders = new ConcurrentHashMap<String, JGLFontLoader>();
        loaders.put(defaultSuffix, new AngelCodeJGLFontLoader(new AngelCodeLineProcessors()));
        systemLoader = new AngelCodeJGLFontLoader(new AngelCodeLineProcessors());
        try {
            Class.forName("java.awt.Font");
            JGLFontFactory.enableAwt();
        }
        catch (ClassNotFoundException ignore) {
            log.info("TrueType Font rendering will not be available due to missing java.awt package on your platform");
        }
    }
}

