/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.xml.tools;

import de.lessvoid.xml.tools.MethodResolver;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MethodInvoker {
    private static final Logger log = Logger.getLogger(MethodInvoker.class.getName());
    @Nullable
    private Object[] target;
    @Nullable
    private final String methodWithName;

    public MethodInvoker() {
        this.methodWithName = null;
        this.target = null;
    }

    public MethodInvoker(@Nullable String methodParam, Object ... targetParam) {
        this.methodWithName = methodParam;
        if (targetParam.length == 0) {
            this.target = null;
        } else {
            this.target = new Object[targetParam.length];
            int idx = this.target.length - 1;
            Object[] objectArray = targetParam;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object o;
                this.target[idx] = o = objectArray[i];
                --idx;
            }
        }
    }

    public void setFirst(@Nonnull Object object) {
        if (this.methodWithName == null) {
            return;
        }
        if (this.target == null) {
            this.target = new Object[1];
            this.target[0] = object;
        } else {
            for (Object o : this.target) {
                if (o != object) continue;
                return;
            }
            Object[] copy = new Object[this.target.length + 1];
            System.arraycopy(this.target, 0, copy, 0, this.target.length);
            copy[copy.length - 1] = object;
            this.target = copy;
        }
    }

    @Nullable
    public Object invoke(Object ... invokeParametersParam) {
        if (this.target == null || this.target.length == 0 || this.methodWithName == null) {
            return null;
        }
        for (Object object : this.target) {
            Method method;
            if (object == null || (method = MethodResolver.findMethod(object.getClass(), this.methodWithName)) == null) continue;
            Object[] invokeParameters = MethodResolver.extractParameters(this.methodWithName);
            if (invokeParameters.length > 0) {
                if (this.getMethodParameterCount(method) == invokeParameters.length) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("invoking method '" + this.methodWithName + "' with (" + this.debugParaString(invokeParameters) + ")");
                    }
                    return this.callMethod(object, method, invokeParameters);
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("invoking method '" + this.methodWithName + "' (note: given invokeParameters have been ignored)");
                }
                return this.callMethod(object, method, new Object[0]);
            }
            if (invokeParametersParam.length > 0) {
                if (this.getMethodParameterCount(method) == invokeParametersParam.length) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("invoking method '" + this.methodWithName + "' with the actual parameters (" + this.debugParaString(invokeParametersParam) + ")");
                    }
                    return this.callMethod(object, method, invokeParametersParam);
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("invoking method '" + this.methodWithName + "' without parameters (invokeParametersParam mismatch)");
                }
                return this.callMethod(object, method, new Object[0]);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("invoking method '" + this.methodWithName + "' without parameters");
            }
            return this.callMethod(object, method, new Object[0]);
        }
        log.warning("invoke for method [" + this.methodWithName + "] failed");
        return null;
    }

    @Nullable
    private Object callMethod(@Nonnull Object targetObject, @Nonnull Method method, Object ... invokeParameters) {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine("method: " + method + "on targetObject: " + targetObject + ", parameters: " + Arrays.toString(invokeParameters));
                log.fine(method.getName());
                for (Object o : invokeParameters) {
                    log.fine("parameter: " + o);
                }
            }
            return method.invoke(targetObject, invokeParameters);
        }
        catch (Exception e) {
            log.warning("error: " + e.getMessage());
            StackTraceElement[] elements = e.getStackTrace();
            if (elements == null) {
                log.warning("stacktrace is null");
            } else {
                for (StackTraceElement ee : elements) {
                    log.warning(ee.getClassName() + ":" + ee.getFileName() + ":" + ee.getMethodName() + ":" + ee.getLineNumber());
                }
            }
            return null;
        }
    }

    private int getMethodParameterCount(@Nonnull Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return parameterTypes.length;
    }

    @Nonnull
    private String debugParaString(Object ... invokeParameters) {
        StringBuilder paraStringBuffer = new StringBuilder();
        paraStringBuffer.append(invokeParameters[0].toString());
        for (int i = 1; i < invokeParameters.length; ++i) {
            paraStringBuffer.append(", ");
            paraStringBuffer.append(invokeParameters[i].toString());
        }
        return paraStringBuffer.toString();
    }
}

