/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.xml.lwxs.elements;

import de.lessvoid.xml.lwxs.XmlType;
import de.lessvoid.xml.lwxs.elements.XmlProcessorElement;
import de.lessvoid.xml.lwxs.elements.XmlProcessorSubstituitionGroup;
import de.lessvoid.xml.tools.ClassHelper;
import de.lessvoid.xml.tools.MethodInvoker;
import de.lessvoid.xml.xpp3.Attributes;
import de.lessvoid.xml.xpp3.XmlParser;
import de.lessvoid.xml.xpp3.XmlProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class XmlProcessorType
implements XmlProcessor {
    @Nonnull
    private static final Logger log = Logger.getLogger(XmlProcessorType.class.getName());
    @Nonnull
    private final String fullClassName;
    @Nonnull
    private final Collection<XmlProcessorElement> elements = new ArrayList<XmlProcessorElement>();
    @Nonnull
    private final Collection<XmlProcessorSubstituitionGroup> substGroups = new ArrayList<XmlProcessorSubstituitionGroup>();
    @Nullable
    private XmlType xmlTypeParentSingle;
    @Nullable
    private XmlType xmlTypeParentMultiple;
    @Nullable
    private String xmlTypeParentName;
    @Nullable
    private XmlType xmlType;

    public XmlProcessorType(@Nonnull String fullClassNameParam) {
        this.fullClassName = fullClassNameParam;
    }

    public void addElementProcessor(@Nonnull XmlProcessorElement element) {
        this.elements.add(element);
    }

    public void addSubstituitionGroup(@Nonnull XmlProcessorSubstituitionGroup element) {
        this.substGroups.add(element);
    }

    @Override
    public void process(@Nonnull XmlParser xmlParser, @Nonnull Attributes attributes) throws Exception {
        this.xmlType = ClassHelper.getInstance(this.fullClassName, XmlType.class);
        if (this.xmlType == null) {
            log.log(Level.SEVERE, "Failed to process XML. Requested class " + this.fullClassName + " failed to locate.");
        } else {
            this.xmlType.applyAttributes(attributes);
            if (this.xmlTypeParentSingle != null) {
                this.invoke(this.xmlType, this.xmlTypeParentSingle, "set");
            } else if (this.xmlTypeParentMultiple != null) {
                this.invoke(this.xmlType, this.xmlTypeParentMultiple, "add");
            }
            xmlParser.nextTag();
            for (XmlProcessorElement child : this.elements) {
                child.process(xmlParser, this.xmlType);
            }
            for (XmlProcessorSubstituitionGroup subst : this.substGroups) {
                xmlParser.zeroOrMore(subst.getSubstGroup(this.xmlType));
            }
        }
    }

    @Nullable
    public XmlType getXmlType() {
        return this.xmlType;
    }

    private void invoke(@Nonnull XmlType child, @Nonnull XmlType parent, @Nonnull String qualifier) {
        MethodInvoker methodInvoker = new MethodInvoker(qualifier + this.xmlTypeParentName + "()", parent);
        methodInvoker.invoke(child);
    }

    public void parentLinkSet(@Nonnull XmlType xmlTypeParent, @Nonnull String elementName) {
        this.xmlTypeParentSingle = xmlTypeParent;
        this.xmlTypeParentMultiple = null;
        this.xmlTypeParentName = elementName;
    }

    public void parentLinkAdd(@Nonnull XmlType xmlTypeParent, @Nonnull String elementName) {
        this.xmlTypeParentSingle = null;
        this.xmlTypeParentMultiple = xmlTypeParent;
        this.xmlTypeParentName = elementName;
    }
}

