/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.xml.lwxs.elements;

import de.lessvoid.xml.lwxs.Schema;
import de.lessvoid.xml.lwxs.elements.Element;
import de.lessvoid.xml.lwxs.elements.OccursEnum;
import de.lessvoid.xml.lwxs.elements.SubstitutionGroup;
import de.lessvoid.xml.lwxs.elements.XmlProcessorElement;
import de.lessvoid.xml.lwxs.elements.XmlProcessorType;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Type {
    @Nonnull
    private final ArrayList<SubstitutionGroup> substitutionGroups = new ArrayList();
    @Nonnull
    private final ArrayList<Element> elements = new ArrayList();
    @Nonnull
    private final String className;
    @Nullable
    private final String extendsName;

    public Type(@Nonnull String classNameParam, @Nullable String extendsNameParam) {
        this.className = classNameParam;
        this.extendsName = extendsNameParam;
    }

    public void addElement(Element child) {
        this.elements.add(child);
    }

    public void addSubstitutionGroup(SubstitutionGroup substitutionGroup) {
        this.substitutionGroups.add(substitutionGroup);
    }

    @Nonnull
    public XmlProcessorType createXmlProcessor(@Nonnull Schema schema) throws Exception {
        ArrayList<SubstitutionGroup> substitutionGroups = new ArrayList<SubstitutionGroup>();
        ArrayList<Element> elements = new ArrayList<Element>();
        Type typeParent = this.getTypeParent(schema);
        if (typeParent != null) {
            substitutionGroups.addAll(typeParent.getSubstituitionGroup());
            elements.addAll(typeParent.getElements());
        }
        substitutionGroups.addAll(this.substitutionGroups);
        elements.addAll(this.elements);
        return schema.getInstance(this.className, elements, substitutionGroups);
    }

    @Nonnull
    private Collection<? extends Element> getElements() {
        return this.elements;
    }

    @Nonnull
    private Collection<? extends SubstitutionGroup> getSubstituitionGroup() {
        return this.substitutionGroups;
    }

    @Nonnull
    public XmlProcessorType createXmlProcessorFromType(@Nonnull Schema schema, @Nonnull Type typeParent) throws Exception {
        return schema.getInstance(typeParent.className, this.elements, this.substitutionGroups);
    }

    @Nullable
    public Type getTypeParent(@Nonnull Schema schema) throws Exception {
        if (this.extendsName == null) {
            return null;
        }
        if (schema.isTypeAvailable(this.extendsName)) {
            return schema.getType(this.extendsName);
        }
        return null;
    }

    public void addChildren(@Nonnull Schema schema, @Nonnull XmlProcessorType processor, @Nonnull String tagName, String tagType, @Nonnull OccursEnum occurs) throws Exception {
        this.childElement(schema, processor, tagName, occurs);
    }

    private void childElement(@Nonnull Schema schema, @Nonnull XmlProcessorType processor, @Nonnull String tagName, @Nonnull OccursEnum occurs) throws Exception {
        XmlProcessorElement child = new XmlProcessorElement(this.createXmlProcessor(schema), tagName, occurs);
        processor.addElementProcessor(child);
    }

    @Nonnull
    public String getClassName() {
        return this.className;
    }
}

