/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.xml.lwxs.elements;

import de.lessvoid.xml.lwxs.Schema;
import de.lessvoid.xml.lwxs.XmlType;
import de.lessvoid.xml.lwxs.elements.OccursEnum;
import de.lessvoid.xml.lwxs.elements.Type;
import de.lessvoid.xml.lwxs.elements.XmlProcessorElement;
import de.lessvoid.xml.lwxs.elements.XmlProcessorType;
import de.lessvoid.xml.xpp3.Attributes;
import de.lessvoid.xml.xpp3.SubstitutionGroup;
import de.lessvoid.xml.xpp3.XmlParser;
import de.lessvoid.xml.xpp3.XmlProcessor;
import javax.annotation.Nonnull;

public class Element {
    @Nonnull
    private final String tagName;
    @Nonnull
    private final String tagType;
    @Nonnull
    private final OccursEnum occurs;

    public Element(@Nonnull String elementNameParam, @Nonnull String elementTypeParam, @Nonnull OccursEnum elementOccursParam) throws Exception {
        this.tagName = elementNameParam;
        this.tagType = elementTypeParam;
        this.occurs = elementOccursParam;
    }

    public void addToProcessor(@Nonnull Schema schema, @Nonnull XmlProcessorType processor) throws Exception {
        Type type = schema.getType(this.tagType);
        type.addChildren(schema, processor, this.tagName, this.tagType, this.occurs);
        Type typeParent = type.getTypeParent(schema);
        if (typeParent != null) {
            typeParent.addChildren(schema, processor, this.tagName, this.tagType, this.occurs);
        }
    }

    public void addToSubstGroup(@Nonnull Schema schema, @Nonnull SubstitutionGroup substitutionGroup, @Nonnull XmlType xmlType) throws Exception {
        Type type = schema.getType(this.tagType);
        Type typeParent = type.getTypeParent(schema);
        if (typeParent != null) {
            XmlProcessorElement xmlProcessorElement = new XmlProcessorElement(typeParent.createXmlProcessorFromType(schema, type), this.tagName, this.occurs);
            substitutionGroup.add(this.getTagName(), new Helper(xmlType, xmlProcessorElement));
        } else {
            XmlProcessorElement xmlProcessorElement = new XmlProcessorElement(type.createXmlProcessor(schema), this.tagName, this.occurs);
            substitutionGroup.add(this.getTagName(), new Helper(xmlType, xmlProcessorElement));
        }
    }

    @Nonnull
    public String getTagName() {
        return this.tagName;
    }

    private static class Helper
    implements XmlProcessor {
        private final XmlType xmlTypeParent;
        private final XmlProcessorElement xmlProcessorElement;

        public Helper(XmlType xmlTypeParam, XmlProcessorElement xmlProcessorElementParam) {
            this.xmlTypeParent = xmlTypeParam;
            this.xmlProcessorElement = xmlProcessorElementParam;
        }

        @Override
        public void process(@Nonnull XmlParser xmlParser, @Nonnull Attributes attributes) throws Exception {
            this.xmlProcessorElement.processSubstGroup(xmlParser, this.xmlTypeParent, attributes);
        }
    }
}

