/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.xml.lwxs;

import de.lessvoid.nifty.tools.resourceloader.NiftyResourceLoader;
import de.lessvoid.xml.lwxs.XmlType;
import de.lessvoid.xml.lwxs.elements.Element;
import de.lessvoid.xml.lwxs.elements.SubstitutionGroup;
import de.lessvoid.xml.lwxs.elements.Type;
import de.lessvoid.xml.lwxs.elements.XmlProcessorType;
import de.lessvoid.xml.lwxs.processor.IncludeProcessor;
import de.lessvoid.xml.lwxs.processor.TypeProcessor;
import de.lessvoid.xml.xpp3.Attributes;
import de.lessvoid.xml.xpp3.XmlParser;
import de.lessvoid.xml.xpp3.XmlProcessor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.xmlpull.v1.XmlPullParserFactory;

public class Schema
implements XmlProcessor {
    @Nonnull
    private static final Logger log = Logger.getLogger(Schema.class.getName());
    @Nonnull
    private final Map<String, Type> types = new HashMap<String, Type>();
    @Nullable
    private String packageString;
    @Nullable
    private String root;
    @Nullable
    private String type;
    @Nonnull
    private final XmlPullParserFactory parserFactory;
    @Nonnull
    private final NiftyResourceLoader resourceLoader;

    public Schema(@Nonnull XmlPullParserFactory parserFactory, @Nonnull NiftyResourceLoader resourceLoader) {
        this.parserFactory = parserFactory;
        this.resourceLoader = resourceLoader;
    }

    @Override
    public void process(@Nonnull XmlParser xmlParser, @Nonnull Attributes attributes) throws Exception {
        this.packageString = attributes.get("package");
        if (this.packageString == null) {
            throw new Exception("[package] attribute is a required attribute");
        }
        this.root = attributes.get("root");
        if (this.root == null) {
            throw new Exception("[root] attribute is a required attribute");
        }
        this.type = attributes.get("type");
        if (this.type == null) {
            throw new Exception("[type] attribute is a required attribute");
        }
        xmlParser.nextTag();
        xmlParser.zeroOrMore(new de.lessvoid.xml.xpp3.SubstitutionGroup().add("include", new IncludeProcessor(this.parserFactory, this.resourceLoader, this.types)).add("type", new TypeProcessor(this)));
    }

    public void addType(@Nonnull String name, @Nonnull Type typeParam) {
        this.types.put(name, typeParam);
    }

    @Nonnull
    public Type getType(@Nonnull String name) throws Exception {
        Type t = this.types.get(name);
        if (t == null) {
            log.warning("Type [" + name + "] not found. Creating new one on the fly");
            t = new Type(name, null);
            this.addType(name, t);
        }
        return t;
    }

    public boolean isTypeAvailable(@Nonnull String name) {
        return this.types.containsKey(name);
    }

    @Nonnull
    public XmlType loadXml(@Nonnull XmlParser parser) throws Exception {
        if (this.type == null) {
            throw new Exception("The type is null, something is wrong.");
        }
        Type t = this.getType(this.type);
        XmlProcessorType xmlType = t.createXmlProcessor(this);
        parser.nextTag();
        if (this.root == null) {
            throw new Exception("Root element is not set.");
        }
        parser.required(this.root, xmlType);
        XmlType result = xmlType.getXmlType();
        if (result == null) {
            throw new Exception("Failed to resolve XML data to a proper XML type.");
        }
        return result;
    }

    @Nonnull
    public XmlProcessorType getInstance(@Nonnull String className, @Nonnull Collection<Element> elements, @Nonnull Collection<SubstitutionGroup> substitutionGroups) throws Exception {
        XmlProcessorType processor = new XmlProcessorType(this.packageString + "." + className);
        for (Element child : elements) {
            child.addToProcessor(this, processor);
        }
        for (SubstitutionGroup subst : substitutionGroups) {
            subst.addToProcessor(this, processor);
        }
        return processor;
    }

    @Nonnull
    public Map<String, Type> getTypes() {
        return this.types;
    }
}

