/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.tools.resourceloader;

import de.lessvoid.nifty.tools.resourceloader.ClasspathLocation;
import de.lessvoid.nifty.tools.resourceloader.FileSystemLocation;
import de.lessvoid.nifty.tools.resourceloader.ResourceLocation;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NiftyResourceLoader {
    @Nonnull
    private final List<ResourceLocation> locations = new ArrayList<ResourceLocation>();

    public NiftyResourceLoader() {
        this.locations.add(new ClasspathLocation());
        this.locations.add(new FileSystemLocation(new File(".")));
    }

    public void addResourceLocation(@Nonnull ResourceLocation location) {
        this.locations.add(location);
    }

    public void removeResourceLocation(@Nonnull ResourceLocation location) {
        this.locations.remove(location);
    }

    public void removeAllResourceLocations() {
        this.locations.clear();
    }

    @Nullable
    public InputStream getResourceAsStream(@Nonnull String ref) {
        ResourceLocation location;
        InputStream in = null;
        for (int i = 0; i < this.locations.size() && (in = (location = this.locations.get(i)).getResourceAsStream(ref)) == null; ++i) {
        }
        if (in == null) {
            return null;
        }
        return new BufferedInputStream(in);
    }

    @Nullable
    public URL getResource(@Nonnull String ref) {
        ResourceLocation location;
        URL url = null;
        for (int i = 0; i < this.locations.size() && (url = (location = this.locations.get(i)).getResource(ref)) == null; ++i) {
        }
        return url;
    }
}

