/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.screen;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyStopwatch;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.FocusHandler;
import de.lessvoid.nifty.controls.NiftyControl;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.input.NiftyInputMapping;
import de.lessvoid.nifty.input.NiftyMouseInputEvent;
import de.lessvoid.nifty.input.keyboard.KeyboardInputEvent;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.screen.EndOfScreenAction;
import de.lessvoid.nifty.screen.KeyInputHandler;
import de.lessvoid.nifty.screen.MouseOverHandler;
import de.lessvoid.nifty.screen.ScreenController;
import de.lessvoid.nifty.spi.time.TimeProvider;
import de.lessvoid.nifty.tools.StringHelper;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Screen {
    public int layoutLayersCallCount = 0;
    @Nonnull
    private static final Logger log = Logger.getLogger(Screen.class.getName());
    @Nonnull
    private final String screenId;
    @Nonnull
    private final ScreenController screenController;
    private boolean screenControllerBound = false;
    @Nonnull
    private final List<Element> layerElements = new ArrayList<Element>();
    @Nonnull
    private final Queue<Element> layerElementsToAdd = new LinkedList<Element>();
    @Nonnull
    private final Queue<Element> layerElementsToRemove = new LinkedList<Element>();
    @Nonnull
    private final List<Element> popupElements = new ArrayList<Element>();
    @Nonnull
    private final Queue<Element> popupElementsToAdd = new LinkedList<Element>();
    @Nonnull
    private final Deque<ElementWithEndNotify> popupElementsToRemove = new LinkedList<ElementWithEndNotify>();
    @Nonnull
    private final TimeProvider timeProvider;
    @Nonnull
    private final FocusHandler focusHandler;
    @Nonnull
    private final MouseOverHandler mouseOverHandler;
    @Nonnull
    private final Nifty nifty;
    @Nonnull
    private final List<InputHandlerWithMapping> postInputHandlers = new ArrayList<InputHandlerWithMapping>();
    @Nonnull
    private final List<InputHandlerWithMapping> preInputHandlers = new ArrayList<InputHandlerWithMapping>();
    @Nullable
    private Element rootElement;
    @Nullable
    private String defaultFocusElementId;
    private boolean running = false;
    @Nonnull
    private final Set<String> registeredIds = new HashSet<String>();
    private boolean bound;

    public Screen(@Nonnull Nifty newNifty, @Nonnull String newId, @Nonnull ScreenController newScreenController, @Nonnull TimeProvider newTimeProvider) {
        this.nifty = newNifty;
        this.screenId = newId;
        this.screenController = newScreenController;
        this.timeProvider = newTimeProvider;
        this.focusHandler = new FocusHandler();
        this.mouseOverHandler = new MouseOverHandler();
    }

    public void registerElementId(@Nonnull String id) {
        if (this.registeredIds.contains(id)) {
            log.warning("Possible conflicting id [" + id + "] detected. Consider making all Ids unique or use #id in control-definitions.");
        } else {
            this.registeredIds.add(id);
        }
    }

    public void unregisterElementId(@Nonnull String id) {
        this.registeredIds.remove(id);
    }

    @Nonnull
    public String getScreenId() {
        return this.screenId;
    }

    @Nonnull
    public List<Element> getLayerElements() {
        return this.layerElements;
    }

    public void addLayerElement(@Nonnull Element layerElement) {
        this.layerElementsToAdd.add(layerElement);
    }

    public void removeLayerElement(@Nonnull Element layerElement) {
        this.layerElementsToRemove.add(layerElement);
    }

    public void removeLayerElement(@Nonnull String layerId) {
        for (int i = 0; i < this.layerElements.size(); ++i) {
            Element layer = this.layerElements.get(i);
            if (!layerId.equals(layer.getId())) continue;
            this.removeLayerElement(layer);
            return;
        }
    }

    public void addPopup(@Nonnull Element popup, @Nullable Element defaultFocusElement) {
        EndNotify localEndNotify = new EndNotify(){

            @Override
            public final void perform() {
                for (int i = 0; i < Screen.this.layerElements.size(); ++i) {
                    Element w = (Element)Screen.this.layerElements.get(i);
                    if (!w.isEffectActive(EffectEventId.onStartScreen)) continue;
                    return;
                }
            }
        };
        Element mouseFocusElement = this.focusHandler.getMouseFocusElement();
        if (mouseFocusElement != null) {
            mouseFocusElement.stopEffect(EffectEventId.onHover);
        }
        this.focusHandler.pushState();
        popup.resetEffects();
        popup.layoutElements();
        popup.initControls(true);
        popup.startEffect(EffectEventId.onStartScreen, localEndNotify);
        popup.startEffect(EffectEventId.onActive);
        popup.onStartScreen();
        if (defaultFocusElement != null) {
            defaultFocusElement.setFocus();
        } else {
            this.setDefaultFocus();
        }
        this.addLayerElement(popup);
        this.addPopupElement(popup);
    }

    void addPopupElement(Element popup) {
        this.popupElementsToAdd.add(popup);
    }

    public void closePopup(@Nonnull Element popup, EndNotify closeNotify) {
        popup.onEndScreen(this);
        this.nifty.resetMouseInputEvents();
        this.removeLayerElement(popup);
        this.schedulePopupElementRemoval(new ElementWithEndNotify(popup, closeNotify));
    }

    private void schedulePopupElementRemoval(ElementWithEndNotify elementWithEndNotify) {
        this.popupElementsToRemove.add(elementWithEndNotify);
    }

    public void startScreen() {
        this.startScreen(null);
    }

    public void startScreen(EndNotify startScreenEndNotify) {
        NiftyStopwatch.start();
        this.running = false;
        this.nifty.getRenderEngine().screenStarted(this);
        this.focusHandler.resetFocusElements();
        this.resetLayers();
        this.layoutLayers();
        this.bindControls();
        if (!this.screenControllerBound) {
            this.screenController.bind(this.nifty, this);
            this.screenControllerBound = true;
        }
        this.activeEffectStart();
        StartScreenEndNotify endNotify = this.createScreenStartEndNotify(startScreenEndNotify);
        this.startLayers(EffectEventId.onStartScreen, endNotify);
        this.setDefaultFocus();
        NiftyStopwatch.stop("Screen.startScreen(" + this.layoutLayersCallCount + ")");
    }

    public void endScreen(EndNotify callback) {
        this.resetLayers();
        EndScreenEndNotify endNotify = this.createScreenEndNotify(callback);
        this.startLayers(EffectEventId.onEndScreen, endNotify);
    }

    public void layoutLayers() {
        NiftyStopwatch.start();
        ++this.layoutLayersCallCount;
        for (int i = 0; i < this.layerElements.size(); ++i) {
            Element w = this.layerElements.get(i);
            w.layoutElements();
        }
        NiftyStopwatch.stop("Screen.layoutLayers()");
    }

    private void resetLayers() {
        this.nifty.resetMouseInputEvents();
        for (int i = 0; i < this.layerElements.size(); ++i) {
            Element w = this.layerElements.get(i);
            w.resetEffects();
            w.reactivate();
        }
    }

    private void startLayers(@Nonnull EffectEventId effectEventId, EndNotify endNotify) {
        LocalEndNotify localEndNotify = new LocalEndNotify(effectEventId, endNotify);
        for (int i = 0; i < this.layerElements.size(); ++i) {
            Element w = this.layerElements.get(i);
            w.startEffect(effectEventId, localEndNotify);
            if (effectEventId != EffectEventId.onStartScreen) continue;
            w.onStartScreen();
        }
        localEndNotify.enable();
        localEndNotify.perform();
    }

    public void setDefaultFocus() {
        Element defaultFocus;
        if (this.focusHandler.getKeyboardFocusElement() != null) {
            return;
        }
        if (this.defaultFocusElementId != null && (defaultFocus = this.getFocusHandler().findElement(this.defaultFocusElementId)) != null) {
            defaultFocus.setFocus();
            return;
        }
        Element firstFocus = this.getFocusHandler().getFirstFocusElement();
        if (firstFocus != null) {
            firstFocus.setFocus();
        }
    }

    private void activeEffectStart() {
        for (int i = 0; i < this.layerElements.size(); ++i) {
            Element w = this.layerElements.get(i);
            w.startEffect(EffectEventId.onActive, null);
            if (w.isEnabled()) continue;
            w.startEffect(EffectEventId.onDisabled, null);
        }
    }

    public final void renderLayers(@Nonnull NiftyRenderEngine renderDevice) {
        for (int i = 0; i < this.layerElements.size(); ++i) {
            Element layer = this.layerElements.get(i);
            layer.render(renderDevice);
        }
    }

    public void resetLayout() {
        for (int i = 0; i < this.layerElements.size(); ++i) {
            Element layer = this.layerElements.get(i);
            layer.resetLayout();
        }
    }

    public boolean mouseEvent(@Nonnull NiftyMouseInputEvent inputEvent) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("screen mouseEvent: " + inputEvent.toString());
        }
        if (!this.popupElements.isEmpty()) {
            return this.forwardMouseEventToLayers(this.popupElements, inputEvent);
        }
        return this.forwardMouseEventToLayers(this.layerElements, inputEvent);
    }

    private boolean forwardMouseEventToLayers(@Nonnull List<Element> layerList, @Nonnull NiftyMouseInputEvent inputEvent) {
        this.mouseOverHandler.reset();
        long eventTime = this.timeProvider.getMsTime();
        if (this.focusHandler.hasAnyElementTheMouseFocus()) {
            Element e = this.focusHandler.getMouseFocusElement();
            this.mouseOverHandler.addMouseOverElement(e);
        } else {
            for (int i = 0; i < layerList.size(); ++i) {
                Element layer = layerList.get(i);
                layer.buildMouseOverElements(inputEvent, eventTime, this.mouseOverHandler);
            }
        }
        if (log.isLoggable(Level.FINER)) {
            log.fine(this.mouseOverHandler.getInfoString());
        }
        this.mouseOverHandler.processMouseOverEvent(this.rootElement, inputEvent, eventTime);
        this.mouseOverHandler.processMouseEvent(inputEvent, eventTime);
        return this.mouseOverHandler.hitsElement();
    }

    @Nullable
    @Deprecated
    public Element findElementByName(String name) {
        return this.findElementById(name);
    }

    @Nullable
    public Element findElementById(@Nullable String findId) {
        if (findId == null) {
            return null;
        }
        for (int i = 0; i < this.layerElements.size(); ++i) {
            Element layer = this.layerElements.get(i);
            Element found = layer.findElementById(findId);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Nullable
    public <T extends Controller> T findControl(String elementName, @Nonnull Class<T> requestedControlClass) {
        Element element = this.findElementById(elementName);
        if (element == null) {
            return null;
        }
        return element.getControl(requestedControlClass);
    }

    @Nullable
    public <T extends NiftyControl> T findNiftyControl(@Nullable String elementName, @Nonnull Class<T> requestedControlClass) {
        if (elementName == null) {
            return null;
        }
        Element element = this.findElementById(elementName);
        if (element == null) {
            log.warning("missing element/control with id [" + elementName + "] for requested control class [" + requestedControlClass.getName() + "]");
            return null;
        }
        return element.getNiftyControl(requestedControlClass);
    }

    public void setAlternateKey(@Nullable String alternateKey) {
        for (int i = 0; i < this.layerElements.size(); ++i) {
            Element layer = this.layerElements.get(i);
            layer.setAlternateKey(alternateKey);
        }
    }

    public boolean keyEvent(@Nonnull KeyboardInputEvent inputEvent) {
        InputHandlerWithMapping handler;
        int i;
        for (i = 0; i < this.preInputHandlers.size(); ++i) {
            handler = this.preInputHandlers.get(i);
            if (!handler.process(inputEvent)) continue;
            return true;
        }
        if (this.focusHandler.keyEvent(inputEvent)) {
            return true;
        }
        for (i = 0; i < this.postInputHandlers.size(); ++i) {
            handler = this.postInputHandlers.get(i);
            if (!handler.process(inputEvent)) continue;
            return true;
        }
        return false;
    }

    public void addKeyboardInputHandler(@Nonnull NiftyInputMapping mapping, @Nonnull KeyInputHandler handler) {
        this.postInputHandlers.add(new InputHandlerWithMapping(mapping, handler));
    }

    public void removeKeyboardInputHandler(KeyInputHandler handler) {
        for (int i = 0; i < this.postInputHandlers.size(); ++i) {
            if (!this.postInputHandlers.get(i).getKeyInputHandler().equals(handler)) continue;
            this.postInputHandlers.remove(i);
            return;
        }
    }

    public void addPreKeyboardInputHandler(@Nonnull NiftyInputMapping mapping, @Nonnull KeyInputHandler handler) {
        this.preInputHandlers.add(new InputHandlerWithMapping(mapping, handler));
    }

    public void removePreKeyboardInputHandler(KeyInputHandler handler) {
        for (int i = 0; i < this.preInputHandlers.size(); ++i) {
            if (!this.preInputHandlers.get(i).getKeyInputHandler().equals(handler)) continue;
            this.preInputHandlers.remove(i);
            return;
        }
    }

    @Nonnull
    public String debugOutput() {
        return this.debugOutput(".*", ".*");
    }

    @Nonnull
    public String debugOutputFocusElements() {
        return this.focusHandler.toString();
    }

    @Nonnull
    public String debugOutput(@Nonnull String regexpElement, @Nonnull String regexpAttribute) {
        StringBuffer result = new StringBuffer();
        this.debugOutputLayerElements(regexpElement, regexpAttribute, result, this.layerElements);
        result.append("\n\n### popupElements: ").append(this.popupElements.size());
        this.debugOutputLayerElements(regexpElement, regexpAttribute, result, this.popupElements);
        result.append(this.focusHandler.toString());
        return result.toString();
    }

    private void debugOutputLayerElements(@Nonnull String regexpElement, @Nonnull String regexpAttribute, @Nonnull StringBuffer result, @Nonnull List<Element> layers) {
        for (int i = 0; i < layers.size(); ++i) {
            Element layer = layers.get(i);
            String layerType = " +";
            if (!layer.isVisible()) {
                layerType = " -";
            }
            result.append("\n").append(layerType).append(this.getIdText(layer)).append("\n").append(StringHelper.whitespace(layerType.length())).append(layer.getElementStateString(StringHelper.whitespace(layerType.length()), regexpAttribute));
            result.append(this.outputElement(layer, "   ", regexpElement, regexpAttribute));
        }
    }

    @Nonnull
    public String outputElement(@Nonnull Element w, @Nonnull String offset, @Nonnull String regexpElement, @Nonnull String regexpAttribute) {
        StringBuilder result = new StringBuilder();
        List<Element> wwElements = w.getChildren();
        for (int i = 0; i < wwElements.size(); ++i) {
            Element ww = wwElements.get(i);
            String elementId = this.getIdText(ww);
            if (elementId.matches(regexpElement)) {
                result.append("\n").append(offset).append(elementId).append(" ").append(ww.getElementType().getClass().getSimpleName()).append(" childLayout [").append(ww.getElementType().getAttributes().get("childLayout")).append("]");
                result.append("\n").append(StringHelper.whitespace(offset.length())).append(ww.getElementStateString(StringHelper.whitespace(offset.length()), regexpAttribute));
                result.append(this.outputElement(ww, offset + " ", ".*", regexpAttribute));
                continue;
            }
            result.append(this.outputElement(ww, offset + " ", regexpElement, regexpAttribute));
        }
        return result.toString();
    }

    @Nonnull
    private String getIdText(@Nonnull Element ww) {
        String id = ww.getId();
        if (id == null) {
            return "[---]";
        }
        return "[" + id + "]";
    }

    @Nonnull
    public ScreenController getScreenController() {
        return this.screenController;
    }

    @Nonnull
    public FocusHandler getFocusHandler() {
        return this.focusHandler;
    }

    @Nonnull
    public Element getRootElement() {
        if (this.rootElement == null) {
            throw new IllegalStateException("Requested root element before it was set.");
        }
        return this.rootElement;
    }

    public void setRootElement(@Nonnull Element rootElementParam) {
        this.rootElement = rootElementParam;
        this.rootElement.bindControls(this);
    }

    public void processAddAndRemoveLayerElements() {
        this.layerElements.addAll(this.layerElementsToAdd);
        this.layerElements.removeAll(this.layerElementsToRemove);
        this.layerElementsToAdd.clear();
        this.layerElementsToRemove.clear();
        this.popupElements.addAll(this.popupElementsToAdd);
        this.popupElementsToAdd.clear();
        while (!this.popupElementsToRemove.isEmpty()) {
            this.popupElementsToRemove.pollFirst().remove();
        }
    }

    public boolean hasDynamicElements() {
        return !this.layerElementsToAdd.isEmpty() || !this.layerElementsToRemove.isEmpty() || !this.popupElementsToAdd.isEmpty() || !this.popupElementsToRemove.isEmpty();
    }

    public void setDefaultFocusElement(@Nullable String defaultFocusElementIdParam) {
        this.defaultFocusElementId = defaultFocusElementIdParam;
    }

    @Nullable
    public String getDefaultFocusElementId() {
        return this.defaultFocusElementId;
    }

    @Nonnull
    StartScreenEndNotify createScreenStartEndNotify(EndNotify startScreenEndNotify) {
        return new StartScreenEndNotify(startScreenEndNotify);
    }

    @Nonnull
    EndScreenEndNotify createScreenEndNotify(EndNotify endScreenEndNotify) {
        return new EndScreenEndNotify(endScreenEndNotify);
    }

    public boolean isRunning() {
        return this.running;
    }

    void onStartScreenHasEnded() {
        this.nifty.subscribeAnnotations(this.screenController);
        this.screenController.onStartScreen();
        this.forceMouseHoverUpdate();
        this.running = true;
    }

    private void forceMouseHoverUpdate() {
        NiftyMouseInputEvent event = new NiftyMouseInputEvent();
        event.initialize(this.nifty.getRenderEngine().convertFromNativeX(this.nifty.getNiftyMouse().getX()), this.nifty.getRenderEngine().convertFromNativeY(this.nifty.getNiftyMouse().getY()), 0, false, false, false);
        this.mouseEvent(event);
    }

    void onEndScreenHasEnded() {
        log.fine("onEndScreenHasEnded()");
        this.nifty.unsubscribeAnnotations(this.screenController);
        this.nifty.unsubscribeScreen(this);
        this.screenController.onEndScreen();
        for (int i = 0; i < this.layerElements.size(); ++i) {
            this.layerElements.get(i).onEndScreen(this);
        }
        this.nifty.getRenderEngine().screenEnded(this);
    }

    public boolean isEffectActive(@Nonnull EffectEventId effectEventId) {
        if (!this.popupElements.isEmpty()) {
            return this.isEffectActive(this.popupElements, effectEventId);
        }
        return this.isEffectActive(this.layerElements, effectEventId);
    }

    private boolean isEffectActive(@Nonnull List<Element> elements, @Nonnull EffectEventId effectEventId) {
        for (int i = 0; i < elements.size(); ++i) {
            Element element = elements.get(i);
            if (!element.isEffectActive(effectEventId)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Element getTopMostPopup() {
        if (this.popupElements.isEmpty()) {
            return null;
        }
        return this.popupElements.get(this.popupElements.size() - 1);
    }

    public boolean isActivePopup(@Nonnull String id) {
        for (int i = 0; i < this.popupElements.size(); ++i) {
            if (!id.equals(this.popupElements.get(i).getId())) continue;
            return true;
        }
        return false;
    }

    public boolean isActivePopup(Element element) {
        return this.popupElements.contains(element);
    }

    public boolean isMouseOverElement() {
        return this.mouseOverHandler.hitsElement();
    }

    @Nonnull
    public String getMouseOverInfoString() {
        return this.mouseOverHandler.getInfoString();
    }

    private void bindControls() {
        int i;
        this.bound = true;
        for (i = 0; i < this.layerElements.size(); ++i) {
            this.layerElements.get(i).bindControls(this);
        }
        for (i = 0; i < this.layerElements.size(); ++i) {
            this.layerElements.get(i).initControls(false);
        }
    }

    public boolean isBound() {
        return this.bound;
    }

    public void resetMouseDown() {
        for (int i = 0; i < this.layerElements.size(); ++i) {
            this.layerElements.get(i).resetMouseDown();
        }
    }

    public class ElementWithEndNotify {
        private final Element element;
        private final EndNotify closeNotify;

        public ElementWithEndNotify(Element element, EndNotify closeNotify) {
            this.element = element;
            this.closeNotify = closeNotify;
        }

        public void remove() {
            Screen.this.popupElements.remove(this.element);
            Screen.this.focusHandler.popState();
            if (this.closeNotify != null) {
                this.closeNotify.perform();
            }
            this.element.getNifty().internalPopupRemoved(this.element.getId());
        }
    }

    public static class InputHandlerWithMapping {
        @Nonnull
        private final NiftyInputMapping mapping;
        @Nonnull
        private final KeyInputHandler handler;

        public InputHandlerWithMapping(@Nonnull NiftyInputMapping newMapping, @Nonnull KeyInputHandler newHandler) {
            this.mapping = newMapping;
            this.handler = newHandler;
        }

        @Nonnull
        public KeyInputHandler getKeyInputHandler() {
            return this.handler;
        }

        public boolean process(@Nonnull KeyboardInputEvent inputEvent) {
            NiftyInputEvent event = this.mapping.convert(inputEvent);
            if (event == null) {
                return false;
            }
            return this.handler.keyEvent(event);
        }
    }

    class EndScreenEndNotify
    implements EndNotify {
        @Nullable
        private final EndNotify additionalEndNotify;

        public EndScreenEndNotify(EndNotify additionalEndNotify) {
            this.additionalEndNotify = additionalEndNotify;
        }

        @Override
        public void perform() {
            log.fine("onEndScreen has ended - schedule further processing as end of frame action");
            Screen.this.nifty.scheduleEndOfFrameElementAction(new EndOfScreenAction(Screen.this), this.additionalEndNotify);
        }
    }

    class StartScreenEndNotify
    implements EndNotify {
        @Nullable
        private final EndNotify additionalEndNotify;

        public StartScreenEndNotify(EndNotify additionalEndNotify) {
            this.additionalEndNotify = additionalEndNotify;
        }

        @Override
        public void perform() {
            log.fine("onStartScreen has ended");
            if (this.additionalEndNotify != null) {
                this.additionalEndNotify.perform();
            }
            Screen.this.onStartScreenHasEnded();
        }
    }

    private class LocalEndNotify
    implements EndNotify {
        private boolean enabled = false;
        @Nonnull
        private final EffectEventId effectEventId;
        @Nullable
        private final EndNotify endNotify;

        public LocalEndNotify(@Nullable EffectEventId effectEventIdParam, EndNotify endNotifyParam) {
            this.effectEventId = effectEventIdParam;
            this.endNotify = endNotifyParam;
        }

        public void enable() {
            this.enabled = true;
        }

        @Override
        public void perform() {
            if (this.enabled) {
                for (int i = 0; i < Screen.this.layerElements.size(); ++i) {
                    Element w = (Element)Screen.this.layerElements.get(i);
                    if (!w.isEffectActive(this.effectEventId)) continue;
                    return;
                }
                if (this.endNotify != null) {
                    this.endNotify.perform();
                }
            }
        }
    }
}

