/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render.batch.core;

import de.lessvoid.nifty.render.batch.CheckGL;
import de.lessvoid.nifty.render.batch.GLException;
import de.lessvoid.nifty.render.batch.spi.BufferFactory;
import de.lessvoid.nifty.render.batch.spi.core.CoreGL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CoreTexture2D {
    private static final int AUTO = -1;
    @Nonnull
    private static final Logger LOG = Logger.getLogger(CoreTexture2D.class.getName());
    private static int maxTextureSize = -1;
    private static boolean errorChecks = true;
    @Nonnull
    private final CoreGL gl;
    @Nonnull
    private final IntBuffer textureIdBuffer;
    private boolean isDisposed;
    private final int textureTarget;
    private final int textureId;
    private final int width;
    private final int height;
    private boolean textureCanBeUpdated;
    private int texImageTarget;
    private int texImageLevel;
    private int texImageInternalFormat;
    private int texImageWidth;
    private int texImageHeight;
    private int texBorder;
    private int texFormat;
    private int texType;

    public CoreTexture2D(@Nonnull CoreGL gl, @Nonnull BufferFactory bufferFactory, @Nonnull ColorFormat format, int width, int height, @Nonnull Buffer data, @Nonnull ResizeFilter filter) {
        this(gl, bufferFactory, format, false, width, height, data, filter);
    }

    public CoreTexture2D(@Nonnull CoreGL gl, @Nonnull BufferFactory bufferFactory, @Nonnull ColorFormat format, boolean compressed, int width, int height, @Nonnull Buffer data, @Nonnull ResizeFilter filter) {
        this(gl, bufferFactory, CoreTexture2D.getInternalFormat(gl, format), width, height, compressed ? CoreTexture2D.getCompressedInternalFormat(gl, format) : CoreTexture2D.getFormat(gl, format), data, filter);
    }

    public CoreTexture2D(@Nonnull CoreGL gl, @Nonnull BufferFactory bufferFactory, int internalFormat, int width, int height, int format, @Nonnull Buffer data, @Nonnull ResizeFilter filter) {
        this(gl, bufferFactory, gl.GL_TEXTURE_2D(), internalFormat, width, height, format, data, CoreTexture2D.getMagFilter(gl, filter), CoreTexture2D.getMinFilter(gl, filter));
    }

    public CoreTexture2D(@Nonnull CoreGL gl, @Nonnull BufferFactory bufferFactory, int internalFormat, int width, int height, int format, @Nonnull Buffer data, int magFilter, int minFilter) {
        this(gl, bufferFactory, gl.GL_TEXTURE_2D(), internalFormat, width, height, format, data, magFilter, minFilter);
    }

    public CoreTexture2D(@Nonnull CoreGL gl, @Nonnull BufferFactory bufferFactory, int target, int internalFormat, int width, int height, int format, @Nonnull Buffer data, int magFilter, int minFilter) {
        this(gl, bufferFactory, -1, target, 0, internalFormat, width, height, 0, format, -1, data, magFilter, minFilter);
    }

    public CoreTexture2D(@Nonnull CoreGL gl, @Nonnull BufferFactory bufferFactory, int textureId, int target, int level, int internalFormat, int width, int height, int border, int format, int type, @Nonnull Buffer data, int magFilter, int minFilter) {
        this.gl = gl;
        this.textureIdBuffer = bufferFactory.createNativeOrderedIntBuffer(1);
        this.textureTarget = target;
        this.width = width;
        this.height = height;
        this.textureId = this.createTexture(textureId, target, level, internalFormat, width, height, border, format, type, data, magFilter, minFilter);
    }

    public static int getMaxTextureSize(@Nonnull CoreGL gl) {
        if (maxTextureSize == -1) {
            int[] params = new int[1];
            gl.glGetIntegerv(gl.GL_MAX_TEXTURE_SIZE(), params, 0);
            maxTextureSize = params[0];
            CoreTexture2D.checkGLError(gl, "glGetInteger", true);
        }
        return maxTextureSize;
    }

    public static void disableErrorChecking() {
        errorChecks = false;
    }

    public static void enableErrorChecking() {
        errorChecks = true;
    }

    public void bind() {
        if (this.isDisposed) {
            throw new GLException("This texture was disposed. You can't bind it anymore. It's gone for good.");
        }
        this.gl.glBindTexture(this.textureTarget, this.textureId);
        this.checkGLError("glBindTexture", true);
    }

    public void dispose() {
        this.deleteTexture(this.textureId);
        this.isDisposed = true;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getId() {
        return this.textureId;
    }

    @Nonnull
    public String toString() {
        return CoreTexture2D.class.getName() + '(' + "id:" + this.textureId + ", w:" + this.width + ", h:" + this.height + ')';
    }

    protected void finalize() throws Throwable {
        if (!this.isDisposed) {
            LOG.warning("Memory Leak: Texture " + Integer.toString(this.textureId) + " is getting finalized by the Java GC without being disposed.");
        }
        super.finalize();
    }

    private void applyFilters(int target, int minFilter, int magFilter) {
        this.gl.glTexParameteri(target, this.gl.GL_TEXTURE_MIN_FILTER(), minFilter);
        this.checkGLError("glTexParameteri", true);
        this.gl.glTexParameteri(target, this.gl.GL_TEXTURE_MAG_FILTER(), magFilter);
        this.checkGLError("glTexParameteri", true);
    }

    private int applyTextureId(int target, int textureId) {
        int usedTextureId = textureId == -1 ? this.createTextureID() : textureId;
        this.gl.glBindTexture(target, usedTextureId);
        this.checkGLError("glBindTexture", true);
        return usedTextureId;
    }

    private void checkBorder(int border) {
        if (border != 0 && border != 1) {
            throw new GLException("Border has illegal value: 0x" + Integer.toHexString(border));
        }
    }

    private void checkFormatSizeData(int format, int type, @Nullable Buffer data) {
        if (data == null) {
            throw new GLException("Pixeldata must not be NULL");
        }
        if (type == this.gl.GL_BITMAP() && format != this.gl.GL_COLOR_INDEX()) {
            throw new GLException("GL_BITMAP requires the format to be GL_COLOR_INDEX");
        }
        if (type == this.gl.GL_UNSIGNED_BYTE() || type == this.gl.GL_BYTE() || type == this.gl.GL_BITMAP() || type == this.gl.GL_UNSIGNED_BYTE_3_3_2() || type == this.gl.GL_UNSIGNED_BYTE_2_3_3_REV()) {
            if (!(data instanceof ByteBuffer)) {
                throw new GLException("The selected type requires its data as byte values.");
            }
        } else if (type == this.gl.GL_UNSIGNED_SHORT() || type == this.gl.GL_SHORT() || type == this.gl.GL_UNSIGNED_SHORT_5_6_5() || type == this.gl.GL_UNSIGNED_SHORT_5_6_5_REV() || type == this.gl.GL_UNSIGNED_SHORT_4_4_4_4() || type == this.gl.GL_UNSIGNED_SHORT_4_4_4_4_REV() || type == this.gl.GL_UNSIGNED_SHORT_5_5_5_1() || type == this.gl.GL_UNSIGNED_SHORT_1_5_5_5_REV()) {
            if (!(data instanceof ShortBuffer)) {
                throw new GLException("The selected type requires its data as short values.");
            }
        } else if (type == this.gl.GL_UNSIGNED_INT() || type == this.gl.GL_INT() || type == this.gl.GL_UNSIGNED_INT_8_8_8_8() || type == this.gl.GL_UNSIGNED_INT_8_8_8_8_REV() || type == this.gl.GL_UNSIGNED_INT_10_10_10_2() || type == this.gl.GL_UNSIGNED_INT_2_10_10_10_REV()) {
            if (!(data instanceof IntBuffer)) {
                throw new GLException("The selected type requires its data as integer values.");
            }
        } else if (type == this.gl.GL_FLOAT()) {
            if (!(data instanceof FloatBuffer) && !(data instanceof DoubleBuffer)) {
                throw new GLException("The selected type requires its data as floating-point values.");
            }
        } else {
            throw new GLException("Unknown type value.");
        }
    }

    private static void checkGLError(@Nonnull CoreGL gl, @Nonnull String message, boolean throwException) {
        if (errorChecks) {
            CheckGL.checkGLError(gl, message, throwException);
        }
    }

    private void checkGLError(@Nonnull String message, boolean throwException) {
        if (errorChecks) {
            CheckGL.checkGLError(this.gl, message, throwException);
        }
    }

    private void checkTarget(int target) {
        if (target != this.gl.GL_TEXTURE_2D() && target != this.gl.GL_TEXTURE_CUBE_MAP_POSITIVE_X() && target != this.gl.GL_TEXTURE_CUBE_MAP_NEGATIVE_X() && target != this.gl.GL_TEXTURE_CUBE_MAP_POSITIVE_Y() && target != this.gl.GL_TEXTURE_CUBE_MAP_NEGATIVE_Y() && target != this.gl.GL_TEXTURE_CUBE_MAP_POSITIVE_Z() && target != this.gl.GL_TEXTURE_CUBE_MAP_NEGATIVE_Z()) {
            throw new GLException("Illegal target ID: 0x" + Integer.toHexString(target));
        }
    }

    private int createTexture(int textureId, int target, int level, int internalFormat, int width, int height, int border, int format, int type, Buffer data, int magFilter, int minFilter) {
        int usedType = this.getType(type, data);
        if (errorChecks) {
            this.checkTarget(target);
            this.checkBorder(border);
            CheckGL.checkGLTextureSize(this.gl, width - 2 * border, height - 2 * border);
            this.checkFormatSizeData(format, usedType, data);
        }
        int usedTextureId = this.applyTextureId(target, textureId);
        try {
            this.applyFilters(target, minFilter, magFilter);
            if (this.isCreatingMipMaps(level, minFilter)) {
                this.glTexImage2D(target, 0, internalFormat, width, height, border, format, usedType, data);
                this.gl.glGenerateMipmap(target);
                this.checkGLError("glGenerateMipmap", true);
            } else {
                this.glTexImage2D(target, level, internalFormat, width, height, border, format, usedType, data);
            }
        }
        catch (GLException ex) {
            if (textureId == -1) {
                this.deleteTexture(usedTextureId);
            }
            throw ex;
        }
        return usedTextureId;
    }

    private void deleteTexture(int textureId) {
        this.textureIdBuffer.clear();
        this.textureIdBuffer.put(0, textureId);
        this.gl.glDeleteTextures(1, this.textureIdBuffer);
        this.checkGLError("glDeleteTextures", false);
    }

    private int createTextureID() {
        this.textureIdBuffer.clear();
        this.gl.glGenTextures(1, this.textureIdBuffer);
        this.checkGLError("glGenTextures", true);
        return this.textureIdBuffer.get(0);
    }

    private int getType(int type, Buffer data) {
        if (type == -1) {
            if (data instanceof ByteBuffer) {
                return this.gl.GL_UNSIGNED_BYTE();
            }
            if (data instanceof ShortBuffer) {
                return this.gl.GL_UNSIGNED_SHORT();
            }
            if (data instanceof IntBuffer) {
                return this.gl.GL_UNSIGNED_INT();
            }
            if (data instanceof FloatBuffer) {
                return this.gl.GL_FLOAT();
            }
            if (data instanceof DoubleBuffer) {
                return this.gl.GL_FLOAT();
            }
            throw new GLException("Unknown buffer type; " + data.getClass().toString());
        }
        return type;
    }

    private void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, Buffer pixels) {
        this.texImageTarget = target;
        this.texImageLevel = level;
        this.texImageInternalFormat = internalformat;
        this.texImageWidth = width;
        this.texImageHeight = height;
        this.texBorder = border;
        this.texFormat = format;
        this.texType = type;
        this.textureCanBeUpdated = true;
        this.updateTextureData(pixels);
    }

    public void updateTextureData(Buffer pixels) {
        if (!this.textureCanBeUpdated) {
            throw new GLException("updateTextureData() call can only be used to update texture data");
        }
        if (pixels instanceof ByteBuffer) {
            this.gl.glTexImage2D(this.texImageTarget, this.texImageLevel, this.texImageInternalFormat, this.texImageWidth, this.texImageHeight, this.texBorder, this.texFormat, this.texType, (ByteBuffer)pixels);
        } else if (pixels instanceof ShortBuffer) {
            this.gl.glTexImage2D(this.texImageTarget, this.texImageLevel, this.texImageInternalFormat, this.texImageWidth, this.texImageHeight, this.texBorder, this.texFormat, this.texType, (ShortBuffer)pixels);
        } else if (pixels instanceof IntBuffer) {
            this.gl.glTexImage2D(this.texImageTarget, this.texImageLevel, this.texImageInternalFormat, this.texImageWidth, this.texImageHeight, this.texBorder, this.texFormat, this.texType, (IntBuffer)pixels);
        } else if (pixels instanceof FloatBuffer) {
            this.gl.glTexImage2D(this.texImageTarget, this.texImageLevel, this.texImageInternalFormat, this.texImageWidth, this.texImageHeight, this.texBorder, this.texFormat, this.texType, (FloatBuffer)pixels);
        } else if (pixels instanceof DoubleBuffer) {
            this.gl.glTexImage2D(this.texImageTarget, this.texImageLevel, this.texImageInternalFormat, this.texImageWidth, this.texImageHeight, this.texBorder, this.texFormat, this.texType, (DoubleBuffer)pixels);
        } else {
            throw new GLException("Unknown buffer type; " + pixels.getClass().toString());
        }
        this.checkGLError("glTexImage2D", true);
    }

    private boolean isCreatingMipMaps(int level, int minFilter) {
        return level <= 0 && (minFilter == this.gl.GL_NEAREST_MIPMAP_NEAREST() || minFilter == this.gl.GL_LINEAR_MIPMAP_NEAREST() || minFilter == this.gl.GL_NEAREST_MIPMAP_LINEAR() || minFilter == this.gl.GL_LINEAR_MIPMAP_LINEAR());
    }

    private static int getMinFilter(@Nonnull CoreGL gl, @Nonnull ResizeFilter resizeFilter) {
        switch (resizeFilter) {
            case Nearest: {
                return gl.GL_NEAREST();
            }
            case Linear: {
                return gl.GL_LINEAR();
            }
            case NearestMipMapNearest: {
                return gl.GL_NEAREST_MIPMAP_NEAREST();
            }
            case NearestMipMapLinear: {
                return gl.GL_NEAREST_MIPMAP_LINEAR();
            }
            case LinearMipMapNearest: {
                return gl.GL_LINEAR_MIPMAP_NEAREST();
            }
            case LinearMipMapLinear: {
                return gl.GL_LINEAR_MIPMAP_LINEAR();
            }
        }
        throw new GLException("Unknown ResizeFilter value for minimizing filter!");
    }

    private static int getMagFilter(@Nonnull CoreGL gl, @Nonnull ResizeFilter resizeFilter) {
        switch (resizeFilter) {
            case Nearest: {
                return gl.GL_NEAREST();
            }
            case Linear: {
                return gl.GL_LINEAR();
            }
            case NearestMipMapNearest: {
                return gl.GL_NEAREST();
            }
            case NearestMipMapLinear: {
                return gl.GL_LINEAR();
            }
            case LinearMipMapNearest: {
                return gl.GL_LINEAR();
            }
            case LinearMipMapLinear: {
                return gl.GL_LINEAR();
            }
        }
        throw new GLException("Unknown ResizeFilter value for magnifying filter!");
    }

    private static int getFormat(@Nonnull CoreGL gl, @Nonnull ColorFormat colorFormat) {
        switch (colorFormat) {
            case Red: {
                return gl.GL_RED();
            }
            case Green: {
                return gl.GL_GREEN();
            }
            case Blue: {
                return gl.GL_BLUE();
            }
            case Alpha: {
                return gl.GL_ALPHA();
            }
            case RGB: {
                return gl.GL_RGB();
            }
            case BGR: {
                return gl.GL_BGR();
            }
            case RGBA: {
                return gl.GL_RGBA();
            }
            case BGRA: {
                return gl.GL_BGRA();
            }
            case Luminance: {
                return gl.GL_LUMINANCE();
            }
            case LuminanceAlpha: {
                return gl.GL_LUMINANCE_ALPHA();
            }
        }
        throw new GLException("Unknown ColorFormat value for pixel data format!");
    }

    private static int getInternalFormat(@Nonnull CoreGL gl, @Nonnull ColorFormat colorFormat) {
        switch (colorFormat) {
            case Red: {
                return gl.GL_RGB();
            }
            case Green: {
                return gl.GL_RGB();
            }
            case Blue: {
                return gl.GL_RGB();
            }
            case Alpha: {
                return gl.GL_ALPHA();
            }
            case RGB: {
                return gl.GL_RGB();
            }
            case BGR: {
                return gl.GL_RGB();
            }
            case RGBA: {
                return gl.GL_RGBA();
            }
            case BGRA: {
                return gl.GL_RGBA();
            }
            case Luminance: {
                return gl.GL_LUMINANCE();
            }
            case LuminanceAlpha: {
                return gl.GL_LUMINANCE_ALPHA();
            }
        }
        throw new GLException("Unknown ColorFormat value for internal texture format!");
    }

    private static int getCompressedInternalFormat(@Nonnull CoreGL gl, @Nonnull ColorFormat colorFormat) {
        switch (colorFormat) {
            case Red: {
                return gl.GL_COMPRESSED_RGB();
            }
            case Green: {
                return gl.GL_COMPRESSED_RGB();
            }
            case Blue: {
                return gl.GL_COMPRESSED_RGB();
            }
            case Alpha: {
                return gl.GL_COMPRESSED_ALPHA();
            }
            case RGB: {
                return gl.GL_COMPRESSED_RGB();
            }
            case BGR: {
                return gl.GL_COMPRESSED_RGB();
            }
            case RGBA: {
                return gl.GL_COMPRESSED_RGBA();
            }
            case BGRA: {
                return gl.GL_COMPRESSED_RGBA();
            }
            case Luminance: {
                return gl.GL_COMPRESSED_LUMINANCE();
            }
            case LuminanceAlpha: {
                return gl.GL_COMPRESSED_LUMINANCE_ALPHA();
            }
        }
        throw new GLException("Unknown ColorFormat value for compressed internal texture format!");
    }

    public static enum ColorFormat {
        Red,
        Green,
        Blue,
        Alpha,
        RGB,
        BGR,
        RGBA,
        BGRA,
        Luminance,
        LuminanceAlpha;

    }

    public static enum ResizeFilter {
        Nearest,
        Linear,
        NearestMipMapNearest,
        NearestMipMapLinear,
        LinearMipMapNearest,
        LinearMipMapLinear;

    }
}

