/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render.batch;

import de.lessvoid.nifty.render.batch.GLException;
import de.lessvoid.nifty.render.batch.spi.GL;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class CheckGL {
    @Nonnull
    private static final Logger log = Logger.getLogger(CheckGL.class.getName());

    public static void checkGLError(@Nonnull GL gl) {
        CheckGL.checkGLError(gl, "");
    }

    public static void checkGLError(@Nonnull GL gl, @Nonnull String message) {
        CheckGL.checkGLError(gl, message, false);
    }

    public static void checkGLError(@Nonnull GL gl, @Nonnull String message, boolean throwException) {
        int error = gl.glGetError();
        boolean hasError = false;
        while (error != gl.GL_NO_ERROR()) {
            hasError = true;
            String glerrmsg = CheckGL.getGlErrorMessage(gl, error);
            StringBuilder stacktrace = new StringBuilder();
            for (StackTraceElement strackTraceElement : Thread.currentThread().getStackTrace()) {
                stacktrace.append(strackTraceElement.toString());
                stacktrace.append("\n");
            }
            log.warning("OpenGL Error: (" + error + ") " + glerrmsg + " {" + message + "} " + stacktrace.toString());
            error = gl.glGetError();
        }
        if (hasError && throwException) {
            throw new GLException("OpenGL Error occurred:" + message);
        }
    }

    public static void checkGLTextureSize(@Nonnull GL gl, int textureWidth, int textureHeight) {
        int maxSize = CheckGL.getMaxTextureSize(gl);
        if (textureWidth > maxSize || textureHeight > maxSize) {
            throw new GLException("Attempt to allocate a texture to big for the current hardware");
        }
        if (textureWidth < 0) {
            throw new GLException("Attempt to allocate a texture with a width value below 0.");
        }
        if (textureHeight < 0) {
            throw new GLException("Attempt to allocate a texture with a height value below 0.");
        }
    }

    private static int getMaxTextureSize(@Nonnull GL gl) {
        int[] params = new int[1];
        gl.glGetIntegerv(gl.GL_MAX_TEXTURE_SIZE(), params, 0);
        int maxTextureSize = params[0];
        CheckGL.checkGLError(gl, "glGetInteger", true);
        return maxTextureSize;
    }

    @Nonnull
    private static String getGlErrorMessage(GL gl, int error) {
        if (error == gl.GL_INVALID_ENUM()) {
            return "Invalid enum";
        }
        if (error == gl.GL_INVALID_VALUE()) {
            return "Invalid value";
        }
        if (error == gl.GL_INVALID_OPERATION()) {
            return "Invalid operation";
        }
        if (error == gl.GL_STACK_OVERFLOW()) {
            return "Stack overflow";
        }
        if (error == gl.GL_STACK_UNDERFLOW()) {
            return "Stack underflow";
        }
        if (error == gl.GL_OUT_OF_MEMORY()) {
            return "Out of memory";
        }
        return "";
    }
}

