/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render.batch;

import de.lessvoid.nifty.render.batch.TextureAtlasGenerator;
import de.lessvoid.nifty.render.batch.spi.BatchRenderBackend;
import de.lessvoid.nifty.spi.render.RenderImage;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BatchRenderImage
implements RenderImage {
    @Nonnull
    private static final Logger log = Logger.getLogger(BatchRenderImage.class.getName());
    @Nonnull
    private static Map<Integer, TextureSize> textureSizes = new HashMap<Integer, TextureSize>();
    @Nonnull
    private final BatchRenderBackend.Image image;
    @Nonnull
    private final String filename;
    @Nonnull
    private final BatchRenderBackend renderBackend;
    @Nonnull
    private TextureAtlasGenerator generator;
    private int x;
    private int y;
    private int textureId;
    private boolean isUploaded;
    private boolean shouldUnload;
    private boolean uploadFailed;
    @Nullable
    private TextureAtlasGenerator.Result result;

    public BatchRenderImage(@Nonnull BatchRenderBackend.Image image, @Nonnull String filename, @Nonnull BatchRenderBackend renderBackend, @Nonnull TextureAtlasGenerator generator, int atlasTextureId, boolean shouldUnload) {
        this.image = image;
        this.filename = filename;
        this.generator = generator;
        this.renderBackend = renderBackend;
        this.shouldUnload = shouldUnload;
        this.textureId = atlasTextureId;
        this.x = 0;
        this.y = 0;
        this.isUploaded = false;
        this.uploadFailed = false;
    }

    @Nullable
    public static TextureSize getTextureSize(int textureId) {
        return textureSizes.get(textureId);
    }

    @Override
    public int getWidth() {
        return this.image.getWidth();
    }

    @Override
    public int getHeight() {
        return this.image.getHeight();
    }

    @Override
    public void dispose() {
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getTextureId() {
        return this.textureId;
    }

    public boolean isUploaded() {
        return this.isUploaded;
    }

    public void markAsUnloaded() {
        if (this.shouldUnload) {
            this.isUploaded = false;
            this.uploadFailed = false;
            log.fine("image [" + this.filename + "] marked as unloaded");
        }
    }

    public String toString() {
        return super.toString() + " {" + this.filename + "}";
    }

    public void upload() {
        if (this.isUploaded || this.uploadFailed) {
            return;
        }
        this.preProcessImageUpload();
        if (this.imageWillFitInAtlas()) {
            this.uploadImageToAtlas();
        } else if (this.imageExceedsAtlasTolerance()) {
            this.uploadNonAtlasImage();
        } else {
            this.uploadFailedBecauseAtlasIsFull();
        }
    }

    public void reUpload(int atlasTextureId, @Nonnull TextureAtlasGenerator generator) {
        this.textureId = atlasTextureId;
        this.generator = generator;
        this.isUploaded = false;
        this.uploadFailed = false;
        this.upload();
    }

    public boolean uploadFailedPermanently() {
        return this.uploadFailed && this.imageExceedsAtlasTolerance();
    }

    public void unload() {
        if (!this.isUploaded || !this.shouldUnload) {
            return;
        }
        this.preProcessImageUnloading();
        if (this.imageExistsInAtlas()) {
            this.unloadImageFromAtlas();
        } else if (this.existsAsNonAtlasImage()) {
            this.unloadNonAtlasImage();
        } else {
            this.unloadFailed();
        }
        this.isUploaded = false;
    }

    private void preProcessImageUpload() {
        this.result = this.generator.addImage(this.image.getWidth(), this.image.getHeight(), this.filename);
    }

    private boolean imageWillFitInAtlas() {
        return this.result != null;
    }

    private void uploadImageToAtlas() {
        assert (this.result != null);
        this.renderBackend.addImageToAtlas(this.image, this.result.getX(), this.result.getY(), this.textureId);
        BatchRenderImage.registerTextureSize(this.textureId, this.generator.getAtlasWidth(), this.generator.getAtlasHeight());
        this.x = this.result.getX();
        this.y = this.result.getY();
        this.isUploaded = true;
        log.info("Image [" + this.filename + "] uploaded to atlas (atlas texture id: " + this.textureId + ").");
    }

    private static void registerTextureSize(int textureId, int textureWidth, int textureHeight) {
        textureSizes.put(textureId, new TextureSize(textureWidth, textureHeight));
    }

    private boolean imageExceedsAtlasTolerance() {
        return !this.generator.shouldAddImage(this.image.getWidth(), this.image.getHeight());
    }

    private void uploadNonAtlasImage() {
        int textureId = this.createNonAtlasTexture();
        if (this.isCreatedNonAtlasTexture(textureId)) {
            this.uploadNonAtlasImageSuccessful(textureId);
        } else {
            this.uploadNonAtlasImageFailed();
        }
    }

    private int createNonAtlasTexture() {
        return this.renderBackend.createNonAtlasTexture(this.image);
    }

    private boolean isCreatedNonAtlasTexture(int textureId) {
        return this.renderBackend.existsNonAtlasTexture(textureId);
    }

    private void uploadNonAtlasImageSuccessful(int textureId) {
        this.textureId = textureId;
        BatchRenderImage.registerTextureSize(textureId, this.getWidth(), this.getHeight());
        this.isUploaded = true;
        log.info("Image [" + this.filename + "] is not within atlas tolerance and has been created as a non-atlas texture (texture id: " + textureId + ").");
    }

    private void uploadNonAtlasImageFailed() {
        log.severe("Image [" + this.filename + "] is not within atlas tolerance but could not be created as a non-atlas texture.\nThis image will be missing from your screen. Some of the possible causes could be:\n1) Your BatchRenderBackend doesn't support non-atlas textures.\n2) There is a compatibility issue between your gpu and the image (size, format, file type, etc).\n3) You don't have enough memory to create the image.\n\nFor support, please create a new issue at https://github.com/void256/nifty-gui");
        this.uploadFailed = true;
        this.textureId = -1;
    }

    private void uploadFailedBecauseAtlasIsFull() {
        log.info("Image [" + this.filename + "] did not fit into the texture atlas, yet it is within atlas tolerance.\nThe current atlas (atlas texture id: " + this.textureId + ") is too full to hold this image.");
        this.uploadFailed = true;
        this.textureId = -1;
    }

    private void preProcessImageUnloading() {
        this.result = this.generator.removeImage(this.filename);
    }

    private boolean imageExistsInAtlas() {
        return this.result != null;
    }

    private void unloadImageFromAtlas() {
        assert (this.result != null);
        this.renderBackend.removeImageFromAtlas(this.image, this.result.getX(), this.result.getY(), this.result.getOriginalImageWidth(), this.result.getOriginalImageHeight(), this.textureId);
        log.info("Image [" + this.filename + "] unloaded from texture atlas (atlas texture id: " + this.textureId + ").");
    }

    private static void deregisterTextureSize(int textureId) {
        textureSizes.remove(textureId);
    }

    private boolean existsAsNonAtlasImage() {
        return this.renderBackend.existsNonAtlasTexture(this.textureId);
    }

    private void unloadNonAtlasImage() {
        this.renderBackend.deleteNonAtlasTexture(this.textureId);
        BatchRenderImage.deregisterTextureSize(this.textureId);
        log.info("Image [" + this.filename + "] unloaded (non-atlas texture, texture id: " + this.textureId + ")");
    }

    private void unloadFailed() {
        log.warning("Failed to unload image [" + this.filename + "] because its associated texture (texture id: " + this.textureId + ") could not be found.");
    }

    public static class TextureSize {
        private final int width;
        private final int height;

        public TextureSize(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

