/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render.batch;

import de.lessvoid.nifty.render.BlendMode;
import de.lessvoid.nifty.render.batch.BatchRenderConfiguration;
import de.lessvoid.nifty.render.batch.BatchRenderFont;
import de.lessvoid.nifty.render.batch.BatchRenderImage;
import de.lessvoid.nifty.render.batch.TextureAtlasGenerator;
import de.lessvoid.nifty.render.batch.spi.BatchRenderBackend;
import de.lessvoid.nifty.spi.render.MouseCursor;
import de.lessvoid.nifty.spi.render.RenderDevice;
import de.lessvoid.nifty.spi.render.RenderFont;
import de.lessvoid.nifty.spi.render.RenderImage;
import de.lessvoid.nifty.spi.time.TimeProvider;
import de.lessvoid.nifty.spi.time.impl.AccurateTimeProvider;
import de.lessvoid.nifty.tools.Color;
import de.lessvoid.nifty.tools.ColorValueParser;
import de.lessvoid.nifty.tools.resourceloader.NiftyResourceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jglfont.JGLFontFactory;
import org.jglfont.spi.JGLFontRenderer;
import org.jglfont.spi.ResourceLoader;

public class BatchRenderDevice
implements RenderDevice {
    @Nonnull
    private static Logger log = Logger.getLogger(BatchRenderDevice.class.getName());
    @Nonnull
    private final BatchRenderBackend renderBackend;
    @Nonnull
    private final TimeProvider timeProvider = new AccurateTimeProvider();
    private int viewportWidth = -1;
    private int viewportHeight = -1;
    private long time;
    private long frames = 0L;
    private int glyphCount = 0;
    private int quadCount = 0;
    private int currentTextureId = -1;
    private boolean displayFPS = false;
    private boolean logFPS = false;
    private boolean shouldStartNewBatch = true;
    @Nullable
    private RenderFont fpsFont = null;
    @Nullable
    private BatchRenderImage thePlainImage = null;
    @Nonnull
    private BlendMode currentBlendMode = BlendMode.BLEND;
    @Nonnull
    private StringBuilder buffer = new StringBuilder();
    @Nonnull
    private Color fontColor = new Color("#f00");
    @Nonnull
    private final Set<BatchRenderFont> fontCache = new HashSet<BatchRenderFont>();
    @Nonnull
    private final Clipping clipping = new Clipping(0, 0, 0, 0, false);
    @Nonnull
    private Rect originalQuad = new Rect(0, 0, 0, 0);
    @Nonnull
    private Rect clippedQuad = new Rect(0, 0, 0, 0);
    @Nonnull
    private Rect clippedQuadTexture = new Rect(0, 0, 0, 0);
    @Nonnull
    private final Map<Integer, TextureAtlasGenerator> textureAtlasGenerators = new HashMap<Integer, TextureAtlasGenerator>();
    @Nonnull
    private final Map<String, BatchRenderImage> imageCache = new HashMap<String, BatchRenderImage>();
    @Nullable
    private BatchRenderImage.TextureSize currentTextureSize = null;
    @Nonnull
    private final FontRenderer fontRenderer;
    @Nonnull
    private final JGLFontFactory factory;
    private int currentAtlasTextureId;
    @Nonnull
    private NiftyResourceLoader resourceLoader;
    @Nonnull
    private BatchRenderConfiguration renderConfig;
    @Nonnull
    private List<Integer> atlasTextureIds = new ArrayList<Integer>();
    @Nonnull
    private ListIterator<Integer> atlasTextureIdIterator = this.atlasTextureIds.listIterator();

    public BatchRenderDevice(@Nonnull BatchRenderBackend renderBackend) {
        this(renderBackend, new BatchRenderConfiguration());
    }

    public BatchRenderDevice(@Nonnull BatchRenderBackend renderBackend, @Nonnull BatchRenderConfiguration renderConfig) {
        this.renderBackend = renderBackend;
        renderBackend.useHighQualityTextures(renderConfig.useHighQualityTextures);
        renderBackend.fillRemovedImagesInAtlas(renderConfig.fillRemovedImagesInAtlas);
        this.renderConfig = renderConfig;
        this.time = this.timeProvider.getMsTime();
        this.fontRenderer = new FontRenderer(this);
        this.factory = new JGLFontFactory(this.fontRenderer, new ResourceLoader(){

            @Override
            public InputStream load(String path) {
                if (BatchRenderDevice.this.resourceLoader == null) {
                    return null;
                }
                return BatchRenderDevice.this.resourceLoader.getResourceAsStream(path);
            }
        });
        this.createInitialTextureAtlases();
    }

    public void enableLogFPS() {
        log.finest("enableLogFPS()");
        this.logFPS = true;
    }

    public void setDisplayFPS(boolean newValue) {
        if (newValue != this.displayFPS) {
            this.displayFPS = newValue;
            if (this.resourceLoader != null && this.fpsFont == null && this.displayFPS) {
                this.fpsFont = this.createFont("fps.fnt");
            }
        }
    }

    @Override
    public void setResourceLoader(@Nonnull NiftyResourceLoader resourceLoader) {
        log.finest("setResourceLoader()");
        this.resourceLoader = resourceLoader;
        if (this.displayFPS) {
            this.fpsFont = this.createFont("fps.fnt");
        }
        this.renderBackend.setResourceLoader(resourceLoader);
    }

    @Override
    public int getWidth() {
        log.finest("getWidth()");
        if (this.viewportWidth == -1) {
            this.getViewport();
        }
        return this.viewportWidth;
    }

    @Override
    public int getHeight() {
        log.finest("getHeight()");
        if (this.viewportHeight == -1) {
            this.getViewport();
        }
        return this.viewportHeight;
    }

    private void getViewport() {
        this.viewportWidth = this.renderBackend.getWidth();
        this.viewportHeight = this.renderBackend.getHeight();
    }

    @Override
    public void beginFrame() {
        log.finest("beginFrame()");
        this.renderBackend.beginFrame();
        this.currentBlendMode = BlendMode.BLEND;
        this.clipping.setEnabled(false);
        this.clipping.setToViewport();
        this.clipping.resetDiscardCount();
        this.shouldStartNewBatch = true;
        this.quadCount = 0;
        this.glyphCount = 0;
    }

    @Override
    public void endFrame() {
        log.finest("endFrame");
        log.fine("completely clipped elements: " + this.clipping.getDiscardCount());
        if (this.displayFPS && this.fpsFont != null) {
            this.renderFont(this.fpsFont, this.buffer.toString(), 10, this.getHeight() - this.fpsFont.getHeight() - 10, this.fontColor, 1.0f, 1.0f);
        }
        int batches = this.renderBackend.render();
        this.renderBackend.endFrame();
        ++this.frames;
        long diff = this.timeProvider.getMsTime() - this.time;
        if (diff >= 1000L) {
            this.time += diff;
            long lastFrames = this.frames;
            this.buffer.setLength(0);
            this.buffer.append("FPS: ");
            this.buffer.append(lastFrames);
            this.buffer.append(" (");
            this.buffer.append(String.format("%f", Float.valueOf(1000.0f / (float)lastFrames)));
            this.buffer.append(" ms)");
            this.buffer.append(", Total Tri: ");
            this.buffer.append(this.quadCount * 2);
            this.buffer.append(" (Text: ");
            this.buffer.append(this.glyphCount * 2);
            this.buffer.append(")");
            this.buffer.append(", Total Vert: ");
            this.buffer.append(this.quadCount * 4);
            this.buffer.append(" (Text: ");
            this.buffer.append(this.glyphCount * 4);
            this.buffer.append("), Batches: ");
            this.buffer.append(batches);
            if (this.logFPS) {
                System.out.println(this.buffer.toString());
            }
            this.frames = 0L;
        }
        this.viewportWidth = -1;
        this.viewportHeight = -1;
    }

    @Override
    public void clear() {
        log.finest("clear()");
        this.renderBackend.clear();
    }

    @Override
    @Nullable
    public RenderImage createImage(@Nonnull String filename, boolean filterLinear) {
        if (!this.renderConfig.disposeImagesBetweenScreens && this.imageCache.containsKey(filename)) {
            return this.imageCache.get(filename);
        }
        log.finest("createImage()");
        BatchRenderImage batchRenderImage = new BatchRenderImage(this.renderBackend.loadImage(filename), filename, this.renderBackend, this.getCurrentTextureAtlasGenerator(), this.getCurrentAtlasTextureId(), this.renderConfig.disposeImagesBetweenScreens);
        if (!this.renderConfig.disposeImagesBetweenScreens) {
            this.imageCache.put(filename, batchRenderImage);
        }
        return batchRenderImage;
    }

    @Override
    @Nonnull
    public RenderFont createFont(@Nonnull String filename) {
        log.finest("createFont()");
        if (this.resourceLoader == null) {
            throw new RuntimeException("Can't create font without ResourceLoader instance.");
        }
        try {
            BatchRenderFont batchRenderFont = new BatchRenderFont(this, filename, this.factory, this.resourceLoader);
            this.fontCache.add(batchRenderFont);
            return batchRenderFont;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void disposeFont(BatchRenderFont batchRenderFont) {
        this.fontCache.remove(batchRenderFont);
    }

    @Override
    public void renderQuad(int x, int y, int width, int height, @Nonnull Color color) {
        log.finest("renderQuad()");
        BatchRenderImage plainImage = this.getPlainImage();
        this.addQuad(x, y, width, height, color, color, color, color, plainImage.getX(), plainImage.getY(), plainImage.getWidth(), plainImage.getHeight(), plainImage.getTextureId());
    }

    @Override
    public void renderQuad(int x, int y, int width, int height, @Nonnull Color topLeft, @Nonnull Color topRight, @Nonnull Color bottomRight, @Nonnull Color bottomLeft) {
        log.finest("renderQuad2()");
        BatchRenderImage plainImage = this.getPlainImage();
        this.addQuad(x, y, width, height, topLeft, topRight, bottomLeft, bottomRight, plainImage.getX(), plainImage.getY(), plainImage.getWidth(), plainImage.getHeight(), plainImage.getTextureId());
    }

    @Override
    public void renderImage(@Nonnull RenderImage image, int x, int y, int width, int height, @Nonnull Color c, float scale) {
        log.finest("renderImage()");
        if (width < 0) {
            log.warning("Attempted to render image with negative width");
            return;
        }
        if (height < 0) {
            log.warning("Attempted to render image with negative height");
            return;
        }
        BatchRenderImage img = (BatchRenderImage)image;
        this.uploadImageInternal(img);
        float centerX = (float)x + (float)width / 2.0f;
        float centerY = (float)y + (float)height / 2.0f;
        int ix = Math.round(centerX - (float)width * scale / 2.0f);
        int iy = Math.round(centerY - (float)height * scale / 2.0f);
        int iw = Math.round((float)width * scale);
        int ih = Math.round((float)height * scale);
        this.addQuad(ix, iy, iw, ih, c, c, c, c, img.getX(), img.getY(), img.getWidth(), img.getHeight(), img.getTextureId());
    }

    @Override
    public void renderImage(@Nonnull RenderImage image, int x, int y, int w, int h, int srcX, int srcY, int srcW, int srcH, @Nonnull Color c, float scale, int centerX, int centerY) {
        log.finest("renderImage2()");
        if (w < 0) {
            log.warning("Attempted to render image with negative width");
            return;
        }
        if (h < 0) {
            log.warning("Attempted to render image with negative height");
            return;
        }
        int ix = Math.round(-scale * (float)centerX + scale * (float)x + (float)centerX);
        int iy = Math.round(-scale * (float)centerY + scale * (float)y + (float)centerY);
        int iw = Math.round((float)w * scale);
        int ih = Math.round((float)h * scale);
        BatchRenderImage img = (BatchRenderImage)image;
        this.uploadImageInternal(img);
        this.addQuad(ix, iy, iw, ih, c, c, c, c, img.getX() + srcX, img.getY() + srcY, srcW, srcH, img.getTextureId());
    }

    @Override
    public void renderFont(@Nonnull RenderFont font, @Nonnull String text, int x, int y, @Nonnull Color color, float sizeX, float sizeY) {
        log.finest("renderFont()");
        BatchRenderFont renderFont = (BatchRenderFont)font;
        renderFont.getBitmapFont().renderText(x, y, text, sizeX, sizeY, color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    @Override
    public void enableClip(int x0, int y0, int x1, int y1) {
        log.finest("enableClip()");
        this.clipping.setEnabled(true);
        this.clipping.setBounds(x0, y0, x1, y1);
    }

    @Override
    public void disableClip() {
        log.finest("disableClip()");
        if (!this.clipping.isEnabled()) {
            return;
        }
        this.clipping.setEnabled(false);
        this.clipping.setToViewport();
    }

    @Override
    public void setBlendMode(@Nonnull BlendMode renderMode) {
        log.finest("setBlendMode()");
        if (renderMode.equals((Object)this.currentBlendMode)) {
            return;
        }
        this.currentBlendMode = renderMode;
        this.shouldStartNewBatch = true;
    }

    @Override
    public MouseCursor createMouseCursor(@Nonnull String filename, int hotspotX, int hotspotY) throws IOException {
        log.finest("createMouseCursor()");
        return this.renderBackend.createMouseCursor(filename, hotspotX, hotspotY);
    }

    @Override
    public void enableMouseCursor(@Nonnull MouseCursor mouseCursor) {
        log.finest("enableMouseCursor()");
        this.renderBackend.enableMouseCursor(mouseCursor);
    }

    @Override
    public void disableMouseCursor() {
        log.finest("disableMouseCursor()");
        this.renderBackend.disableMouseCursor();
    }

    public void resetTextureAtlases() {
        if (!this.renderConfig.disposeImagesBetweenScreens) {
            return;
        }
        log.finest("resetTextureAtlases()");
        if (this.thePlainImage != null) {
            this.thePlainImage.unload();
        }
        this.resetTextureAtlasGenerators();
        this.clearTextureAtlases();
        this.fontRenderer.unload();
    }

    private void createInitialTextureAtlases() {
        for (int i = 0; i < this.renderConfig.initialAtlasCount; ++i) {
            this.createTextureAtlasGenerator(this.createTextureAtlas());
        }
        this.resetCurrentTextureAtlas();
    }

    private int createTextureAtlas() {
        int atlasTextureId = this.renderBackend.createTextureAtlas(this.renderConfig.atlasWidth, this.renderConfig.atlasHeight);
        log.info("Created a new texture atlas (atlas texture id: " + atlasTextureId + ").");
        this.atlasTextureIdIterator.add(atlasTextureId);
        this.createTextureAtlasGenerator(atlasTextureId);
        return atlasTextureId;
    }

    private void createTextureAtlasGenerator(int atlasTextureId) {
        this.textureAtlasGenerators.put(atlasTextureId, new TextureAtlasGenerator(this.renderConfig.atlasWidth, this.renderConfig.atlasHeight, this.renderConfig.atlasPadding, this.renderConfig.atlasTolerance));
    }

    private void resetCurrentTextureAtlas() {
        this.rewindAtlasTextureIdIterator();
        this.currentAtlasTextureId = this.nextTextureAtlas();
    }

    private void rewindAtlasTextureIdIterator() {
        while (this.atlasTextureIdIterator.hasPrevious()) {
            this.atlasTextureIdIterator.previous();
        }
    }

    private TextureAtlasGenerator getCurrentTextureAtlasGenerator() {
        return this.textureAtlasGenerators.get(this.currentAtlasTextureId);
    }

    private int getCurrentAtlasTextureId() {
        return this.currentAtlasTextureId;
    }

    private int nextTextureAtlas() {
        this.currentAtlasTextureId = this.atlasTextureIdIterator.hasNext() ? this.atlasTextureIdIterator.next().intValue() : this.createTextureAtlas();
        log.info("Switched atlases to atlas texture with id: " + this.currentAtlasTextureId + ".");
        return this.currentAtlasTextureId;
    }

    @Nonnull
    private BatchRenderImage getPlainImage() {
        if (this.thePlainImage == null) {
            this.thePlainImage = (BatchRenderImage)this.createImage("de/lessvoid/nifty/render/batch/nifty.png", true);
            if (this.thePlainImage == null) {
                throw new RuntimeException("The batch renderer requires the plain image in the resources, but its not there.");
            }
        }
        this.uploadImageInternal(this.thePlainImage);
        return this.thePlainImage;
    }

    private void uploadImageInternal(BatchRenderImage image) {
        if (image.isUploaded()) {
            return;
        }
        image.upload();
        if (!image.isUploaded()) {
            this.reattemptUpload(image);
        }
    }

    private void reattemptUpload(BatchRenderImage image) {
        while (!image.isUploaded() && !image.uploadFailedPermanently()) {
            this.nextTextureAtlas();
            image.reUpload(this.getCurrentAtlasTextureId(), this.getCurrentTextureAtlasGenerator());
        }
        this.resetCurrentTextureAtlas();
    }

    private void resetTextureAtlasGenerators() {
        for (TextureAtlasGenerator generator : this.textureAtlasGenerators.values()) {
            generator.reset();
        }
    }

    private void clearTextureAtlases() {
        for (int atlasTextureId : this.atlasTextureIds) {
            this.renderBackend.clearTextureAtlas(atlasTextureId);
        }
        this.resetCurrentTextureAtlas();
    }

    private void addQuad(float x, float y, float width, float height, @Nonnull Color color1, @Nonnull Color color2, @Nonnull Color color3, @Nonnull Color color4, int textureX, int textureY, int textureWidth, int textureHeight, int textureId) {
        if (this.clipping.isCompletelyOutside((int)x, (int)y, (int)width, (int)height)) {
            this.clipping.incrementDiscardCounter();
            return;
        }
        if (this.clipping.isCompletelyInside((int)x, (int)y, (int)width, (int)height)) {
            this.addQuadInternal(x, y, width, height, color1, color2, color3, color4, textureX, textureY, textureWidth, textureHeight, textureId);
            return;
        }
        this.originalQuad.set((int)x, (int)y, (int)width, (int)height);
        this.clippedQuad.set(this.clipping.clipQuad(this.originalQuad));
        this.clippedQuadTexture.set(this.clipping.clipQuadTexture(textureX, textureY, textureWidth, textureHeight, this.originalQuad, this.clippedQuad));
        this.addQuadInternal(this.clippedQuad.x0, this.clippedQuad.y0, this.clippedQuad.getWidth(), this.clippedQuad.getHeight(), color1, color2, color3, color4, this.clippedQuadTexture.x0, this.clippedQuadTexture.y0, this.clippedQuadTexture.getWidth(), this.clippedQuadTexture.getHeight(), textureId);
    }

    private void addQuadInternal(float x, float y, float width, float height, @Nonnull Color color1, @Nonnull Color color2, @Nonnull Color color3, @Nonnull Color color4, int textureX, int textureY, int textureWidth, int textureHeight, int textureId) {
        this.checkIfTextureChanged(textureId);
        this.beginNewBatchIfRequired();
        this.renderBackend.addQuad(x, y, width, height, color1, color2, color3, color4, this.calcU(textureX, this.getFullWidthOfCurrentTexture()), this.calcU(textureY, this.getFullHeightOfCurrentTexture()), this.calcU(textureWidth - 1, this.getFullWidthOfCurrentTexture()), this.calcU(textureHeight - 1, this.getFullHeightOfCurrentTexture()), textureId);
        ++this.quadCount;
    }

    private void checkIfTextureChanged(int textureId) {
        if (!this.isCurrentTexture(textureId)) {
            this.updateCurrentTexture(textureId);
            this.shouldStartNewBatch = true;
        }
    }

    private void beginNewBatchIfRequired() {
        if (this.shouldStartNewBatch) {
            this.renderBackend.beginBatch(this.currentBlendMode, this.currentTextureId);
            this.shouldStartNewBatch = false;
        }
    }

    private boolean isCurrentTexture(int textureId) {
        return textureId == this.currentTextureId;
    }

    private void updateCurrentTexture(int textureId) {
        this.currentTextureId = textureId;
        this.currentTextureSize = BatchRenderImage.getTextureSize(textureId);
        if (this.currentTextureSize == null) {
            log.severe("cannot get texture size of texture with id: " + textureId + "  because that texture id is not registered!");
        }
    }

    private float calcU(int value, int max) {
        return 0.5f / (float)max + (float)value / (float)max;
    }

    private int getFullWidthOfCurrentTexture() {
        return this.currentTextureSize != null ? this.currentTextureSize.getWidth() : 0;
    }

    private int getFullHeightOfCurrentTexture() {
        return this.currentTextureSize != null ? this.currentTextureSize.getHeight() : 0;
    }

    private class BitmapInfo {
        private final BatchRenderImage image;
        private final Map<Integer, CharRenderInfo> characterIndices = new HashMap<Integer, CharRenderInfo>();

        public BitmapInfo(BatchRenderImage image) {
            this.image = image;
        }

        private void upload() {
            BatchRenderDevice.this.uploadImageInternal(this.image);
        }

        private void unload() {
            this.image.markAsUnloaded();
        }

        public void renderCharacter(int c, int x, int y, float sx, float sy, @Nonnull Color textColor) {
            this.characterIndices.get(c).renderQuad(x, y, sx, sy, textColor, this.image.getX(), this.image.getY(), this.image.getWidth(), this.image.getHeight(), this.image.getTextureId());
        }

        public void addCharRenderInfo(Integer c, CharRenderInfo renderInfo) {
            this.characterIndices.put(c, renderInfo);
        }
    }

    private class CharRenderInfo {
        final int xoff;
        final int yoff;
        final int w;
        final int h;
        final float u0;
        final float v0;

        public CharRenderInfo(int xoff, int yoff, int w, int h, float u0, float v0) {
            this.xoff = xoff;
            this.yoff = yoff;
            this.w = w;
            this.h = h;
            this.u0 = u0;
            this.v0 = v0;
        }

        public void renderQuad(int x, int y, float sx, float sy, @Nonnull Color textColor, int textureX, int textureY, int textureWidth, int textureHeight, int textureId) {
            BatchRenderDevice.this.glyphCount++;
            BatchRenderDevice.this.addQuad((float)x + (float)Math.floor((float)this.xoff * sx), (float)y + (float)Math.floor((float)this.yoff * sy), (float)this.w * sx, (float)this.h * sy, textColor, textColor, textColor, textColor, (int)((float)textureX + this.u0 * (float)textureWidth), (int)((float)textureY + this.v0 * (float)textureHeight), this.w, this.h, textureId);
        }
    }

    private class FontRenderer
    implements JGLFontRenderer {
        private final Map<String, BitmapInfo> textureInfos = new HashMap<String, BitmapInfo>();
        private final ColorValueParser colorValueParser = new ColorValueParser();
        private final BatchRenderDevice batchRenderDevice;
        private final Color textColor = Color.BLACK;
        private boolean hasColor;

        public FontRenderer(BatchRenderDevice batchRenderDevice2) {
            this.batchRenderDevice = batchRenderDevice2;
        }

        public void unload() {
            for (BitmapInfo info : this.textureInfos.values()) {
                info.unload();
            }
        }

        @Override
        public void registerBitmap(@Nonnull String bitmapId, InputStream data, @Nonnull String filename) throws IOException {
            this.textureInfos.put(bitmapId, new BitmapInfo((BatchRenderImage)this.batchRenderDevice.createImage(filename, true)));
        }

        @Override
        public void registerBitmap(@Nonnull String bitmapId, @Nonnull ByteBuffer data, int width, int height, @Nonnull String filename) throws IOException {
            BatchRenderImage batchRenderImage = null;
            BatchRenderBackend.Image image = BatchRenderDevice.this.renderBackend.loadImage(data, width, height);
            if (image != null) {
                batchRenderImage = new BatchRenderImage(image, filename, BatchRenderDevice.this.renderBackend, BatchRenderDevice.this.getCurrentTextureAtlasGenerator(), BatchRenderDevice.this.getCurrentAtlasTextureId(), ((BatchRenderDevice)BatchRenderDevice.this).renderConfig.disposeImagesBetweenScreens);
            }
            this.textureInfos.put(bitmapId, new BitmapInfo(batchRenderImage));
        }

        @Override
        public void registerGlyph(String bitmapId, int c, int xoff, int yoff, int w, int h, float u0, float v0, float u1, float v1) {
            BitmapInfo textureInfo = this.textureInfos.get(bitmapId);
            textureInfo.addCharRenderInfo(c, new CharRenderInfo(xoff, yoff, w, h, u0, v0));
        }

        @Override
        public void prepare() {
        }

        @Override
        public void beforeRender(Object customRenderState) {
            this.hasColor = false;
            for (BitmapInfo info : this.textureInfos.values()) {
                info.upload();
            }
        }

        @Override
        public int preProcess(@Nonnull String text, int offset) {
            int index = offset;
            this.colorValueParser.isColor(text, index);
            while (this.colorValueParser.isColor()) {
                Color color = this.colorValueParser.getColor();
                assert (color != null);
                this.textColor.setRed(color.getRed());
                this.textColor.setGreen(color.getGreen());
                this.textColor.setBlue(color.getBlue());
                this.textColor.setAlpha(color.getAlpha());
                this.hasColor = true;
                index = this.colorValueParser.getNextIndex();
                if (index >= text.length()) {
                    return index;
                }
                this.colorValueParser.isColor(text, index);
            }
            return index;
        }

        @Override
        public void render(String bitmapId, int x, int y, int c, float sx, float sy, float r, float g, float b, float a) {
            if (!this.hasColor) {
                this.textColor.setRed(r);
                this.textColor.setGreen(g);
                this.textColor.setBlue(b);
            }
            this.textColor.setAlpha(a);
            this.textureInfos.get(bitmapId).renderCharacter(c, x, y, sx, sy, this.textColor);
        }

        @Override
        public void afterRender() {
        }

        @Override
        public int preProcessForLength(@Nonnull String text, int offset) {
            int index = offset;
            this.colorValueParser.isColor(text, index);
            while (this.colorValueParser.isColor()) {
                index = this.colorValueParser.getNextIndex();
                if (index >= text.length()) {
                    return index;
                }
                this.colorValueParser.isColor(text, index);
            }
            return index;
        }
    }

    private class Rect {
        public int x0;
        public int y0;
        public int x1;
        public int y1;

        public Rect(int x0, int y0, int x1, int y1) {
            this.x0 = x0;
            this.y0 = y0;
            this.x1 = x1;
            this.y1 = y1;
        }

        public int getWidth() {
            return this.x1 - this.x0 + 1;
        }

        public int getHeight() {
            return this.y1 - this.y0 + 1;
        }

        public void set(int x0, int y0, int width, int height) {
            this.x0 = x0;
            this.y0 = y0;
            this.x1 = x0 + width - 1;
            this.y1 = y0 + height - 1;
        }

        public void set(Rect rect) {
            this.x0 = rect.x0;
            this.y0 = rect.y0;
            this.x1 = rect.x1;
            this.y1 = rect.y1;
        }
    }

    private class Clipping {
        private Rect boundingBox;
        private Rect clippedRect;
        private boolean isEnabled;
        private int discardCount;

        public Clipping(int x0, int y0, int x1, int y1, boolean isEnabled) {
            this.boundingBox = new Rect(x0, y0, x1, y1);
            this.clippedRect = new Rect(0, 0, 0, 0);
            this.isEnabled = isEnabled;
            this.discardCount = 0;
        }

        public void setBounds(int x0, int y0, int x1, int y1) {
            this.boundingBox.x0 = x0;
            this.boundingBox.y0 = y0;
            this.boundingBox.x1 = x1;
            this.boundingBox.y1 = y1;
        }

        public void setEnabled(boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }

        public void setToViewport() {
            this.setBounds(0, 0, BatchRenderDevice.this.getWidth() - 1, BatchRenderDevice.this.getHeight() - 1);
        }

        public Rect clipQuad(Rect quad) {
            return this.clipQuad(quad.x0, quad.y0, quad.getWidth(), quad.getHeight());
        }

        public Rect clipQuad(int x0, int y0, int width, int height) {
            return this.clipQuadInternal(x0, y0, x0 + width - 1, y0 + height - 1);
        }

        public Rect clipQuadTexture(int textureX0, int textureY0, int textureWidth, int textureHeight, Rect originalQuad, Rect clippedQuad) {
            return this.clipQuadTextureInternal(textureX0, textureY0, textureX0 + textureWidth - 1, textureY0 + textureHeight - 1, textureWidth, textureHeight, originalQuad, clippedQuad);
        }

        public boolean isCompletelyOutside(int x0, int y0, int width, int height) {
            return this.isCompletelyOutsideInternal(x0, y0, x0 + width - 1, y0 + height - 1);
        }

        public boolean isCompletelyInside(int x0, int y0, int width, int height) {
            return this.isCompletelyInsideInternal(x0, y0, x0 + width - 1, y0 + height - 1);
        }

        public void incrementDiscardCounter() {
            ++this.discardCount;
        }

        public int getDiscardCount() {
            return this.discardCount;
        }

        public void resetDiscardCount() {
            this.discardCount = 0;
        }

        private Rect clipQuadInternal(int x0, int y0, int x1, int y1) {
            this.clippedRect.x0 = x0 >= this.boundingBox.x0 ? x0 : this.boundingBox.x0;
            this.clippedRect.x1 = x1 <= this.boundingBox.x1 ? x1 : this.boundingBox.x1;
            this.clippedRect.y0 = y0 >= this.boundingBox.y0 ? y0 : this.boundingBox.y0;
            this.clippedRect.y1 = y1 <= this.boundingBox.y1 ? y1 : this.boundingBox.y1;
            return this.clippedRect;
        }

        private Rect clipQuadTextureInternal(int textureX0, int textureY0, int textureX1, int textureY1, int textureWidth, int textureHeight, Rect originalQuad, Rect clippedQuad) {
            this.clippedRect.x0 = clippedQuad.x0 == originalQuad.x0 ? textureX0 : (int)((float)textureX0 + (float)(clippedQuad.x0 - originalQuad.x0) / (float)originalQuad.getWidth() * (float)textureWidth);
            this.clippedRect.y0 = clippedQuad.y0 == originalQuad.y0 ? textureY0 : (int)((float)textureY0 + (float)(clippedQuad.y0 - originalQuad.y0) / (float)originalQuad.getHeight() * (float)textureHeight);
            this.clippedRect.x1 = clippedQuad.x1 == originalQuad.x1 ? textureX1 : (int)((float)textureX1 + (float)(clippedQuad.x1 - originalQuad.x1) / (float)originalQuad.getWidth() * (float)textureWidth);
            this.clippedRect.y1 = clippedQuad.y1 == originalQuad.y1 ? textureY1 : (int)((float)textureY1 + (float)(clippedQuad.y1 - originalQuad.y1) / (float)originalQuad.getHeight() * (float)textureHeight);
            return this.clippedRect;
        }

        private boolean isCompletelyOutsideInternal(int x0, int y0, int x1, int y1) {
            return x0 > this.boundingBox.x1 || x1 < this.boundingBox.x0 || y0 > this.boundingBox.y1 || y1 < this.boundingBox.y0;
        }

        private boolean isCompletelyInsideInternal(int x0, int y0, int x1, int y1) {
            return x0 >= this.boundingBox.x0 && x0 <= this.boundingBox.x1 && x1 >= this.boundingBox.x0 && x1 <= this.boundingBox.x1 && y0 >= this.boundingBox.y0 && y0 <= this.boundingBox.y1 && y1 >= this.boundingBox.y0 && y1 <= this.boundingBox.y1;
        }
    }
}

