/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render.batch;

import de.lessvoid.nifty.render.BlendMode;
import de.lessvoid.nifty.render.batch.spi.Batch;
import de.lessvoid.nifty.render.batch.spi.BufferFactory;
import de.lessvoid.nifty.render.batch.spi.GL;
import de.lessvoid.nifty.tools.Color;
import java.nio.FloatBuffer;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class BatchInternal
implements Batch {
    @Nonnull
    private static final Logger log = Logger.getLogger(BatchInternal.class.getName());
    private static final int VERTICES_PER_QUAD = 6;
    private static final int POSITION_ATTRIBUTES_PER_VERTEX = 2;
    private static final int COLOR_ATTRIBUTES_PER_VERTEX = 4;
    private static final int TEXTURE_ATTRIBUTES_PER_VERTEX = 2;
    private static final int ATTRIBUTES_PER_VERTEX = 8;
    private static final int BYTES_PER_ATTRIBUTE = 4;
    private static final int PRIMITIVE_SIZE = 48;
    private static final int STRIDE = 32;
    private static final int SIZE = 65536;
    @Nonnull
    private final GL gl;
    @Nonnull
    private final FloatBuffer vertexBuffer;
    @Nonnull
    private final float[] primitiveBuffer = new float[48];
    @Nonnull
    private BlendMode blendMode = BlendMode.BLEND;
    private int primitiveCount;
    private int textureId;

    public BatchInternal(@Nonnull GL gl, @Nonnull BufferFactory bufferFactory) {
        this.gl = gl;
        this.vertexBuffer = bufferFactory.createNativeOrderedFloatBuffer(65536);
    }

    @Override
    public void begin(@Nonnull BlendMode blendMode, int textureId) {
        this.blendMode = blendMode;
        this.textureId = textureId;
        this.primitiveCount = 0;
        this.vertexBuffer.clear();
    }

    @Override
    @Nonnull
    public BlendMode getBlendMode() {
        return this.blendMode;
    }

    @Override
    public void render() {
        if (this.primitiveCount == 0) {
            return;
        }
        this.gl.glBindTexture(this.gl.GL_TEXTURE_2D(), this.textureId);
        if (this.blendMode.equals((Object)BlendMode.BLEND)) {
            this.gl.glBlendFunc(this.gl.GL_SRC_ALPHA(), this.gl.GL_ONE_MINUS_SRC_ALPHA());
        } else if (this.blendMode.equals((Object)BlendMode.MULIPLY)) {
            this.gl.glBlendFunc(this.gl.GL_DST_COLOR(), this.gl.GL_ZERO());
        }
        this.vertexBuffer.flip();
        this.vertexBuffer.position(0);
        this.gl.glVertexPointer(2, this.gl.GL_FLOAT(), 32, this.vertexBuffer);
        this.vertexBuffer.position(2);
        this.gl.glColorPointer(4, this.gl.GL_FLOAT(), 32, this.vertexBuffer);
        this.vertexBuffer.position(6);
        this.gl.glTexCoordPointer(2, this.gl.GL_FLOAT(), 32, this.vertexBuffer);
        this.gl.glDrawArrays(this.gl.GL_TRIANGLES(), 0, this.primitiveCount * 6);
    }

    @Override
    public boolean canAddQuad() {
        return (this.primitiveCount + 1) * 48 < 65536;
    }

    @Override
    public void addQuad(float x, float y, float width, float height, @Nonnull Color color1, @Nonnull Color color2, @Nonnull Color color3, @Nonnull Color color4, float textureX, float textureY, float textureWidth, float textureHeight) {
        int bufferIndex = 0;
        this.primitiveBuffer[bufferIndex++] = x;
        this.primitiveBuffer[bufferIndex++] = y;
        this.primitiveBuffer[bufferIndex++] = color1.getRed();
        this.primitiveBuffer[bufferIndex++] = color1.getGreen();
        this.primitiveBuffer[bufferIndex++] = color1.getBlue();
        this.primitiveBuffer[bufferIndex++] = color1.getAlpha();
        this.primitiveBuffer[bufferIndex++] = textureX;
        this.primitiveBuffer[bufferIndex++] = textureY;
        this.primitiveBuffer[bufferIndex++] = x + width;
        this.primitiveBuffer[bufferIndex++] = y;
        this.primitiveBuffer[bufferIndex++] = color2.getRed();
        this.primitiveBuffer[bufferIndex++] = color2.getGreen();
        this.primitiveBuffer[bufferIndex++] = color2.getBlue();
        this.primitiveBuffer[bufferIndex++] = color2.getAlpha();
        this.primitiveBuffer[bufferIndex++] = textureX + textureWidth;
        this.primitiveBuffer[bufferIndex++] = textureY;
        this.primitiveBuffer[bufferIndex++] = x + width;
        this.primitiveBuffer[bufferIndex++] = y + height;
        this.primitiveBuffer[bufferIndex++] = color4.getRed();
        this.primitiveBuffer[bufferIndex++] = color4.getGreen();
        this.primitiveBuffer[bufferIndex++] = color4.getBlue();
        this.primitiveBuffer[bufferIndex++] = color4.getAlpha();
        this.primitiveBuffer[bufferIndex++] = textureX + textureWidth;
        this.primitiveBuffer[bufferIndex++] = textureY + textureHeight;
        this.primitiveBuffer[bufferIndex++] = x;
        this.primitiveBuffer[bufferIndex++] = y;
        this.primitiveBuffer[bufferIndex++] = color1.getRed();
        this.primitiveBuffer[bufferIndex++] = color1.getGreen();
        this.primitiveBuffer[bufferIndex++] = color1.getBlue();
        this.primitiveBuffer[bufferIndex++] = color1.getAlpha();
        this.primitiveBuffer[bufferIndex++] = textureX;
        this.primitiveBuffer[bufferIndex++] = textureY;
        this.primitiveBuffer[bufferIndex++] = x + width;
        this.primitiveBuffer[bufferIndex++] = y + height;
        this.primitiveBuffer[bufferIndex++] = color4.getRed();
        this.primitiveBuffer[bufferIndex++] = color4.getGreen();
        this.primitiveBuffer[bufferIndex++] = color4.getBlue();
        this.primitiveBuffer[bufferIndex++] = color4.getAlpha();
        this.primitiveBuffer[bufferIndex++] = textureX + textureWidth;
        this.primitiveBuffer[bufferIndex++] = textureY + textureHeight;
        this.primitiveBuffer[bufferIndex++] = x;
        this.primitiveBuffer[bufferIndex++] = y + height;
        this.primitiveBuffer[bufferIndex++] = color3.getRed();
        this.primitiveBuffer[bufferIndex++] = color3.getGreen();
        this.primitiveBuffer[bufferIndex++] = color3.getBlue();
        this.primitiveBuffer[bufferIndex++] = color3.getAlpha();
        this.primitiveBuffer[bufferIndex++] = textureX;
        this.primitiveBuffer[bufferIndex] = textureY + textureHeight;
        this.vertexBuffer.put(this.primitiveBuffer);
        ++this.primitiveCount;
    }
}

