/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render;

import de.lessvoid.nifty.NiftyMouse;
import de.lessvoid.nifty.spi.input.InputSystem;
import de.lessvoid.nifty.spi.render.MouseCursor;
import de.lessvoid.nifty.spi.render.RenderDevice;
import de.lessvoid.nifty.spi.time.TimeProvider;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NiftyMouseImpl
implements NiftyMouse {
    @Nonnull
    private static final Logger log = Logger.getLogger(NiftyMouseImpl.class.getName());
    @Nonnull
    private final RenderDevice renderDevice;
    @Nonnull
    private final InputSystem inputSystem;
    @Nonnull
    private final Map<String, MouseCursor> registeredMouseCursors;
    @Nullable
    private String currentId;
    private int mouseX;
    private int mouseY;
    @Nonnull
    private final TimeProvider timeProvider;
    private long lastMouseMoveEventTime;

    public NiftyMouseImpl(@Nonnull RenderDevice renderDevice, @Nonnull InputSystem inputSystem, @Nonnull TimeProvider timeProvider) {
        this.renderDevice = renderDevice;
        this.inputSystem = inputSystem;
        this.timeProvider = timeProvider;
        this.lastMouseMoveEventTime = timeProvider.getMsTime();
        this.registeredMouseCursors = new HashMap<String, MouseCursor>();
    }

    @Override
    public void registerMouseCursor(@Nonnull String id, @Nonnull String filename, int hotspotX, int hotspotY) throws IOException {
        MouseCursor mouseCursor = this.renderDevice.createMouseCursor(filename, hotspotX, hotspotY);
        if (mouseCursor == null) {
            log.warning("Your RenderDevice does not support the createMouseCursor() method. Mouse cursors can't be changed.");
            return;
        }
        this.registeredMouseCursors.put(id, mouseCursor);
    }

    @Override
    @Nullable
    public String getCurrentId() {
        return this.currentId;
    }

    @Override
    public void unregisterAll() {
        for (MouseCursor cursor : this.registeredMouseCursors.values()) {
            cursor.dispose();
        }
        this.registeredMouseCursors.clear();
    }

    @Override
    public void resetMouseCursor() {
        this.currentId = null;
        this.renderDevice.disableMouseCursor();
    }

    @Override
    public void enableMouseCursor(@Nullable String id) {
        if (id == null) {
            this.resetMouseCursor();
            return;
        }
        if (id.equals(this.currentId)) {
            return;
        }
        this.renderDevice.enableMouseCursor(this.registeredMouseCursors.get(id));
        this.currentId = id;
    }

    @Override
    public void setMousePosition(int x, int y) {
        this.inputSystem.setMousePosition(x, y);
        this.updateMousePosition(x, y);
    }

    @Override
    public int getX() {
        return this.mouseX;
    }

    @Override
    public int getY() {
        return this.mouseY;
    }

    @Override
    public long getNoMouseMovementTime() {
        long now = this.timeProvider.getMsTime();
        return now - this.lastMouseMoveEventTime;
    }

    public void updateMousePosition(int x, int y) {
        if (this.positionChanged(x, y)) {
            this.lastMouseMoveEventTime = this.timeProvider.getMsTime();
        }
        this.mouseX = x;
        this.mouseY = y;
    }

    private boolean positionChanged(int x, int y) {
        return x != this.mouseX || y != this.mouseY;
    }
}

