/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render;

import de.lessvoid.nifty.render.NiftyImageManager;
import de.lessvoid.nifty.render.NiftyImageManagerExt;
import de.lessvoid.nifty.render.batch.BatchRenderDevice;
import de.lessvoid.nifty.render.batch.BatchRenderImage;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.spi.render.RenderDevice;
import de.lessvoid.nifty.spi.render.RenderImage;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NiftyImageManagerExtBatch
implements NiftyImageManagerExt<NiftyImageManager.ReferencedCountedImage> {
    @Nonnull
    private static final Logger log = Logger.getLogger(NiftyImageManagerExtBatch.class.getName());
    @Nonnull
    private final Map<String, Set<ReferencedCountedImageBatch>> screenRef = new HashMap<String, Set<ReferencedCountedImageBatch>>();
    @Nullable
    private Screen currentScreen;

    @Override
    public void registerImage(@Nonnull Screen screen, @Nonnull NiftyImageManager.ReferencedCountedImage image) {
        ReferencedCountedImageBatch batchImage;
        Set<ReferencedCountedImageBatch> screenList = this.screenRef.get(screen.getScreenId());
        if (screenList == null) {
            screenList = new HashSet<ReferencedCountedImageBatch>();
            this.screenRef.put(screen.getScreenId(), screenList);
        }
        if (screenList.add(batchImage = NiftyImageManagerExtBatch.cast(image)) && log.isLoggable(Level.FINER)) {
            log.finer("[" + screen.getScreenId() + "] now with [" + screenList.size() + "] entries (" + image.getName() + ")");
        }
        if (this.currentScreen != null && this.currentScreen.getScreenId().equals(screen.getScreenId()) && !batchImage.isUploaded()) {
            batchImage.upload();
        }
    }

    @Override
    public void unregisterImage(@Nonnull NiftyImageManager.ReferencedCountedImage reference) {
        ReferencedCountedImageBatch image = NiftyImageManagerExtBatch.cast(reference);
        image.unload();
        Set<ReferencedCountedImageBatch> screenList = this.screenRef.get(reference.getScreen().getScreenId());
        if (screenList != null) {
            screenList.remove(image);
        }
    }

    @Override
    public void uploadScreenImages(@Nonnull Screen screen) {
        this.currentScreen = screen;
        Set<ReferencedCountedImageBatch> imageList = this.screenRef.get(screen.getScreenId());
        if (imageList == null) {
            return;
        }
        for (ReferencedCountedImageBatch image : imageList) {
            image.upload();
        }
    }

    @Override
    public void unloadScreenImages(@Nonnull Screen screen, @Nonnull RenderDevice renderDevice, @Nonnull Collection<NiftyImageManager.ReferencedCountedImage> imageSet) {
        ((BatchRenderDevice)renderDevice).resetTextureAtlases();
        for (NiftyImageManager.ReferencedCountedImage i : imageSet) {
            NiftyImageManagerExtBatch.cast(i).markAsUnloaded();
        }
        this.currentScreen = null;
    }

    @Nonnull
    private static ReferencedCountedImageBatch cast(@Nonnull NiftyImageManager.ReferencedCountedImage image) {
        if (image instanceof ReferencedCountedImageBatch) {
            return (ReferencedCountedImageBatch)image;
        }
        throw new IllegalArgumentException("Illegal image type supplied: " + image.getClass().getName() + "expected " + ReferencedCountedImageBatch.class.getName());
    }

    @Override
    public void screenAdded(@Nonnull Screen screen) {
    }

    @Override
    public void screenRemoved(@Nonnull Screen screen) {
        this.screenRef.remove(screen.getScreenId());
    }

    @Override
    public void addScreenInfo(@Nonnull StringBuffer result) {
        if (this.screenRef.entrySet().isEmpty()) {
            return;
        }
        result.append("\n");
        for (Map.Entry<String, Set<ReferencedCountedImageBatch>> entry : this.screenRef.entrySet()) {
            result.append("\n[").append(entry.getKey()).append("]\n");
            for (ReferencedCountedImageBatch image : entry.getValue()) {
                result.append(image.toString());
            }
        }
    }

    @Override
    @Nonnull
    public ReferencedCountedImageBatch createReferencedCountedImage(@Nonnull RenderDevice renderDevice, @Nonnull Screen screen, @Nonnull String filename, boolean filterLinear, @Nonnull RenderImage renderImage, @Nonnull String key) {
        return new ReferencedCountedImageBatch(renderDevice, screen, filename, filterLinear, renderImage, key);
    }

    public static class ReferencedCountedImageBatch
    implements NiftyImageManager.ReferencedCountedImage {
        @Nonnull
        private final RenderDevice renderDevice;
        @Nonnull
        private final Screen screen;
        @Nonnull
        private final String filename;
        private final boolean filterLinear;
        @Nonnull
        private final String key;
        @Nonnull
        private RenderImage renderImage;
        private int references;

        public ReferencedCountedImageBatch(@Nonnull RenderDevice renderDevice, @Nonnull Screen screen, @Nonnull String filename, boolean filterLinear, @Nonnull RenderImage renderImage, @Nonnull String key) {
            this.renderDevice = renderDevice;
            this.screen = screen;
            this.filename = filename;
            this.filterLinear = filterLinear;
            this.key = key;
            this.renderImage = renderImage;
            this.references = 1;
        }

        public void upload() {
            BatchRenderImage batchRenderImage = (BatchRenderImage)this.renderImage;
            batchRenderImage.upload();
        }

        public void unload() {
            BatchRenderImage batchRenderImage = (BatchRenderImage)this.renderImage;
            batchRenderImage.unload();
        }

        public void markAsUnloaded() {
            BatchRenderImage batchRenderImage = (BatchRenderImage)this.renderImage;
            batchRenderImage.markAsUnloaded();
        }

        @Override
        @Nonnull
        public RenderImage reload() {
            RenderImage newImage = this.renderDevice.createImage(this.filename, this.filterLinear);
            if (newImage == null) {
                log.severe("Failed to reload image, reloading canceled.");
            } else {
                this.renderImage.dispose();
                this.renderImage = newImage;
            }
            return this.renderImage;
        }

        @Override
        @Nonnull
        public RenderImage addReference() {
            ++this.references;
            return this.renderImage;
        }

        @Override
        public boolean removeReference() {
            --this.references;
            if (this.references == 0) {
                this.renderImage.dispose();
                return true;
            }
            return false;
        }

        @Override
        public int getReferences() {
            return this.references;
        }

        @Override
        @Nonnull
        public RenderImage getRenderImage() {
            return this.renderImage;
        }

        @Override
        @Nonnull
        public String getName() {
            return this.key;
        }

        @Override
        @Nonnull
        public Screen getScreen() {
            return this.screen;
        }

        public boolean isUploaded() {
            if (this.renderImage instanceof BatchRenderImage) {
                return ((BatchRenderImage)this.renderImage).isUploaded();
            }
            return false;
        }

        @Nonnull
        public String toString() {
            return " - [" + this.getName() + "] reference count [" + this.getReferences() + "] uploaded [" + this.isUploaded() + "]\n";
        }
    }
}

