/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.loaderv2.types;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.dynamic.attributes.ControlEffectAttributes;
import de.lessvoid.nifty.controls.dynamic.attributes.ControlEffectsAttributes;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.loaderv2.types.EffectType;
import de.lessvoid.nifty.loaderv2.types.EffectTypeOnHover;
import de.lessvoid.nifty.loaderv2.types.XmlBaseType;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.EnumStorage;
import de.lessvoid.nifty.tools.StringHelper;
import de.lessvoid.nifty.tools.factories.CollectionFactory;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EffectsType
extends XmlBaseType {
    @Nonnull
    private final EnumStorage<EffectEventId, Collection<EffectType>> effects = new EnumStorage(EffectEventId.class, CollectionFactory.getArrayListInstance());

    public EffectsType() {
    }

    public EffectsType(@Nonnull EffectsType src) {
        super(src);
        this.copyEffects(src);
    }

    public EffectsType(@Nonnull Attributes attributes) {
        super(attributes);
    }

    public void mergeFromEffectsType(@Nonnull EffectsType src) {
        this.mergeFromAttributes(src.getAttributes());
        this.mergeEffects(src);
    }

    private void copyEffects(@Nonnull EffectsType src) {
        for (EffectEventId event : EffectEventId.values()) {
            if (!src.effects.isSet(event)) continue;
            this.copyCollection(this.effects.get(event), src.effects.get(event));
        }
    }

    private void mergeEffects(@Nonnull EffectsType src) {
        for (EffectEventId event : EffectEventId.values()) {
            if (!src.effects.isSet(event)) continue;
            this.mergeCollection(this.effects.get(event), src.effects.get(event));
        }
    }

    @Nonnull
    private Collection<EffectType> copyCollection(@Nonnull Collection<EffectType> dst, @Nonnull Collection<EffectType> src) {
        dst.clear();
        this.copyEffects(dst, src);
        return dst;
    }

    @Nonnull
    private Collection<EffectType> mergeCollection(@Nonnull Collection<EffectType> dst, @Nonnull Collection<EffectType> src) {
        this.copyEffects(dst, src);
        return dst;
    }

    void copyEffects(@Nonnull Collection<EffectType> dst, @Nonnull Collection<EffectType> src) {
        try {
            for (EffectType e : src) {
                dst.add(e.clone());
            }
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Creating copy of effect data failed!", e);
        }
    }

    @Override
    public void translateSpecialValues(@Nonnull Nifty nifty, @Nullable Screen screen) {
        super.translateSpecialValues(nifty, screen);
        for (EffectEventId event : EffectEventId.values()) {
            if (!this.effects.isSet(event)) continue;
            for (EffectType effectType : this.effects.get(event)) {
                effectType.translateSpecialValues(nifty, screen);
            }
        }
    }

    public void addEventEffect(@Nonnull EffectEventId eventId, @Nonnull EffectType effectParam) {
        this.effects.get(eventId).add(effectParam);
    }

    public void addOnStartScreen(@Nonnull EffectType effectParam) {
        this.addEventEffect(EffectEventId.onStartScreen, effectParam);
    }

    public void addOnEndScreen(@Nonnull EffectType effectParam) {
        this.addEventEffect(EffectEventId.onEndScreen, effectParam);
    }

    public void addOnHover(@Nonnull EffectTypeOnHover effectParam) {
        this.addEventEffect(EffectEventId.onHover, effectParam);
    }

    public void addOnStartHover(@Nonnull EffectType effectParam) {
        this.addEventEffect(EffectEventId.onStartHover, effectParam);
    }

    public void addOnEndHover(@Nonnull EffectType effectParam) {
        this.addEventEffect(EffectEventId.onEndHover, effectParam);
    }

    public void addOnClick(@Nonnull EffectType effectParam) {
        this.addEventEffect(EffectEventId.onClick, effectParam);
    }

    public void addOnFocus(@Nonnull EffectType effectParam) {
        this.addEventEffect(EffectEventId.onFocus, effectParam);
    }

    public void addOnLostFocus(@Nonnull EffectType effectParam) {
        this.addEventEffect(EffectEventId.onLostFocus, effectParam);
    }

    public void addOnGetFocus(@Nonnull EffectType effectParam) {
        this.addEventEffect(EffectEventId.onGetFocus, effectParam);
    }

    public void addOnActive(@Nonnull EffectType effectParam) {
        this.addEventEffect(EffectEventId.onActive, effectParam);
    }

    public void addOnShow(@Nonnull EffectType effectParam) {
        this.addEventEffect(EffectEventId.onShow, effectParam);
    }

    public void addOnHide(@Nonnull EffectType effectParam) {
        this.addEventEffect(EffectEventId.onHide, effectParam);
    }

    public void addOnCustom(@Nonnull EffectType effectParam) {
        this.addEventEffect(EffectEventId.onCustom, effectParam);
    }

    public void addOnDisabled(@Nonnull EffectType effectParam) {
        this.addEventEffect(EffectEventId.onDisabled, effectParam);
    }

    public void addOnEnabled(@Nonnull EffectType effectParam) {
        this.addEventEffect(EffectEventId.onEnabled, effectParam);
    }

    public Collection<EffectType> getEventEffectTypes(@Nonnull EffectEventId id) {
        if (this.effects.isSet(id)) {
            return Collections.unmodifiableCollection(this.effects.get(id));
        }
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public String output(int offset) {
        StringBuilder builder = new StringBuilder();
        builder.append(StringHelper.whitespace(offset));
        builder.append("<effects> (").append(this.getAttributes().toString()).append(')');
        for (EffectEventId id : EffectEventId.values()) {
            builder.append(this.getCollectionString(id, offset + 1));
        }
        return builder.toString();
    }

    @Nonnull
    private String getCollectionString(@Nonnull EffectEventId effectId, int offset) {
        if (!this.effects.isSet(effectId)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (EffectType effect : this.effects.get(effectId)) {
            if (builder.length() > 0) {
                builder.append('\n');
            }
            builder.append(StringHelper.whitespace(offset)).append('<').append(effectId.name()).append("> ");
            builder.append(effect.output(offset));
            if (effect.getStyleId() == null) continue;
            builder.append(" [").append(effect.getStyleId()).append(']');
        }
        return builder.toString();
    }

    public void materialize(@Nonnull Nifty nifty, @Nonnull Element element, @Nonnull Screen screen, @Nonnull List<Object> controllers) {
        for (EffectEventId id : EffectEventId.values()) {
            this.initEffect(id, element, nifty, controllers);
        }
    }

    private void initEffect(@Nonnull EffectEventId eventId, @Nonnull Element element, @Nonnull Nifty nifty, @Nonnull List<Object> controllers) {
        Collection<EffectType> effectCollection = this.effects.get(eventId);
        Attributes effectsTypeAttributes = this.getAttributes();
        for (EffectType effectType : effectCollection) {
            effectType.materialize(nifty, element, eventId, effectsTypeAttributes, controllers);
        }
    }

    public void refreshFromAttributes(@Nonnull ControlEffectsAttributes effects) {
        effects.refreshEffectsType(this);
    }

    public void apply(@Nonnull EffectsType dstEffectType, @Nullable String styleId) {
        for (EffectEventId id : EffectEventId.values()) {
            if (!this.effects.isSet(id)) continue;
            this.applyEffectCollection(this.effects.get(id), dstEffectType.effects.get(id), styleId);
        }
    }

    void applyEffectCollection(@Nonnull Collection<EffectType> src, @Nonnull Collection<EffectType> dst, @Nullable String styleId) {
        try {
            for (EffectType effectType : src) {
                EffectType copy = effectType.clone();
                copy.setStyleId(styleId);
                dst.add(copy);
            }
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failure to apply a effect collection!", e);
        }
    }

    public void resolveParameters(@Nonnull Attributes src) {
        for (EffectEventId id : EffectEventId.values()) {
            if (!this.effects.isSet(id)) continue;
            this.resolveParameterCollection(this.effects.get(id), src);
        }
    }

    void resolveParameterCollection(@Nonnull Collection<EffectType> dst, @Nonnull Attributes src) {
        for (EffectType e : dst) {
            e.resolveParameters(src);
        }
    }

    public void removeWithTag(@Nonnull String styleId) {
        this.getAttributes().removeWithTag(styleId);
        for (EffectEventId id : EffectEventId.values()) {
            if (!this.effects.isSet(id)) continue;
            this.removeAllEffectsWithStyleId(this.effects.get(id), styleId);
        }
    }

    private void removeAllEffectsWithStyleId(@Nonnull Collection<EffectType> source, @Nonnull String styleId) {
        Iterator<EffectType> itr = source.iterator();
        while (itr.hasNext()) {
            EffectType current = itr.next();
            if (!styleId.equals(current.getStyleId())) continue;
            itr.remove();
        }
    }

    public boolean hasEffectTypes(@Nonnull EffectEventId id) {
        return this.effects.isSet(id);
    }

    public <T extends ControlEffectAttributes> void convertCopy(@Nonnull EffectEventId effectId, @Nonnull Collection<T> storage) {
        if (this.effects.isSet(effectId)) {
            for (EffectType e : this.effects.get(effectId)) {
                storage.add(e.convert());
            }
        }
    }
}

