/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.loaderv2;

import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.tools.Factory;
import de.lessvoid.xml.tools.ClassHelper;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ControllerFactory {
    @Nonnull
    private final Map<String, Factory<? extends Controller>> registeredControllersFactories = new HashMap<String, Factory<? extends Controller>>();

    public <C extends Controller> void registerFactory(@Nonnull Factory<C> controllerFactory, @Nonnull Class<C> controllerClass) {
        this.registeredControllersFactories.put(controllerClass.getName(), controllerFactory);
    }

    public <C extends Controller> void unregisterFactory(@Nonnull Class<C> controllerClass) {
        this.registeredControllersFactories.remove(controllerClass.getName());
    }

    @Nullable
    public Controller create(@Nullable String controllerClassName) {
        if (controllerClassName == null) {
            return null;
        }
        if (this.registeredControllersFactories.containsKey(controllerClassName)) {
            return this.registeredControllersFactories.get(controllerClassName).createNew();
        }
        return ClassHelper.getInstance(controllerClassName, Controller.class);
    }
}

