/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.input.mouse;

import de.lessvoid.nifty.input.NiftyMouseInputEvent;
import javax.annotation.Nonnull;

public class MouseInputEventProcessor {
    private int lastMouseX = 0;
    private int lastMouseY = 0;
    private int lastMouseWheel = 0;
    private boolean lastButtonDown0 = false;
    private boolean lastButtonDown1 = false;
    private boolean lastButtonDown2 = false;
    private boolean hadAnyEvents = false;

    public void reset() {
        this.lastButtonDown0 = false;
        this.lastButtonDown1 = false;
        this.lastButtonDown2 = false;
    }

    public void begin() {
        this.hadAnyEvents = false;
    }

    public void process(@Nonnull NiftyMouseInputEvent mouse) {
        this.hadAnyEvents = true;
        mouse.setButton0InitialDown(!this.lastButtonDown0 && mouse.isButton0Down());
        mouse.setButton0Release(this.lastButtonDown0 && !mouse.isButton0Down());
        mouse.setButton1InitialDown(!this.lastButtonDown1 && mouse.isButton1Down());
        mouse.setButton1Release(this.lastButtonDown1 && !mouse.isButton1Down());
        mouse.setButton2InitialDown(!this.lastButtonDown2 && mouse.isButton2Down());
        mouse.setButton2Release(this.lastButtonDown2 && !mouse.isButton2Down());
        this.lastMouseX = mouse.getMouseX();
        this.lastMouseY = mouse.getMouseY();
        this.lastMouseWheel = mouse.getMouseWheel();
        this.lastButtonDown0 = mouse.isButton0Down();
        this.lastButtonDown1 = mouse.isButton1Down();
        this.lastButtonDown2 = mouse.isButton2Down();
    }

    public boolean hasLastMouseDownEvent() {
        return !this.hadAnyEvents && (this.lastButtonDown0 || this.lastButtonDown1 || this.lastButtonDown2);
    }

    @Nonnull
    public NiftyMouseInputEvent getLastMouseDownEvent() {
        NiftyMouseInputEvent result = new NiftyMouseInputEvent();
        result.initialize(this.lastMouseX, this.lastMouseY, this.lastMouseWheel, this.lastButtonDown0, this.lastButtonDown1, this.lastButtonDown2);
        return result;
    }
}

