/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.elements;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.MouseClickMethods;
import de.lessvoid.nifty.elements.events.NiftyMousePrimaryClickedEvent;
import de.lessvoid.nifty.elements.events.NiftyMousePrimaryClickedMovedEvent;
import de.lessvoid.nifty.elements.events.NiftyMousePrimaryMultiClickedEvent;
import de.lessvoid.nifty.elements.events.NiftyMousePrimaryReleaseEvent;
import de.lessvoid.nifty.input.NiftyMouseInputEvent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PrimaryClickMouseMethods
extends MouseClickMethods {
    public PrimaryClickMouseMethods(@Nonnull Element element) {
        super(element);
    }

    @Override
    public void onInitialClick() {
        this.element.getFocusHandler().requestExclusiveMouseFocus(this.element);
        if (this.element.isFocusable()) {
            this.element.getFocusHandler().setKeyFocus(this.element);
        }
    }

    @Override
    public boolean onClick(@Nonnull Nifty nifty, @Nullable String onClickAlternateKey, @Nonnull NiftyMouseInputEvent inputEvent) {
        String id = this.element.getId();
        if (id != null) {
            nifty.publishEvent(id, new NiftyMousePrimaryClickedEvent(this.element, inputEvent));
        }
        this.element.startEffectWithoutChildren(EffectEventId.onClick);
        return super.onClick(nifty, onClickAlternateKey, inputEvent);
    }

    @Override
    public boolean onMultiClick(@Nonnull Nifty nifty, @Nullable String onClickAlternateKey, @Nonnull NiftyMouseInputEvent inputEvent, int clickCount) {
        String id = this.element.getId();
        if (id != null) {
            nifty.publishEvent(id, new NiftyMousePrimaryMultiClickedEvent(this.element, inputEvent, clickCount));
        }
        this.element.startEffectWithoutChildren(EffectEventId.onClick);
        return super.onMultiClick(nifty, onClickAlternateKey, inputEvent, clickCount);
    }

    @Override
    public boolean onClickMouseMove(@Nonnull Nifty nifty, @Nonnull NiftyMouseInputEvent inputEvent) {
        String id = this.element.getId();
        if (id != null) {
            nifty.publishEvent(id, new NiftyMousePrimaryClickedMovedEvent(this.element, inputEvent));
        }
        return super.onClickMouseMove(nifty, inputEvent);
    }

    @Override
    public boolean onRelease(@Nonnull Nifty nifty, @Nonnull NiftyMouseInputEvent mouseEvent) {
        String id = this.element.getId();
        if (id != null) {
            nifty.publishEvent(id, new NiftyMousePrimaryReleaseEvent(this.element, mouseEvent));
        }
        boolean result = super.onRelease(nifty, mouseEvent);
        this.element.stopEffectWithoutChildren(EffectEventId.onClick);
        this.element.getFocusHandler().lostMouseFocus(this.element);
        return result;
    }

    @Override
    public void clickAndRelease(@Nonnull Nifty nifty) {
        String id = this.element.getId();
        if (id != null) {
            nifty.publishEvent(id, new NiftyMousePrimaryClickedEvent(this.element));
            nifty.publishEvent(id, new NiftyMousePrimaryReleaseEvent(this.element));
        }
        super.clickAndRelease(nifty);
    }
}

