/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.elements;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyMethodInvoker;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.ElementInteractionClickHandler;
import de.lessvoid.nifty.elements.ElementInteractionMoveHandler;
import de.lessvoid.nifty.elements.PrimaryClickMouseMethods;
import de.lessvoid.nifty.elements.SecondaryClickMouseMethods;
import de.lessvoid.nifty.elements.TertiaryClickMouseMethods;
import de.lessvoid.nifty.input.NiftyMouseInputEvent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ElementInteraction {
    private String onClickAlternateKey;
    @Nullable
    private NiftyMethodInvoker onMouseOverMethod;
    private NiftyMethodInvoker onMouseWheelMethod;
    @Nonnull
    private final ElementInteractionClickHandler primary;
    @Nonnull
    private final ElementInteractionClickHandler secondary;
    @Nonnull
    private final ElementInteractionClickHandler tertiary;
    @Nonnull
    private final ElementInteractionMoveHandler move;

    public ElementInteraction(@Nonnull Nifty niftyParam, @Nonnull Element element) {
        this.primary = new ElementInteractionClickHandler(niftyParam, element, new PrimaryClickMouseMethods(element));
        this.secondary = new ElementInteractionClickHandler(niftyParam, element, new SecondaryClickMouseMethods(element));
        this.tertiary = new ElementInteractionClickHandler(niftyParam, element, new TertiaryClickMouseMethods(element));
        this.move = new ElementInteractionMoveHandler(niftyParam, element);
    }

    public void resetMouseDown() {
        this.primary.resetMouseDown();
        this.secondary.resetMouseDown();
        this.tertiary.resetMouseDown();
    }

    @Nonnull
    public ElementInteractionClickHandler getPrimary() {
        return this.primary;
    }

    @Nonnull
    public ElementInteractionClickHandler getSecondary() {
        return this.secondary;
    }

    @Nonnull
    public ElementInteractionClickHandler getTertiary() {
        return this.tertiary;
    }

    public void setOnMouseOver(@Nullable NiftyMethodInvoker method) {
        this.onMouseOverMethod = method;
    }

    public void setOnMouseWheelMethod(NiftyMethodInvoker method) {
        this.onMouseWheelMethod = method;
    }

    public boolean onMouseOver(Element element, NiftyMouseInputEvent inputEvent) {
        if (this.onMouseOverMethod != null) {
            return this.onMouseOverMethod.invoke(element, inputEvent);
        }
        return false;
    }

    public boolean onMouseWheel(Element element, NiftyMouseInputEvent inputEvent) {
        if (this.onMouseWheelMethod != null) {
            return this.onMouseWheelMethod.invoke(element, inputEvent);
        }
        return false;
    }

    public void setAlternateKey(String newAlternateKey) {
        this.onClickAlternateKey = newAlternateKey;
    }

    public boolean process(@Nonnull NiftyMouseInputEvent mouseEvent, long eventTime, boolean mouseInside, boolean canHandleInteraction, boolean hasMouseAccess) {
        boolean moveResult = this.move.process(canHandleInteraction, mouseInside, hasMouseAccess, mouseEvent);
        boolean clickResult = this.primary.process(mouseEvent, mouseEvent.isButton0Down(), mouseEvent.isButton0InitialDown(), mouseEvent.isButton0Release(), eventTime, mouseInside, canHandleInteraction, hasMouseAccess, this.onClickAlternateKey) || this.secondary.process(mouseEvent, mouseEvent.isButton1Down(), mouseEvent.isButton1InitialDown(), mouseEvent.isButton1Release(), eventTime, mouseInside, canHandleInteraction, hasMouseAccess, this.onClickAlternateKey) || this.tertiary.process(mouseEvent, mouseEvent.isButton2Down(), mouseEvent.isButton2InitialDown(), mouseEvent.isButton2Release(), eventTime, mouseInside, canHandleInteraction, hasMouseAccess, this.onClickAlternateKey);
        return moveResult || clickResult;
    }

    public void clickAndReleasePrimaryMouseButton(@Nonnull Nifty nifty) {
        this.primary.clickAndReleaseMouse(nifty);
    }

    public void clickAndReleaseSecondaryMouseButton(@Nonnull Nifty nifty) {
        this.secondary.clickAndReleaseMouse(nifty);
    }

    public void clickAndReleaseTertiaryMouseButton(@Nonnull Nifty nifty) {
        this.tertiary.clickAndReleaseMouse(nifty);
    }
}

