/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.elements;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.NiftyMethodInvoker;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.FocusHandler;
import de.lessvoid.nifty.controls.NiftyControl;
import de.lessvoid.nifty.controls.NiftyInputControl;
import de.lessvoid.nifty.effects.Effect;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectManager;
import de.lessvoid.nifty.effects.ElementEffectStateCache;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.ElementInteraction;
import de.lessvoid.nifty.elements.events.ElementDisableEvent;
import de.lessvoid.nifty.elements.events.ElementEnableEvent;
import de.lessvoid.nifty.elements.events.ElementHideEvent;
import de.lessvoid.nifty.elements.events.ElementShowEvent;
import de.lessvoid.nifty.elements.render.ElementRenderer;
import de.lessvoid.nifty.elements.render.ImageRenderer;
import de.lessvoid.nifty.elements.render.PanelRenderer;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.elements.tools.ElementTreeTraverser;
import de.lessvoid.nifty.input.NiftyMouseInputEvent;
import de.lessvoid.nifty.input.keyboard.KeyboardInputEvent;
import de.lessvoid.nifty.layout.BoxConstraints;
import de.lessvoid.nifty.layout.LayoutPart;
import de.lessvoid.nifty.layout.align.HorizontalAlign;
import de.lessvoid.nifty.layout.align.VerticalAlign;
import de.lessvoid.nifty.layout.manager.LayoutManager;
import de.lessvoid.nifty.loaderv2.types.ElementType;
import de.lessvoid.nifty.loaderv2.types.PopupType;
import de.lessvoid.nifty.loaderv2.types.apply.ApplyRenderText;
import de.lessvoid.nifty.loaderv2.types.apply.ApplyRenderer;
import de.lessvoid.nifty.loaderv2.types.apply.ApplyRendererImage;
import de.lessvoid.nifty.loaderv2.types.apply.ApplyRendererPanel;
import de.lessvoid.nifty.loaderv2.types.apply.Convert;
import de.lessvoid.nifty.loaderv2.types.helper.PaddingAttributeParser;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.screen.KeyInputHandler;
import de.lessvoid.nifty.screen.MouseOverHandler;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.spi.time.TimeProvider;
import de.lessvoid.nifty.tools.SizeValue;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bushe.swing.event.EventTopicSubscriber;

public class Element
implements NiftyEvent,
EffectManager.Notify {
    @Nonnull
    private static final Logger log = Logger.getLogger(Element.class.getName());
    @Nonnull
    private final ElementType elementType;
    @Nullable
    private String id;
    private int renderOrder;
    @Nullable
    private Element parent;
    @Nullable
    private List<Element> children;
    @Nullable
    private Set<Element> elementsRenderOrderSet;
    @Nonnull
    private static final Comparator<Element> RENDER_ORDER_COMPARATOR = new RenderOrderComparator();
    @Nullable
    private Element[] elementsRenderOrder;
    @Nullable
    private LayoutManager layoutManager;
    @Nonnull
    private final LayoutPart layoutPart;
    @Nonnull
    private final ElementRenderer[] elementRenderer;
    @Nonnull
    private EffectManager effectManager;
    @Nonnull
    private ElementInteraction interaction;
    @Nonnull
    private final ElementEffectStateCache effectStateCache = new ElementEffectStateCache();
    @Nonnull
    private final Nifty nifty;
    @Nonnull
    private final FocusHandler focusHandler;
    private boolean enabled;
    private int enabledCount;
    private boolean visible;
    private boolean done;
    private boolean interactionBlocked;
    private boolean visibleToMouseEvents;
    private boolean clipChildren;
    @Nullable
    private NiftyInputControl attachedInputControl = null;
    private boolean focusable = false;
    @Nullable
    private String focusableInsertBeforeElementId;
    @Nullable
    private Screen screen;
    @Nonnull
    private TimeProvider time;
    @Nonnull
    private final List<String> elementDebugOut = new ArrayList<String>();
    @Nonnull
    private final StringBuilder elementDebug = new StringBuilder();
    private boolean parentClipArea = false;
    private int parentClipX;
    private int parentClipY;
    private int parentClipWidth;
    private int parentClipHeight;
    private boolean constraintsChanged;
    private boolean ignoreMouseEvents;
    private boolean ignoreKeyboardEvents;
    @Nonnull
    private static final Convert convert = new Convert();
    @Nonnull
    private static final Map<Class<? extends ElementRenderer>, ApplyRenderer> rendererApplier = new HashMap<Class<? extends ElementRenderer>, ApplyRenderer>();
    @Nullable
    private Map<String, Object> userData;
    private final StyleRefresh styleListener = new StyleRefresh();

    public Element(@Nonnull Nifty nifty, @Nonnull ElementType elementType, @Nullable String id, @Nullable Element parent, @Nonnull FocusHandler focusHandler, boolean visibleToMouseEvents, @Nonnull TimeProvider timeProvider, ElementRenderer ... elementRenderer) {
        this(nifty, elementType, id, parent, new LayoutPart(), focusHandler, visibleToMouseEvents, timeProvider, elementRenderer);
    }

    public Element(@Nonnull Nifty nifty, @Nonnull ElementType elementType, @Nullable String id, @Nullable Element parent, @Nonnull LayoutPart layoutPart, @Nonnull FocusHandler focusHandler, boolean visibleToMouseEvents, @Nonnull TimeProvider timeProvider, ElementRenderer ... elementRenderer) {
        this.nifty = nifty;
        this.elementType = elementType;
        this.id = id;
        this.parent = parent;
        this.elementRenderer = elementRenderer;
        this.effectManager = new EffectManager(this);
        this.effectManager.setAlternateKey(this.nifty.getAlternateKey());
        this.layoutPart = layoutPart;
        this.enabled = true;
        this.enabledCount = 0;
        this.visible = true;
        this.done = false;
        this.interactionBlocked = false;
        this.focusHandler = focusHandler;
        this.visibleToMouseEvents = visibleToMouseEvents;
        this.time = timeProvider;
        this.interaction = new ElementInteraction(this.nifty, this);
    }

    public void initializeFromAttributes(@Nonnull Screen targetScreen, @Nonnull Attributes attributes, @Nonnull NiftyRenderEngine renderEngine) {
        BoxConstraints boxConstraints = this.layoutPart.getBoxConstraints();
        boxConstraints.setHeight(convert.sizeValue(attributes.get("height")));
        boxConstraints.setWidth(convert.sizeValue(attributes.get("width")));
        boxConstraints.setX(convert.sizeValue(attributes.get("x")));
        boxConstraints.setY(convert.sizeValue(attributes.get("y")));
        boxConstraints.setHorizontalAlign(convert.horizontalAlign(attributes.get("align")));
        boxConstraints.setVerticalAlign(convert.verticalAlign(attributes.get("valign")));
        String paddingLeft = "0px";
        String paddingRight = "0px";
        String paddingTop = "0px";
        String paddingBottom = "0px";
        if (attributes.isSet("padding")) {
            try {
                String padding = attributes.get("padding");
                assert (padding != null);
                PaddingAttributeParser paddingParser = new PaddingAttributeParser(padding);
                paddingLeft = paddingParser.getLeft();
                paddingRight = paddingParser.getRight();
                paddingTop = paddingParser.getTop();
                paddingBottom = paddingParser.getBottom();
            }
            catch (Exception e) {
                log.warning(e.getMessage());
            }
        }
        boxConstraints.setPaddingLeft(convert.paddingSizeValue(attributes.get("paddingLeft"), paddingLeft));
        boxConstraints.setPaddingRight(convert.paddingSizeValue(attributes.get("paddingRight"), paddingRight));
        boxConstraints.setPaddingTop(convert.paddingSizeValue(attributes.get("paddingTop"), paddingTop));
        boxConstraints.setPaddingBottom(convert.paddingSizeValue(attributes.get("paddingBottom"), paddingBottom));
        String marginLeft = "0px";
        String marginRight = "0px";
        String marginTop = "0px";
        String marginBottom = "0px";
        if (attributes.isSet("margin")) {
            try {
                String margin = attributes.get("margin");
                assert (margin != null);
                PaddingAttributeParser marginParser = new PaddingAttributeParser(margin);
                marginLeft = marginParser.getLeft();
                marginRight = marginParser.getRight();
                marginTop = marginParser.getTop();
                marginBottom = marginParser.getBottom();
            }
            catch (Exception e) {
                log.warning(e.getMessage());
            }
        }
        boxConstraints.setMarginLeft(convert.paddingSizeValue(attributes.get("marginLeft"), marginLeft));
        boxConstraints.setMarginRight(convert.paddingSizeValue(attributes.get("marginRight"), marginRight));
        boxConstraints.setMarginTop(convert.paddingSizeValue(attributes.get("marginTop"), marginTop));
        boxConstraints.setMarginBottom(convert.paddingSizeValue(attributes.get("marginBottom"), marginBottom));
        this.clipChildren = attributes.getAsBoolean("childClip", false);
        this.renderOrder = attributes.getAsInteger("renderOrder", 0);
        boolean visible = attributes.getAsBoolean("visible", true);
        if (visible) {
            this.visible = true;
        }
        this.visibleToMouseEvents = attributes.getAsBoolean("visibleToMouse", false);
        this.layoutManager = convert.layoutManager(attributes.get("childLayout"));
        this.focusable = attributes.getAsBoolean("focusable", false);
        this.focusableInsertBeforeElementId = attributes.get("focusableInsertBeforeElementId");
        for (int i = 0; i < this.elementRenderer.length; ++i) {
            ElementRenderer renderer = this.elementRenderer[i];
            ApplyRenderer rendererApply = rendererApplier.get(renderer.getClass());
            rendererApply.apply(targetScreen, this, attributes, renderEngine);
        }
        this.nifty.getEventService().subscribeStrongly("style-refresh:" + this.getStyle(), (EventTopicSubscriber)this.styleListener);
    }

    public void initializeFromPostAttributes(@Nonnull Attributes attributes) {
        this.visible = attributes.getAsBoolean("visible", true);
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nonnull
    public Element getParent() {
        return this.parent == null ? this : this.parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public void setParent(@Nullable Element element) {
        this.parent = element;
        if (this.parentHasClipArea()) {
            this.setParentClipArea(this.parentClipX, this.parentClipY, this.parentClipWidth, this.parentClipHeight);
            this.publishEvent();
        } else {
            this.parentClipArea = false;
        }
    }

    private boolean parentHasClipArea() {
        if (this.parent == null) {
            return false;
        }
        return this.parent.parentClipArea;
    }

    @Nonnull
    public String getElementStateString(@Nonnull String offset) {
        return this.getElementStateString(offset, ".*");
    }

    @Nonnull
    public String getElementStateString(@Nonnull String offset, @Nonnull String regex) {
        this.elementDebugOut.clear();
        this.elementDebugOut.add(" type: [" + this.elementType.output(offset.length()) + "]");
        this.elementDebugOut.add(" style [" + this.getElementType().getAttributes().get("style") + "]");
        this.elementDebugOut.add(" state [" + this.getState() + "]");
        this.elementDebugOut.add(" position [x=" + this.getX() + ", y=" + this.getY() + ", w=" + this.getWidth() + ", h=" + this.getHeight() + "]");
        this.elementDebugOut.add(" constraint [" + this.outputSizeValue(this.layoutPart.getBoxConstraints().getX()) + ", " + this.outputSizeValue(this.layoutPart.getBoxConstraints().getY()) + ", " + this.outputSizeValue(this.layoutPart.getBoxConstraints().getWidth()) + ", " + this.outputSizeValue(this.layoutPart.getBoxConstraints().getHeight()) + "]");
        this.elementDebugOut.add(" padding [" + this.outputSizeValue(this.layoutPart.getBoxConstraints().getPaddingLeft()) + ", " + this.outputSizeValue(this.layoutPart.getBoxConstraints().getPaddingRight()) + ", " + this.outputSizeValue(this.layoutPart.getBoxConstraints().getPaddingTop()) + ", " + this.outputSizeValue(this.layoutPart.getBoxConstraints().getPaddingBottom()) + "]");
        this.elementDebugOut.add(" margin [" + this.outputSizeValue(this.layoutPart.getBoxConstraints().getMarginLeft()) + ", " + this.outputSizeValue(this.layoutPart.getBoxConstraints().getMarginRight()) + ", " + this.outputSizeValue(this.layoutPart.getBoxConstraints().getMarginTop()) + ", " + this.outputSizeValue(this.layoutPart.getBoxConstraints().getMarginBottom()) + "]");
        StringBuilder state = new StringBuilder();
        if (this.focusable) {
            state.append(" focusable");
        }
        if (this.enabled) {
            if (state.length() > 0) {
                state.append(",");
            }
            state.append(" enabled(").append(this.enabledCount).append(")");
        }
        if (this.visible) {
            if (state.length() > 0) {
                state.append(",");
            }
            state.append(" visible");
        }
        if (this.visibleToMouseEvents) {
            if (state.length() > 0) {
                state.append(",");
            }
            state.append(" mouseable");
        }
        if (this.clipChildren) {
            if (state.length() > 0) {
                state.append(",");
            }
            state.append(" clipChildren");
        }
        this.elementDebugOut.add(" flags [" + state + "]");
        this.elementDebugOut.add(" effects [" + this.effectManager.getStateString(offset) + "]");
        this.elementDebugOut.add(" renderOrder [" + this.renderOrder + "]");
        if (this.parentClipArea) {
            this.elementDebugOut.add(" parent clip [x=" + this.parentClipX + ", y=" + this.parentClipY + ", w=" + this.parentClipWidth + ", h=" + this.parentClipHeight + "]");
        }
        StringBuilder renderOrder = new StringBuilder();
        renderOrder.append(" render order: ");
        if (this.children != null && this.elementsRenderOrderSet != null) {
            for (Element e : this.elementsRenderOrderSet) {
                renderOrder.append("[").append(e.id).append(" (").append(e.renderOrder == 0 ? this.children.indexOf(e) : e.renderOrder).append(")]");
            }
        }
        this.elementDebugOut.add(renderOrder.toString());
        this.elementDebug.delete(0, this.elementDebug.length());
        for (int i = 0; i < this.elementDebugOut.size(); ++i) {
            String line = this.elementDebugOut.get(i);
            if (!line.matches(regex)) continue;
            if (this.elementDebug.length() > 0) {
                this.elementDebug.append("\n").append(offset);
            }
            this.elementDebug.append(line);
        }
        return this.elementDebug.toString();
    }

    @Nonnull
    private String getState() {
        if (this.isEffectActive(EffectEventId.onStartScreen)) {
            return "starting";
        }
        if (this.isEffectActive(EffectEventId.onEndScreen)) {
            return "ending";
        }
        if (!this.visible) {
            return "hidden";
        }
        if (this.interactionBlocked) {
            return "interactionBlocked";
        }
        if (!this.enabled) {
            return "disabled";
        }
        return "normal";
    }

    @Nullable
    private String outputSizeValue(@Nullable SizeValue value) {
        if (value == null) {
            return "null";
        }
        return value.toString();
    }

    public int getX() {
        return this.layoutPart.getBox().getX();
    }

    public int getY() {
        return this.layoutPart.getBox().getY();
    }

    public int getHeight() {
        return this.layoutPart.getBox().getHeight();
    }

    public int getWidth() {
        return this.layoutPart.getBox().getWidth();
    }

    public void setHeight(int height) {
        this.layoutPart.getBox().setHeight(height);
    }

    public void setWidth(int width) {
        this.layoutPart.getBox().setWidth(width);
    }

    @Nonnull
    public List<Element> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.children);
    }

    public int getChildrenCount() {
        return this.elementsRenderOrder != null ? this.elementsRenderOrder.length : 0;
    }

    @Nonnull
    public Iterator<Element> getDescendants() {
        if (this.children == null) {
            return Element.emptyIterator();
        }
        return new ElementTreeTraverser(this);
    }

    public void addChild(@Nonnull Element child) {
        this.insertChild(child, this.getChildrenCount());
    }

    public void insertChild(@Nonnull Element child, int index) {
        int lastValidIndex = this.getChildrenCount();
        int usedIndex = index;
        if (index < 0 || index > lastValidIndex) {
            log.severe("Index is out of range. Index: " + index + " Last valid: " + lastValidIndex);
            usedIndex = Math.min(lastValidIndex, Math.max(0, index));
        }
        if (this.children == null) {
            this.children = new ArrayList<Element>();
        }
        this.children.add(usedIndex, child);
        if (this.elementsRenderOrderSet == null) {
            this.elementsRenderOrderSet = new TreeSet<Element>(RENDER_ORDER_COMPARATOR);
        }
        if (!this.elementsRenderOrderSet.add(child)) {
            log.severe("Adding the element failed as it seems this element is already part of the children list. This is bad. Rebuilding the children list is required now.");
            int childCount = this.children.size();
            boolean foundProblem = false;
            for (int i = 0; i < childCount; ++i) {
                Element testChild;
                if (i == usedIndex || !(testChild = this.children.get(i)).equals(child)) continue;
                foundProblem = true;
                this.children.remove(i);
                break;
            }
            if (!foundProblem) {
                this.children.remove(usedIndex);
                throw new IllegalStateException("Insert item failed, render list refused the item, but duplicate couldn't be located in the children list. Element is corrupted.");
            }
        } else {
            this.elementsRenderOrder = this.elementsRenderOrderSet.toArray(new Element[this.elementsRenderOrderSet.size()]);
        }
    }

    public void setIndex(int index) {
        if (this.parent == null) {
            return;
        }
        List<Element> parentChildren = this.parent.children;
        if (parentChildren == null) {
            log.severe("Element tree corrupted. Parent element has not children.");
        } else {
            int curInd = parentChildren.indexOf(this);
            if (curInd >= 0 && index != curInd) {
                Element shouldBeThis = parentChildren.remove(curInd);
                if (shouldBeThis.equals(this)) {
                    parentChildren.add(index, this);
                } else {
                    log.severe("Setting index failed, detected index did not return correct element. Undoing operation");
                    parentChildren.add(curInd, shouldBeThis);
                }
            }
        }
    }

    public void render(@Nonnull NiftyRenderEngine r) {
        if (this.visible) {
            if (this.effectManager.isEmpty()) {
                r.saveStates();
                this.renderElement(r);
                this.renderChildren(r);
                r.restoreStates();
            } else {
                r.saveStates();
                this.effectManager.renderPre(r, this);
                this.renderElement(r);
                this.effectManager.renderPost(r, this);
                this.renderChildren(r);
                r.restoreStates();
                r.saveStates();
                this.effectManager.renderOverlay(r, this);
                r.restoreStates();
            }
        }
    }

    private void renderElement(@Nonnull NiftyRenderEngine r) {
        for (int i = 0; i < this.elementRenderer.length; ++i) {
            ElementRenderer renderer = this.elementRenderer[i];
            renderer.render(this, r);
        }
    }

    private void renderChildren(@Nonnull NiftyRenderEngine r) {
        if (this.clipChildren) {
            r.enableClip(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight());
            this.renderInternalChildElements(r);
            r.disableClip();
        } else {
            this.renderInternalChildElements(r);
        }
    }

    private void renderInternalChildElements(@Nonnull NiftyRenderEngine r) {
        if (this.elementsRenderOrder != null) {
            for (int i = 0; i < this.elementsRenderOrder.length; ++i) {
                Element p = this.elementsRenderOrder[i];
                p.render(r);
            }
        }
    }

    public void setLayoutManager(@Nullable LayoutManager newLayout) {
        this.layoutManager = newLayout;
    }

    public void resetLayout() {
        TextRenderer textRenderer = this.getRenderer(TextRenderer.class);
        if (textRenderer != null) {
            textRenderer.resetLayout(this);
        }
        if (this.children != null) {
            int childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                Element e = this.children.get(i);
                e.resetLayout();
            }
        }
    }

    private void preProcessConstraintWidth() {
        if (this.children != null) {
            int childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                Element e = this.children.get(i);
                e.preProcessConstraintWidth();
            }
        }
        this.preProcessConstraintWidthThisLevel();
    }

    private void preProcessConstraintWidthThisLevel() {
        SizeValue myWidth = this.getConstraintWidth();
        if (this.layoutManager != null) {
            if (myWidth.hasDefault()) {
                List<LayoutPart> layoutPartChild = this.getLayoutChildrenWithIndependentWidth();
                if (!layoutPartChild.isEmpty() && this.getChildrenCount() == layoutPartChild.size()) {
                    SizeValue newWidth = this.layoutManager.calculateConstraintWidth(this.layoutPart, layoutPartChild);
                    if (newWidth.hasValue()) {
                        int newWidthPx = newWidth.getValueAsInt(0.0f);
                        newWidthPx += this.layoutPart.getBoxConstraints().getPaddingLeft().getValueAsInt(newWidth.getValueAsInt(newWidthPx));
                        newWidthPx += this.layoutPart.getBoxConstraints().getPaddingRight().getValueAsInt(newWidth.getValueAsInt(newWidthPx));
                        this.setConstraintWidth(SizeValue.def(newWidthPx));
                    }
                } else {
                    this.setConstraintWidth(SizeValue.def());
                }
            } else if (myWidth.hasSum()) {
                List<LayoutPart> layoutPartChild = this.getLayoutChildrenWithIndependentWidth();
                SizeValue newWidth = this.layoutPart.getSumWidth(layoutPartChild);
                if (newWidth.hasValue()) {
                    int newWidthPx = newWidth.getValueAsInt(0.0f);
                    newWidthPx += this.layoutPart.getBoxConstraints().getPaddingLeft().getValueAsInt(newWidth.getValueAsInt(newWidthPx));
                    newWidthPx += this.layoutPart.getBoxConstraints().getPaddingRight().getValueAsInt(newWidth.getValueAsInt(newWidthPx));
                    this.setConstraintWidth(SizeValue.sum(newWidthPx));
                } else {
                    this.setConstraintWidth(SizeValue.sum(0));
                }
            } else if (myWidth.hasMax()) {
                List<LayoutPart> layoutPartChild = this.getLayoutChildrenWithIndependentWidth();
                SizeValue newWidth = this.layoutPart.getMaxWidth(layoutPartChild);
                if (newWidth.hasValue()) {
                    int newWidthPx = newWidth.getValueAsInt(0.0f);
                    newWidthPx += this.layoutPart.getBoxConstraints().getPaddingLeft().getValueAsInt(newWidth.getValueAsInt(newWidthPx));
                    newWidthPx += this.layoutPart.getBoxConstraints().getPaddingRight().getValueAsInt(newWidth.getValueAsInt(newWidthPx));
                    this.setConstraintWidth(SizeValue.max(newWidthPx));
                } else {
                    this.setConstraintWidth(SizeValue.max(0));
                }
            }
        }
    }

    @Nonnull
    private List<LayoutPart> getLayoutChildrenWithIndependentWidth() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        int childrenCount = this.children.size();
        ArrayList<LayoutPart> layoutPartChild = new ArrayList<LayoutPart>(childrenCount);
        for (int i = 0; i < childrenCount; ++i) {
            Element e = this.children.get(i);
            SizeValue childWidth = e.getConstraintWidth();
            if (!childWidth.isPixel() || !childWidth.isIndependentFromParent()) continue;
            layoutPartChild.add(e.layoutPart);
        }
        return layoutPartChild;
    }

    private void preProcessConstraintHeight() {
        if (this.children != null) {
            int childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                Element e = this.children.get(i);
                e.preProcessConstraintHeight();
            }
        }
        this.preProcessConstraintHeightThisLevel();
    }

    private void preProcessConstraintHeightThisLevel() {
        SizeValue myHeight = this.getConstraintHeight();
        if (this.layoutManager != null) {
            if (myHeight.hasDefault()) {
                List<LayoutPart> layoutPartChild = this.getLayoutChildrenWithIndependentHeight();
                if (!layoutPartChild.isEmpty() && this.getChildrenCount() == layoutPartChild.size()) {
                    SizeValue newHeight = this.layoutManager.calculateConstraintHeight(this.layoutPart, layoutPartChild);
                    if (newHeight.hasValue()) {
                        int newHeightPx = newHeight.getValueAsInt(0.0f);
                        newHeightPx += this.layoutPart.getBoxConstraints().getPaddingTop().getValueAsInt(newHeight.getValueAsInt(newHeightPx));
                        newHeightPx += this.layoutPart.getBoxConstraints().getPaddingBottom().getValueAsInt(newHeight.getValueAsInt(newHeightPx));
                        this.setConstraintHeight(SizeValue.def(newHeightPx));
                    }
                } else {
                    this.setConstraintHeight(SizeValue.def());
                }
            } else if (myHeight.hasSum()) {
                List<LayoutPart> layoutPartChild = this.getLayoutChildrenWithIndependentHeight();
                SizeValue newHeight = this.layoutPart.getSumHeight(layoutPartChild);
                if (newHeight.hasValue()) {
                    int newHeightPx = newHeight.getValueAsInt(0.0f);
                    newHeightPx += this.layoutPart.getBoxConstraints().getPaddingTop().getValueAsInt(newHeight.getValueAsInt(newHeightPx));
                    newHeightPx += this.layoutPart.getBoxConstraints().getPaddingBottom().getValueAsInt(newHeight.getValueAsInt(newHeightPx));
                    this.setConstraintHeight(SizeValue.sum(newHeightPx));
                } else {
                    this.setConstraintHeight(SizeValue.sum(0));
                }
            } else if (myHeight.hasMax()) {
                List<LayoutPart> layoutPartChild = this.getLayoutChildrenWithIndependentHeight();
                SizeValue newHeight = this.layoutPart.getMaxHeight(layoutPartChild);
                if (newHeight.hasValue()) {
                    int newHeightPx = newHeight.getValueAsInt(0.0f);
                    newHeightPx += this.layoutPart.getBoxConstraints().getPaddingTop().getValueAsInt(newHeight.getValueAsInt(newHeightPx));
                    newHeightPx += this.layoutPart.getBoxConstraints().getPaddingBottom().getValueAsInt(newHeight.getValueAsInt(newHeightPx));
                    this.setConstraintHeight(SizeValue.max(newHeightPx));
                } else {
                    this.setConstraintHeight(SizeValue.max(0));
                }
            }
        }
    }

    @Nonnull
    private List<LayoutPart> getLayoutChildrenWithIndependentHeight() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        int childrenCount = this.children.size();
        ArrayList<LayoutPart> layoutPartChild = new ArrayList<LayoutPart>(childrenCount);
        for (int i = 0; i < childrenCount; ++i) {
            Element e = this.children.get(i);
            SizeValue childHeight = e.getConstraintHeight();
            if (!childHeight.isPixel() || !childHeight.isIndependentFromParent()) continue;
            layoutPartChild.add(e.layoutPart);
        }
        return layoutPartChild;
    }

    private void processLayoutInternal() {
        if (this.children != null) {
            int childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                Element w = this.children.get(i);
                TextRenderer textRenderer = w.getRenderer(TextRenderer.class);
                if (textRenderer == null) continue;
                textRenderer.setWidthConstraint(w, w.getConstraintWidth(), this.getWidth(), this.nifty.getRenderEngine());
            }
        }
    }

    private void processLayout() {
        int childrenCount;
        this.processLayoutInternal();
        if (this.layoutManager != null) {
            NiftyControl niftyControl;
            if (this.children != null) {
                childrenCount = this.children.size();
                ArrayList<LayoutPart> layoutPartChild = new ArrayList<LayoutPart>(childrenCount);
                for (int i = 0; i < childrenCount; ++i) {
                    Element w = this.children.get(i);
                    layoutPartChild.add(w.layoutPart);
                }
                this.layoutManager.layoutElements(this.layoutPart, layoutPartChild);
            }
            if (this.attachedInputControl != null && (niftyControl = this.attachedInputControl.getNiftyControl(NiftyControl.class)) != null && niftyControl.isBound()) {
                niftyControl.layoutCallback();
            }
            if (this.children != null) {
                childrenCount = this.children.size();
                for (int i = 0; i < childrenCount; ++i) {
                    Element w = this.children.get(i);
                    w.processLayout();
                }
            }
        }
        if (this.clipChildren && this.children != null) {
            childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                Element w = this.children.get(i);
                w.setParentClipArea(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            }
        }
    }

    public void layoutElements() {
        this.prepareLayout();
        this.processLayout();
        this.prepareLayout();
        this.processLayout();
        this.prepareLayout();
        this.processLayout();
        this.publishConstraintsChangedEvent();
    }

    private void publishConstraintsChangedEvent() {
        if (this.constraintsChanged) {
            this.publishEvent();
            this.constraintsChanged = false;
        }
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                this.children.get(i).publishConstraintsChangedEvent();
            }
        }
    }

    private void prepareLayout() {
        this.preProcessConstraintWidth();
        this.preProcessConstraintHeight();
    }

    private void setParentClipArea(int x, int y, int width, int height) {
        this.parentClipArea = true;
        this.parentClipX = x;
        this.parentClipY = y;
        this.parentClipWidth = width;
        this.parentClipHeight = height;
        if (this.children != null) {
            int childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                Element w = this.children.get(i);
                w.setParentClipArea(this.parentClipX, this.parentClipY, this.parentClipWidth, this.parentClipHeight);
            }
        }
    }

    public void resetEffects() {
        this.effectManager.reset();
        if (this.children != null) {
            int childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                Element w = this.children.get(i);
                w.resetEffects();
            }
        }
    }

    public void resetAllEffects() {
        this.effectManager.resetAll();
        if (this.children != null) {
            int childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                Element w = this.children.get(i);
                w.resetAllEffects();
            }
        }
    }

    public void restoreForShow() {
        this.effectManager.restoreForShow();
        if (this.children != null) {
            int childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                Element w = this.children.get(i);
                w.restoreForShow();
            }
        }
    }

    public void resetForHide() {
        this.effectManager.resetForHide();
        if (this.children != null) {
            int childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                Element w = this.children.get(i);
                w.resetForHide();
            }
        }
    }

    public void resetSingleEffect(@Nonnull EffectEventId effectEventId) {
        this.effectManager.resetSingleEffect(effectEventId);
        if (this.children != null) {
            int childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                Element w = this.children.get(i);
                w.resetSingleEffect(effectEventId);
            }
        }
    }

    public void resetSingleEffect(@Nonnull EffectEventId effectEventId, @Nonnull String customKey) {
        this.effectManager.resetSingleEffect(effectEventId, customKey);
        if (this.children != null) {
            int childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                Element w = this.children.get(i);
                w.resetSingleEffect(effectEventId, customKey);
            }
        }
    }

    public void resetMouseDown() {
        this.interaction.resetMouseDown();
        if (this.children != null) {
            int childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                Element w = this.children.get(i);
                w.resetMouseDown();
            }
        }
    }

    public void setConstraintX(@Nonnull SizeValue newX) {
        this.layoutPart.getBoxConstraints().setX(newX);
        this.notifyListeners();
    }

    public void setConstraintY(@Nonnull SizeValue newY) {
        this.layoutPart.getBoxConstraints().setY(newY);
        this.notifyListeners();
    }

    public void setConstraintWidth(@Nonnull SizeValue newWidth) {
        this.layoutPart.getBoxConstraints().setWidth(newWidth);
        this.notifyListeners();
    }

    public void setConstraintHeight(@Nonnull SizeValue newHeight) {
        this.layoutPart.getBoxConstraints().setHeight(newHeight);
        this.notifyListeners();
    }

    @Nonnull
    public SizeValue getConstraintX() {
        return this.layoutPart.getBoxConstraints().getX();
    }

    @Nonnull
    public SizeValue getConstraintY() {
        return this.layoutPart.getBoxConstraints().getY();
    }

    @Nonnull
    public SizeValue getConstraintWidth() {
        return this.layoutPart.getBoxConstraints().getWidth();
    }

    @Nonnull
    public SizeValue getConstraintHeight() {
        return this.layoutPart.getBoxConstraints().getHeight();
    }

    public void setConstraintHorizontalAlign(@Nonnull HorizontalAlign newHorizontalAlign) {
        this.layoutPart.getBoxConstraints().setHorizontalAlign(newHorizontalAlign);
    }

    public void setConstraintVerticalAlign(@Nonnull VerticalAlign newVerticalAlign) {
        this.layoutPart.getBoxConstraints().setVerticalAlign(newVerticalAlign);
    }

    @Nonnull
    public HorizontalAlign getConstraintHorizontalAlign() {
        return this.layoutPart.getBoxConstraints().getHorizontalAlign();
    }

    @Nonnull
    public VerticalAlign getConstraintVerticalAlign() {
        return this.layoutPart.getBoxConstraints().getVerticalAlign();
    }

    public void registerEffect(@Nonnull EffectEventId theId, @Nonnull Effect e) {
        log.fine("[" + this.id + "] register: " + theId.toString() + "(" + e.getStateString() + ")");
        this.effectManager.registerEffect(theId, e);
    }

    public void startEffect(@Nonnull EffectEventId effectEventId) {
        this.startEffect(effectEventId, null);
    }

    public void startEffect(@Nonnull EffectEventId effectEventId, @Nullable EndNotify effectEndNotify) {
        this.startEffect(effectEventId, effectEndNotify, null);
    }

    public void startEffect(@Nonnull EffectEventId effectEventId, @Nullable EndNotify effectEndNotify, @Nullable String customKey) {
        this.startEffectDoIt(effectEventId, effectEndNotify, customKey, true);
    }

    public void startEffectWithoutChildren(@Nonnull EffectEventId effectEventId) {
        this.startEffectWithoutChildren(effectEventId, null);
    }

    public void startEffectWithoutChildren(@Nonnull EffectEventId effectEventId, @Nullable EndNotify effectEndNotify) {
        this.startEffectWithoutChildren(effectEventId, effectEndNotify, null);
    }

    public void startEffectWithoutChildren(@Nonnull EffectEventId effectEventId, @Nullable EndNotify effectEndNotify, @Nullable String customKey) {
        this.startEffectDoIt(effectEventId, effectEndNotify, customKey, false);
    }

    private void startEffectDoIt(@Nonnull EffectEventId effectEventId, @Nullable EndNotify effectEndNotify, @Nullable String customKey, boolean withChildren) {
        if (effectEventId == EffectEventId.onStartScreen) {
            if (!this.visible) {
                return;
            }
            this.done = false;
            this.interactionBlocked = true;
        }
        if (effectEventId == EffectEventId.onEndScreen) {
            if (!this.visible && effectEndNotify != null) {
                effectEndNotify.perform();
                return;
            }
            this.done = true;
            this.interactionBlocked = true;
        }
        LocalEndNotify forwardToSelf = new LocalEndNotify(effectEventId, effectEndNotify);
        if (effectEventId != EffectEventId.onShow || effectEventId == EffectEventId.onShow && this.visible) {
            this.effectManager.startEffect(effectEventId, this, this.time, forwardToSelf, customKey);
        }
        if (withChildren && this.children != null) {
            int childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                Element w = this.children.get(i);
                w.startEffectInternal(effectEventId, forwardToSelf, customKey);
            }
        }
        if (effectEventId == EffectEventId.onFocus && this.attachedInputControl != null) {
            this.attachedInputControl.onFocus(true);
        }
        forwardToSelf.perform();
    }

    private void startEffectInternal(@Nonnull EffectEventId effectEventId, @Nullable EndNotify effectEndNotify, @Nullable String customKey) {
        if (effectEventId == EffectEventId.onStartScreen) {
            if (!this.visible) {
                return;
            }
            this.done = false;
            this.interactionBlocked = true;
        }
        if (effectEventId == EffectEventId.onEndScreen) {
            if (!this.visible) {
                return;
            }
            this.done = true;
            this.interactionBlocked = true;
        }
        LocalEndNotify forwardToSelf = new LocalEndNotify(effectEventId, effectEndNotify);
        this.effectManager.startEffect(effectEventId, this, this.time, forwardToSelf, customKey);
        if (this.children != null) {
            int childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                Element w = this.children.get(i);
                w.startEffectInternal(effectEventId, forwardToSelf, customKey);
            }
        }
        if (effectEventId == EffectEventId.onFocus && this.attachedInputControl != null) {
            this.attachedInputControl.onFocus(true);
        }
    }

    public void stopEffect(@Nonnull EffectEventId effectEventId) {
        this.stopEffectInternal(effectEventId, true);
    }

    public void stopEffectWithoutChildren(@Nonnull EffectEventId effectEventId) {
        this.stopEffectInternal(effectEventId, false);
    }

    private void stopEffectInternal(@Nonnull EffectEventId effectEventId, boolean withChildren) {
        if (EffectEventId.onStartScreen == effectEventId || EffectEventId.onEndScreen == effectEventId) {
            this.interactionBlocked = false;
            if (!this.visible) {
                return;
            }
        }
        this.effectManager.stopEffect(effectEventId);
        if (withChildren && this.children != null) {
            int childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                Element w = this.children.get(i);
                w.stopEffect(effectEventId);
            }
        }
        if (effectEventId == EffectEventId.onFocus && this.attachedInputControl != null) {
            this.attachedInputControl.onFocus(false);
        }
    }

    public boolean isEffectActive(@Nonnull EffectEventId effectEventId) {
        return this.effectStateCache.get(effectEventId);
    }

    public void enable() {
        if (this.enabled) {
            return;
        }
        this.enableInternal();
    }

    private void enableInternal() {
        block4: {
            block3: {
                ++this.enabledCount;
                if (this.enabledCount != 0) break block3;
                this.enabled = true;
                this.enableEffect();
                if (this.children == null) break block4;
                int childrenCount = this.children.size();
                for (int i = 0; i < childrenCount; ++i) {
                    this.children.get(i).enableInternal();
                }
                break block4;
            }
            if (this.children != null) {
                int childrenCount = this.children.size();
                for (int i = 0; i < childrenCount; ++i) {
                    this.children.get(i).enableInternal();
                }
            }
        }
    }

    void enableEffect() {
        this.stopEffectWithoutChildren(EffectEventId.onDisabled);
        this.startEffectWithoutChildren(EffectEventId.onEnabled);
        if (this.id != null) {
            this.nifty.publishEvent(this.id, new ElementEnableEvent(this));
        }
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        this.disableInternal();
    }

    private void disableInternal() {
        block4: {
            block3: {
                --this.enabledCount;
                if (this.enabledCount != -1) break block3;
                this.enabled = false;
                this.disableFocus();
                this.disableEffect();
                if (this.children == null) break block4;
                int childrenCount = this.children.size();
                for (int i = 0; i < childrenCount; ++i) {
                    this.children.get(i).disableInternal();
                }
                break block4;
            }
            if (this.children != null) {
                int childrenCount = this.children.size();
                for (int i = 0; i < childrenCount; ++i) {
                    this.children.get(i).disableInternal();
                }
            }
        }
    }

    public void disableFocus() {
        if (this.focusHandler.getKeyboardFocusElement() == this) {
            Element prevElement = this.focusHandler.getNext(this);
            prevElement.setFocus();
        }
        this.focusHandler.lostKeyboardFocus(this);
        this.focusHandler.lostMouseFocus(this);
        if (this.children != null) {
            int childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                this.children.get(i).disableFocus();
            }
        }
    }

    void disableEffect() {
        this.stopEffectWithoutChildren(EffectEventId.onHover);
        this.stopEffectWithoutChildren(EffectEventId.onStartHover);
        this.stopEffectWithoutChildren(EffectEventId.onEndHover);
        this.stopEffectWithoutChildren(EffectEventId.onEnabled);
        this.startEffectWithoutChildren(EffectEventId.onDisabled);
        if (this.id != null) {
            this.nifty.publishEvent(this.id, new ElementDisableEvent(this));
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void show() {
        this.show(null);
    }

    public void show(@Nullable EndNotify perform) {
        if (this.isEffectActive(EffectEventId.onShow)) {
            return;
        }
        if (this.isEffectActive(EffectEventId.onHide)) {
            this.resetSingleEffect(EffectEventId.onHide);
        }
        this.internalShow();
        this.startEffect(EffectEventId.onShow, perform);
    }

    private void internalShow() {
        this.visible = true;
        this.restoreForShow();
        if (this.id != null) {
            this.nifty.publishEvent(this.id, new ElementShowEvent(this));
        }
    }

    public void setVisible(boolean visibleParam) {
        if (visibleParam) {
            this.show();
        } else {
            this.hide();
        }
    }

    public void hide() {
        this.hide(null);
    }

    public void hide(final @Nullable EndNotify perform) {
        if (!this.isVisible()) {
            return;
        }
        if (this.isEffectActive(EffectEventId.onHide)) {
            return;
        }
        if (this.isEffectActive(EffectEventId.onShow)) {
            this.resetSingleEffect(EffectEventId.onShow);
        }
        this.startEffect(EffectEventId.onHide, new EndNotify(){

            @Override
            public void perform() {
                Element.this.resetForHide();
                Element.this.internalHide();
                if (perform != null) {
                    perform.perform();
                }
            }
        });
    }

    public void showWithoutEffects() {
        this.internalShow();
    }

    public void hideWithoutEffect() {
        if (!this.isVisible()) {
            return;
        }
        this.resetEffects();
        this.internalHide();
    }

    private void internalHide() {
        this.visible = false;
        this.disableFocus();
        if (this.id != null) {
            this.nifty.publishEvent(this.id, new ElementHideEvent(this));
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isVisibleWithParent() {
        if (this.parent == null) {
            return this.visible;
        }
        return this.visible && this.parent.isVisibleWithParent();
    }

    public void setHotSpotFalloff(@Nullable Falloff newFalloff) {
        this.effectManager.setFalloff(newFalloff);
    }

    @Nullable
    public Falloff getFalloff() {
        return this.effectManager.getFalloff();
    }

    public boolean canHandleMouseEvents() {
        if (this.isEffectActive(EffectEventId.onStartScreen)) {
            return false;
        }
        if (this.isEffectActive(EffectEventId.onEndScreen)) {
            return false;
        }
        if (!this.visible) {
            return false;
        }
        if (this.done) {
            return false;
        }
        if (!this.visibleToMouseEvents) {
            return false;
        }
        if (!this.focusHandler.canProcessMouseEvents(this)) {
            return false;
        }
        if (this.interactionBlocked) {
            return false;
        }
        if (!this.enabled) {
            return false;
        }
        return !this.isIgnoreMouseEvents();
    }

    boolean canTheoreticallyHandleMouseEvents() {
        if (!this.visible) {
            return false;
        }
        if (this.done) {
            return false;
        }
        if (!this.visibleToMouseEvents) {
            return false;
        }
        if (!this.focusHandler.canProcessMouseEvents(this)) {
            return false;
        }
        if (!this.enabled) {
            return false;
        }
        return !this.isIgnoreMouseEvents();
    }

    public void buildMouseOverElements(@Nonnull NiftyMouseInputEvent mouseEvent, long eventTime, @Nonnull MouseOverHandler mouseOverHandler) {
        boolean isInside = this.isInside(mouseEvent);
        if (this.canHandleMouseEvents()) {
            if (isInside) {
                mouseOverHandler.addMouseOverElement(this);
            } else {
                mouseOverHandler.addMouseElement(this);
            }
        } else if (this.canTheoreticallyHandleMouseEvents() && isInside) {
            mouseOverHandler.canTheoreticallyHandleMouse(this);
        }
        if (this.visible && this.children != null) {
            int childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                Element w = this.children.get(i);
                w.buildMouseOverElements(mouseEvent, eventTime, mouseOverHandler);
            }
        }
    }

    public void mouseEventHoverPreprocess(@Nonnull NiftyMouseInputEvent mouseEvent, long eventTime) {
        this.effectManager.handleHoverDeactivate(this, mouseEvent.getMouseX(), mouseEvent.getMouseY());
    }

    public boolean mouseEvent(@Nonnull NiftyMouseInputEvent mouseEvent, long eventTime) {
        this.mouseEventHover(mouseEvent);
        return this.interaction.process(mouseEvent, eventTime, this.isInside(mouseEvent), this.canHandleInteraction(), this.focusHandler.hasExclusiveMouseFocus(this));
    }

    private void mouseEventHover(@Nonnull NiftyMouseInputEvent mouseEvent) {
        this.effectManager.handleHover(this, mouseEvent.getMouseX(), mouseEvent.getMouseY());
        this.effectManager.handleHoverStartAndEnd(this, mouseEvent.getMouseX(), mouseEvent.getMouseY());
    }

    public boolean mouseOverEvent(@Nonnull NiftyMouseInputEvent mouseEvent, long eventTime) {
        boolean isMouseEventConsumed = false;
        if (this.interaction.onMouseOver(this, mouseEvent)) {
            isMouseEventConsumed = true;
        }
        if (mouseEvent.getMouseWheel() != 0 && this.interaction.onMouseWheel(this, mouseEvent)) {
            isMouseEventConsumed = true;
        }
        return isMouseEventConsumed;
    }

    private boolean isInside(@Nonnull NiftyMouseInputEvent inputEvent) {
        return this.isMouseInsideElement(inputEvent.getMouseX(), inputEvent.getMouseY());
    }

    public boolean isMouseInsideElement(int mouseX, int mouseY) {
        if (this.parentClipArea) {
            if (this.isInsideParentClipArea(mouseX, mouseY)) {
                return mouseX >= this.getX() && mouseX < this.getX() + this.getWidth() && mouseY >= this.getY() && mouseY < this.getY() + this.getHeight();
            }
            return false;
        }
        return mouseX >= this.getX() && mouseX < this.getX() + this.getWidth() && mouseY >= this.getY() && mouseY < this.getY() + this.getHeight();
    }

    private boolean isInsideParentClipArea(int mouseX, int mouseY) {
        return mouseX >= this.parentClipX && mouseX <= this.parentClipX + this.parentClipWidth && mouseY > this.parentClipY && mouseY < this.parentClipY + this.parentClipHeight;
    }

    @Deprecated
    public void onClick() {
        this.onClickAndReleasePrimaryMouseButton();
    }

    public void onClickAndReleasePrimaryMouseButton() {
        if (!this.canHandleInteraction()) {
            return;
        }
        this.interaction.clickAndReleasePrimaryMouseButton(this.nifty);
    }

    public void onClickAndReleaseSecondaryMouseButton() {
        if (!this.canHandleInteraction()) {
            return;
        }
        this.interaction.clickAndReleaseSecondaryMouseButton(this.nifty);
    }

    public void onClickAndReleaseTertiaryMouseButton() {
        if (!this.canHandleInteraction()) {
            return;
        }
        this.interaction.clickAndReleaseTertiaryMouseButton(this.nifty);
    }

    private boolean canHandleInteraction() {
        if (this.screen == null || !this.enabled) {
            return false;
        }
        return !this.screen.isEffectActive(EffectEventId.onStartScreen) && !this.screen.isEffectActive(EffectEventId.onEndScreen);
    }

    @Nullable
    public Element findElementById(@Nullable String findId) {
        if (findId == null) {
            return null;
        }
        if (this.id != null && this.id.equals(findId)) {
            return this;
        }
        if (this.childIdMatch(findId, this.id)) {
            return this;
        }
        if (this.children != null) {
            int childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                Element e = this.children.get(i);
                Element found = e.findElementById(findId);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    private boolean childIdMatch(@Nonnull String name, @Nullable String id) {
        return name.startsWith("#") && id != null && id.endsWith(name);
    }

    public void setOnClickAlternateKey(String newAlternateKey) {
        this.interaction.setAlternateKey(newAlternateKey);
    }

    public void setAlternateKey(@Nullable String alternateKey) {
        this.effectManager.setAlternateKey(alternateKey);
        if (this.children != null) {
            int childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                Element e = this.children.get(i);
                e.setAlternateKey(alternateKey);
            }
        }
    }

    @Nonnull
    public EffectManager getEffectManager() {
        return this.effectManager;
    }

    public void setEffectManager(@Nonnull EffectManager effectManagerParam) {
        this.effectManager = effectManagerParam;
    }

    private void bindToScreen(@Nonnull Screen newScreen) {
        this.screen = newScreen;
        if (this.id != null) {
            this.screen.registerElementId(this.id);
        }
    }

    private void bindToFocusHandler(boolean isPopup) {
        if (!this.focusable) {
            return;
        }
        if (this.hasAncestorPopup() && !isPopup) {
            return;
        }
        if (this.screen == null) {
            log.severe("Trying to bind element [" + String.valueOf(this.getId()) + "] to focus handler while screen is not bound.");
        } else {
            this.focusHandler.addElement(this, this.screen.findElementById(this.focusableInsertBeforeElementId));
        }
    }

    private boolean hasAncestorPopup() {
        return this.findAncestorPopupElement() != null;
    }

    @Nullable
    private Element findAncestorPopupElement() {
        if (this.elementType instanceof PopupType) {
            return this;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.findAncestorPopupElement();
    }

    public void onStartScreen() {
        this.onStartScreenSubscribeControllerAnnotations();
        this.onStartScreenInternal();
    }

    private void onStartScreenSubscribeControllerAnnotations() {
        if (this.children != null) {
            int childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                Element e = this.children.get(i);
                e.onStartScreenSubscribeControllerAnnotations();
            }
        }
        if (this.attachedInputControl != null) {
            this.nifty.subscribeAnnotations(this.attachedInputControl.getController());
        }
    }

    private void onStartScreenInternal() {
        if (this.children != null) {
            int childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                Element e = this.children.get(i);
                e.onStartScreenInternal();
            }
        }
        if (this.screen == null) {
            log.severe("Internal start of screen called, but no screen is bound to the element [" + String.valueOf(this.getId()) + "]");
        } else if (this.attachedInputControl != null) {
            this.attachedInputControl.onStartScreen(this.nifty, this.screen);
        }
    }

    @Nullable
    public <T extends ElementRenderer> T getRenderer(@Nonnull Class<T> requestedRendererClass) {
        for (int i = 0; i < this.elementRenderer.length; ++i) {
            ElementRenderer renderer = this.elementRenderer[i];
            if (!requestedRendererClass.isInstance(renderer)) continue;
            return (T)((ElementRenderer)requestedRendererClass.cast(renderer));
        }
        return null;
    }

    public void setVisibleToMouseEvents(boolean newVisibleToMouseEvents) {
        this.visibleToMouseEvents = newVisibleToMouseEvents;
    }

    public boolean keyEvent(@Nonnull KeyboardInputEvent inputEvent) {
        if (this.attachedInputControl != null && this.id != null) {
            return this.attachedInputControl.keyEvent(this.nifty, inputEvent, this.id);
        }
        return false;
    }

    public void setClipChildren(boolean clipChildrenParam) {
        this.clipChildren = clipChildrenParam;
    }

    public boolean isClipChildren() {
        return this.clipChildren;
    }

    public void setRenderOrder(int renderOrder) {
        this.renderOrder = renderOrder;
        if (this.parent != null) {
            this.parent.renderOrderChanged(this);
        }
    }

    private void renderOrderChanged(@Nonnull Element element) {
        if (this.elementsRenderOrderSet == null) {
            log.warning("Can't report a changed order, parent doesn't seem to have children?! O.o");
            return;
        }
        Iterator<Element> childItr = this.elementsRenderOrderSet.iterator();
        boolean foundOldEntry = false;
        while (childItr.hasNext()) {
            Element checkElement = childItr.next();
            if (!checkElement.equals(element)) continue;
            childItr.remove();
            foundOldEntry = true;
            break;
        }
        if (foundOldEntry) {
            this.elementsRenderOrderSet.add(element);
            if (this.elementsRenderOrder == null || this.elementsRenderOrder.length != this.elementsRenderOrderSet.size()) {
                this.elementsRenderOrder = new Element[this.elementsRenderOrderSet.size()];
            }
            this.elementsRenderOrder = this.elementsRenderOrderSet.toArray(this.elementsRenderOrder);
        } else {
            log.warning("Failed to locate the element with changed id in the render set.");
        }
    }

    public int getRenderOrder() {
        return this.renderOrder;
    }

    public void setFocus() {
        if (this.nifty.getCurrentScreen() != null && this.isFocusable()) {
            this.focusHandler.setKeyFocus(this);
        }
    }

    public void attachInputControl(NiftyInputControl newInputControl) {
        this.attachedInputControl = newInputControl;
    }

    private boolean hasParentActiveOnStartOrOnEndScreenEffect() {
        if (this.parent != null) {
            return this.parent.effectManager.isActive(EffectEventId.onStartScreen) || this.parent.effectManager.isActive(EffectEventId.onEndScreen) || this.parent.hasParentActiveOnStartOrOnEndScreenEffect();
        }
        return false;
    }

    private void resetInteractionBlocked() {
        this.interactionBlocked = false;
        if (this.children != null) {
            int childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                Element child = this.children.get(i);
                child.resetInteractionBlocked();
            }
        }
    }

    public void setId(@Nullable String id) {
        String oldId = this.id;
        this.id = id;
        if (this.parent == null) {
            return;
        }
        if (oldId == null && id == null) {
            return;
        }
        if (oldId != null && oldId.equals(id) || id != null && id.equals(oldId)) {
            return;
        }
        this.parent.renderOrderChanged(this);
    }

    @Nonnull
    public ElementType getElementType() {
        return this.elementType;
    }

    @Nonnull
    public ElementRenderer[] getElementRenderer() {
        return this.elementRenderer;
    }

    public void setFocusable(boolean isFocusable) {
        this.focusable = isFocusable;
        if (this.children != null) {
            int childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                Element child = this.children.get(i);
                child.setFocusable(isFocusable);
            }
        }
    }

    @Nullable
    public NiftyInputControl getAttachedInputControl() {
        return this.attachedInputControl;
    }

    public void bindControls(@Nonnull Screen target) {
        if (this.screen == target) {
            return;
        }
        this.bindToScreen(target);
        if (this.children != null) {
            int childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                Element child = this.children.get(i);
                child.bindControls(target);
            }
        }
        if (this.attachedInputControl != null) {
            this.attachedInputControl.bindControl(this.nifty, target, this, this.elementType.getAttributes());
        }
    }

    public void initControls(boolean isPopup) {
        if (this.children != null) {
            int childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                Element child = this.children.get(i);
                child.initControls(isPopup);
            }
        }
        if (this.attachedInputControl != null) {
            this.attachedInputControl.initControl(this.elementType.getAttributes());
        }
        this.bindToFocusHandler(isPopup);
    }

    public void removeFromFocusHandler() {
        this.focusHandler.remove(this);
        if (this.children != null) {
            int childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                Element child = this.children.get(i);
                child.removeFromFocusHandler();
            }
        }
    }

    @Nonnull
    public FocusHandler getFocusHandler() {
        return this.focusHandler;
    }

    public void setStyle(@Nonnull String newStyle) {
        String oldStyle = this.getStyle();
        if (oldStyle != null) {
            this.removeStyle(oldStyle);
            this.nifty.getEventService().unsubscribe("style-refresh:" + oldStyle, (EventTopicSubscriber)this.styleListener);
        }
        this.elementType.getAttributes().set("style", newStyle);
        this.elementType.applyStyles(this.nifty.getDefaultStyleResolver());
        if (this.screen == null) {
            log.warning("Can't properly apply style as long as the element is not bound to a screen.");
        } else {
            this.elementType.applyAttributes(this.screen, this, this.elementType.getAttributes(), this.nifty.getRenderEngine());
            this.elementType.applyEffects(this.nifty, this.screen, this);
            this.elementType.applyInteract(this.nifty, this.screen, this);
        }
        this.layoutElements();
        log.fine("after setStyle [" + newStyle + "]\n" + this.elementType.output(0));
        this.publishEvent();
    }

    @Nullable
    public String getStyle() {
        return this.elementType.getAttributes().get("style");
    }

    void removeStyle(@Nonnull String style) {
        log.fine("before removeStyle [" + style + "]\n" + this.elementType.output(0));
        this.elementType.removeWithTag(style);
        this.effectManager.removeAllEffects();
        ImageRenderer renderer = this.getRenderer(ImageRenderer.class);
        if (renderer != null) {
            renderer.setImage(null);
        }
        log.fine("after removeStyle [" + style + "]\n" + this.elementType.output(0));
        this.publishEvent();
    }

    public void addInputHandler(@Nonnull KeyInputHandler handler) {
        if (this.attachedInputControl != null) {
            this.attachedInputControl.addInputHandler(handler);
        }
        if (this.children != null) {
            int childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                Element child = this.children.get(i);
                child.addInputHandler(handler);
            }
        }
    }

    public void addPreInputHandler(@Nonnull KeyInputHandler handler) {
        if (this.attachedInputControl != null) {
            this.attachedInputControl.addPreInputHandler(handler);
        }
        if (this.children != null) {
            int childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                Element child = this.children.get(i);
                child.addPreInputHandler(handler);
            }
        }
    }

    @Nullable
    public <T extends Controller> T findControl(@Nonnull String elementName, @Nonnull Class<T> requestedControlClass) {
        Element element = this.findElementById(elementName);
        if (element == null) {
            return null;
        }
        return element.getControl(requestedControlClass);
    }

    @Nullable
    public <T extends NiftyControl> T findNiftyControl(@Nonnull String elementName, @Nonnull Class<T> requestedControlClass) {
        Element element = this.findElementById(elementName);
        if (element == null) {
            return null;
        }
        return element.getNiftyControl(requestedControlClass);
    }

    @Nullable
    public <T extends Controller> T getControl(@Nonnull Class<T> requestedControlClass) {
        T t;
        if (this.attachedInputControl != null && (t = this.attachedInputControl.getControl(requestedControlClass)) != null) {
            return t;
        }
        if (this.children != null) {
            int childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                Element child = this.children.get(i);
                T t2 = child.getControl(requestedControlClass);
                if (t2 == null) continue;
                return t2;
            }
        }
        return null;
    }

    @Nullable
    public <T extends NiftyControl> T getNiftyControl(@Nonnull Class<T> requestedControlClass) {
        T t;
        if (this.attachedInputControl != null && (t = this.attachedInputControl.getNiftyControl(requestedControlClass)) != null) {
            return t;
        }
        if (this.children != null) {
            int childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                Element child = this.children.get(i);
                T t2 = child.getNiftyControl(requestedControlClass);
                if (t2 == null) continue;
                return t2;
            }
        }
        log.warning("missing element/control with id [" + this.id + "] for requested control class [" + requestedControlClass.getName() + "]");
        return null;
    }

    public boolean isFocusable() {
        return this.focusable && this.enabled && this.visible && this.hasVisibleParent() && !this.isIgnoreKeyboardEvents();
    }

    private boolean hasVisibleParent() {
        if (this.parent != null) {
            return this.parent.visible && this.parent.hasVisibleParent();
        }
        return true;
    }

    public void setOnMouseOverMethod(@Nullable NiftyMethodInvoker onMouseOverMethod) {
        this.interaction.setOnMouseOver(onMouseOverMethod);
    }

    @Nonnull
    public LayoutPart getLayoutPart() {
        return this.layoutPart;
    }

    public boolean isVisibleToMouseEvents() {
        return this.visibleToMouseEvents;
    }

    @Nonnull
    public SizeValue getPaddingLeft() {
        return this.layoutPart.getBoxConstraints().getPaddingLeft();
    }

    @Nonnull
    public SizeValue getPaddingRight() {
        return this.layoutPart.getBoxConstraints().getPaddingRight();
    }

    @Nonnull
    public SizeValue getPaddingTop() {
        return this.layoutPart.getBoxConstraints().getPaddingTop();
    }

    @Nonnull
    public SizeValue getPaddingBottom() {
        return this.layoutPart.getBoxConstraints().getPaddingBottom();
    }

    @Nonnull
    public SizeValue getMarginLeft() {
        return this.layoutPart.getBoxConstraints().getMarginLeft();
    }

    @Nonnull
    public SizeValue getMarginRight() {
        return this.layoutPart.getBoxConstraints().getMarginRight();
    }

    @Nonnull
    public SizeValue getMarginTop() {
        return this.layoutPart.getBoxConstraints().getMarginTop();
    }

    @Nonnull
    public SizeValue getMarginBottom() {
        return this.layoutPart.getBoxConstraints().getMarginBottom();
    }

    public void setPaddingLeft(@Nonnull SizeValue paddingValue) {
        this.layoutPart.getBoxConstraints().setPaddingLeft(paddingValue);
        this.notifyListeners();
    }

    public void setPaddingRight(@Nonnull SizeValue paddingValue) {
        this.layoutPart.getBoxConstraints().setPaddingRight(paddingValue);
        this.notifyListeners();
    }

    public void setPaddingTop(@Nonnull SizeValue paddingValue) {
        this.layoutPart.getBoxConstraints().setPaddingTop(paddingValue);
        this.notifyListeners();
    }

    public void setPaddingBottom(@Nonnull SizeValue paddingValue) {
        this.layoutPart.getBoxConstraints().setPaddingBottom(paddingValue);
        this.notifyListeners();
    }

    public void setMarginLeft(@Nonnull SizeValue value) {
        this.layoutPart.getBoxConstraints().setMarginLeft(value);
        this.notifyListeners();
    }

    public void setMarginRight(@Nonnull SizeValue value) {
        this.layoutPart.getBoxConstraints().setMarginRight(value);
        this.notifyListeners();
    }

    public void setMarginTop(@Nonnull SizeValue value) {
        this.layoutPart.getBoxConstraints().setMarginTop(value);
        this.notifyListeners();
    }

    public void setMarginBottom(@Nonnull SizeValue value) {
        this.layoutPart.getBoxConstraints().setMarginBottom(value);
        this.notifyListeners();
    }

    @Nonnull
    public String toString() {
        return this.id + " (" + super.toString() + ")";
    }

    public boolean isStarted() {
        return this.isEffectActive(EffectEventId.onStartScreen);
    }

    public void markForRemoval() {
        this.markForRemoval(null);
    }

    public void markForRemoval(@Nullable EndNotify endNotify) {
        if (this.screen == null) {
            log.warning("Marking the element [" + String.valueOf(this.getId()) + "] for removal is not possible when there is not screen bound.");
        } else {
            this.nifty.removeElement(this.screen, this, endNotify);
        }
    }

    public void markForMove(@Nonnull Element destination) {
        this.markForMove(destination, null);
    }

    public void markForMove(@Nonnull Element destination, @Nullable EndNotify endNotify) {
        if (this.screen == null) {
            log.warning("Marking the element [" + String.valueOf(this.getId()) + "] for moving is not possible when there is not screen bound.");
        } else {
            this.nifty.moveElement(this.screen, this, destination, endNotify);
        }
    }

    public void reactivate() {
        this.done = false;
        if (this.children != null) {
            int childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                this.children.get(i).reactivate();
            }
        }
    }

    private void notifyListeners() {
        this.constraintsChanged = true;
    }

    private void publishEvent() {
        if (this.id != null) {
            this.nifty.publishEvent(this.id, this);
        }
    }

    @Nonnull
    public Nifty getNifty() {
        return this.nifty;
    }

    @Nullable
    public Screen getScreen() {
        return this.screen;
    }

    @Nonnull
    public <T extends EffectImpl> List<Effect> getEffects(@Nonnull EffectEventId effectEventId, @Nonnull Class<T> requestedClass) {
        return this.effectManager.getEffects(effectEventId, requestedClass);
    }

    public void onEndScreen(@Nonnull Screen screen) {
        if (this.id != null) {
            screen.unregisterElementId(this.id);
            this.nifty.unsubscribeElement(screen, this.id);
        }
        if (this.attachedInputControl != null) {
            this.attachedInputControl.onEndScreen(this.nifty, screen, this.id);
        }
        if (this.children != null) {
            int childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                this.children.get(i).onEndScreen(screen);
            }
        }
    }

    @Nonnull
    public ElementInteraction getElementInteraction() {
        return this.interaction;
    }

    public void setIgnoreMouseEvents(boolean newValue) {
        this.ignoreMouseEvents = newValue;
        if (newValue) {
            this.focusHandler.lostMouseFocus(this);
        }
    }

    public boolean isIgnoreMouseEvents() {
        return this.ignoreMouseEvents;
    }

    public void setIgnoreKeyboardEvents(boolean newValue) {
        this.ignoreKeyboardEvents = newValue;
        if (newValue) {
            this.focusHandler.lostKeyboardFocus(this);
        }
    }

    public boolean isIgnoreKeyboardEvents() {
        return this.ignoreKeyboardEvents;
    }

    @Override
    public void effectStateChanged(@Nonnull EffectEventId eventId, boolean active) {
        boolean oldState = this.effectStateCache.get(eventId);
        boolean newState = this.isEffectActiveRecalc(eventId);
        if (newState != oldState) {
            this.effectStateCache.set(eventId, newState);
            if (this.parent != null) {
                this.parent.effectStateChanged(eventId, newState);
            }
        }
    }

    private boolean isEffectActiveRecalc(@Nonnull EffectEventId eventId) {
        if (this.children != null) {
            int childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                Element w = this.children.get(i);
                if (!w.isEffectActiveRecalc(eventId)) continue;
                return true;
            }
        }
        return this.effectManager.isActive(eventId);
    }

    void internalRemoveElement(@Nonnull Element element) {
        if (this.elementsRenderOrderSet != null && this.children != null) {
            this.elementsRenderOrderSet.remove(element);
            this.children.remove(element);
            if (this.children.isEmpty()) {
                this.elementsRenderOrderSet = null;
                this.children = null;
            } else if (this.children.size() != this.elementsRenderOrderSet.size()) {
                log.severe("Problem at removing a element. RenderOrderSet and children list don't have the same size anymore. Rebuilding the render order set.");
                this.elementsRenderOrderSet.clear();
                this.elementsRenderOrderSet.addAll(this.children);
            }
        }
        this.elementsRenderOrder = this.elementsRenderOrderSet != null ? this.elementsRenderOrderSet.toArray(new Element[this.elementsRenderOrderSet.size()]) : null;
    }

    void internalRemoveElementWithChildren() {
        if (this.children != null) {
            int childrenCount = this.children.size();
            for (int i = 0; i < childrenCount; ++i) {
                this.children.get(i).internalRemoveElementWithChildren();
            }
        }
        this.elementsRenderOrderSet = null;
        this.children = null;
        this.elementsRenderOrder = null;
    }

    public void setUserData(@Nonnull String key, @Nullable Object data) {
        if (data == null) {
            if (this.userData != null) {
                this.userData.remove(key);
                if (this.userData.isEmpty()) {
                    this.userData = null;
                }
            }
        } else {
            if (this.userData == null) {
                this.userData = new HashMap<String, Object>();
            }
            this.userData.put(key, data);
        }
    }

    @Nullable
    public <T> T getUserData(@Nonnull String key) {
        if (this.userData == null) {
            return null;
        }
        return (T)this.userData.get(key);
    }

    @Nonnull
    public Set<String> getUserDataKeys() {
        if (this.userData != null) {
            return this.userData.keySet();
        }
        return Collections.emptySet();
    }

    @Nonnull
    private static <T> Iterator<T> emptyIterator() {
        return EmptyIterator.EMPTY_ITERATOR;
    }

    static {
        rendererApplier.put(TextRenderer.class, new ApplyRenderText(convert));
        rendererApplier.put(ImageRenderer.class, new ApplyRendererImage(convert));
        rendererApplier.put(PanelRenderer.class, new ApplyRendererPanel(convert));
    }

    private static class EmptyIterator<E>
    implements Iterator<E> {
        static final EmptyIterator<Object> EMPTY_ITERATOR = new EmptyIterator();

        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        @Nonnull
        public E next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }

    private static final class RenderOrderComparator
    implements Comparator<Element> {
        private RenderOrderComparator() {
        }

        @Override
        public int compare(@Nonnull Element o1, @Nonnull Element o2) {
            int idCompareResult;
            int o2RenderOrder;
            if (o1 == o2) {
                return 0;
            }
            int o1RenderOrder = this.getRenderOrder(o1);
            if (o1RenderOrder < (o2RenderOrder = this.getRenderOrder(o2))) {
                return -1;
            }
            if (o1RenderOrder > o2RenderOrder) {
                return 1;
            }
            String o1Id = o1.id;
            String o2Id = o2.id;
            if (o1Id == null && o2Id != null) {
                return -1;
            }
            if (o1Id != null && o2Id == null) {
                return 1;
            }
            if (o1Id != null && (idCompareResult = o1Id.compareTo(o2Id)) != 0) {
                return idCompareResult;
            }
            return Integer.valueOf(o1.hashCode()).compareTo(o2.hashCode());
        }

        private int getRenderOrder(@Nonnull Element element) {
            if (element.renderOrder != 0) {
                return element.renderOrder;
            }
            return element.getParent().getChildren().indexOf(element);
        }
    }

    public class LocalEndNotify
    implements EndNotify {
        @Nonnull
        private final EffectEventId effectEventId;
        @Nullable
        private final EndNotify effectEndNotify;

        public LocalEndNotify(@Nullable EffectEventId effectEventIdParam, EndNotify effectEndNotifyParam) {
            this.effectEventId = effectEventIdParam;
            this.effectEndNotify = effectEndNotifyParam;
        }

        @Override
        public void perform() {
            if ((this.effectEventId.equals((Object)EffectEventId.onStartScreen) || this.effectEventId.equals((Object)EffectEventId.onEndScreen)) && Element.this.interactionBlocked && !Element.this.hasParentActiveOnStartOrOnEndScreenEffect() && !Element.this.isEffectActive(this.effectEventId)) {
                Element.this.resetInteractionBlocked();
            }
            if (!Element.this.isEffectActive(this.effectEventId) && this.effectEndNotify != null) {
                this.effectEndNotify.perform();
            }
        }
    }

    private class StyleRefresh
    implements EventTopicSubscriber {
        private StyleRefresh() {
        }

        public void onEvent(String string, Object style) {
            log.fine("Rereshing style of " + Element.this.getId());
            String styleid = style.toString();
            String simplyStyle = styleid.split("#")[0];
            Element.this.setStyle(simplyStyle);
        }
    }
}

