/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects.impl;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.spi.sound.SoundHandle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PlayMusic
implements EffectImpl {
    private boolean done;
    private boolean repeat;
    @Nullable
    private SoundHandle musicHandle;
    @Nullable
    private Nifty nifty;

    @Override
    public void activate(@Nonnull Nifty nifty, @Nonnull Element element, @Nonnull EffectProperties parameter) {
        this.nifty = nifty;
        this.musicHandle = nifty.getSoundSystem().getMusic(parameter.getProperty("music"));
        this.repeat = Boolean.valueOf(parameter.getProperty("repeat", "false"));
        this.done = false;
    }

    @Override
    public void execute(@Nonnull Element element, float normalizedTime, @Nullable Falloff falloff, @Nonnull NiftyRenderEngine r) {
        if (normalizedTime > 0.0f && this.musicHandle != null) {
            if (!this.done) {
                this.playMusic();
                this.done = true;
            } else if (this.repeat && !this.musicHandle.isPlaying()) {
                this.playMusic();
            }
        }
    }

    private void playMusic() {
        if (this.musicHandle != null && this.nifty != null) {
            this.musicHandle.setVolume(this.nifty.getSoundSystem().getMusicVolume());
            this.musicHandle.play();
        }
    }

    @Override
    public void deactivate() {
    }
}

