/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects.impl;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.TargetElementResolver;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Move
implements EffectImpl {
    private static final Logger log = Logger.getLogger(Move.class.getName());
    private static final String LEFT = "left";
    private static final String RIGHT = "right";
    private static final String TOP = "top";
    private static final String BOTTOM = "bottom";
    private String direction;
    private long offset = 0L;
    private long startOffset = 0L;
    private int offsetDir = 0;
    private float offsetY;
    private float startOffsetY;
    private int startOffsetX;
    private float offsetX;
    private boolean withTarget = false;
    private boolean fromOffset = false;
    private boolean toOffset = false;

    @Override
    public void activate(@Nonnull Nifty nifty, @Nonnull Element element, @Nonnull EffectProperties parameter) {
        String mode = parameter.getProperty("mode");
        this.direction = parameter.getProperty("direction");
        this.offset = LEFT.equals(this.direction) ? (long)(element.getX() + element.getWidth()) : (RIGHT.equals(this.direction) ? (long)(nifty.getRenderEngine().getWidth() - element.getX()) : (TOP.equals(this.direction) ? (long)(element.getY() + element.getHeight()) : (BOTTOM.equals(this.direction) ? (long)(nifty.getRenderEngine().getHeight() - element.getY()) : 0L)));
        if ("out".equals(mode)) {
            this.startOffset = 0L;
            this.offsetDir = -1;
            this.withTarget = false;
        } else if ("in".equals(mode)) {
            this.startOffset = this.offset;
            this.offsetDir = 1;
            this.withTarget = false;
        } else if ("fromPosition".equals(mode)) {
            this.withTarget = true;
        } else if ("toPosition".equals(mode)) {
            this.withTarget = true;
        } else if ("fromOffset".equals(mode)) {
            this.fromOffset = true;
            this.startOffsetX = Integer.valueOf(parameter.getProperty("offsetX", "0"));
            this.startOffsetY = Integer.valueOf(parameter.getProperty("offsetY", "0")).intValue();
            this.offsetX = this.startOffsetX * -1;
            this.offsetY = this.startOffsetY * -1.0f;
        } else if ("toOffset".equals(mode)) {
            this.toOffset = true;
            this.startOffsetX = 0;
            this.startOffsetY = 0.0f;
            this.offsetX = Integer.valueOf(parameter.getProperty("offsetX", "0")).intValue();
            this.offsetY = Integer.valueOf(parameter.getProperty("offsetY", "0")).intValue();
        }
        String target = parameter.getProperty("targetElement");
        Screen screen = nifty.getCurrentScreen();
        if (target != null && screen != null) {
            TargetElementResolver resolver = new TargetElementResolver(screen, element);
            Element targetElement = resolver.resolve(target);
            if (targetElement == null) {
                log.warning("move effect for element [" + element.getId() + "] was unable to find target element [" + target + "] at screen [" + screen.getScreenId() + "]");
                return;
            }
            if ("fromPosition".equals(mode)) {
                this.startOffsetX = targetElement.getX() - element.getX();
                this.startOffsetY = targetElement.getY() - element.getY();
                this.offsetX = -(targetElement.getX() - element.getX());
                this.offsetY = -(targetElement.getY() - element.getY());
            } else if ("toPosition".equals(mode)) {
                this.startOffsetX = 0;
                this.startOffsetY = 0.0f;
                this.offsetX = targetElement.getX() - element.getX();
                this.offsetY = targetElement.getY() - element.getY();
            }
        }
    }

    @Override
    public void execute(@Nonnull Element element, float normalizedTime, @Nullable Falloff falloff, @Nonnull NiftyRenderEngine r) {
        if (this.fromOffset || this.toOffset) {
            float moveToX = (float)this.startOffsetX + normalizedTime * this.offsetX;
            float moveToY = this.startOffsetY + normalizedTime * this.offsetY;
            r.moveTo(moveToX, moveToY);
        } else if (this.withTarget) {
            float moveToX = (float)this.startOffsetX + normalizedTime * this.offsetX;
            float moveToY = this.startOffsetY + normalizedTime * this.offsetY;
            r.moveTo(moveToX, moveToY);
        } else if (LEFT.equals(this.direction)) {
            r.moveTo((float)(-this.startOffset) + (float)this.offsetDir * normalizedTime * (float)this.offset, 0.0f);
        } else if (RIGHT.equals(this.direction)) {
            r.moveTo((float)this.startOffset - (float)this.offsetDir * normalizedTime * (float)this.offset, 0.0f);
        } else if (TOP.equals(this.direction)) {
            r.moveTo(0.0f, (float)(-this.startOffset) + (float)this.offsetDir * normalizedTime * (float)this.offset);
        } else if (BOTTOM.equals(this.direction)) {
            r.moveTo(0.0f, (float)this.startOffset - (float)this.offsetDir * normalizedTime * (float)this.offset);
        }
    }

    @Override
    public void deactivate() {
    }
}

