/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects.impl;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.tools.LinearInterpolator;
import de.lessvoid.nifty.tools.SizeValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ImageSize
implements EffectImpl {
    private float startSize;
    private float endSize;
    @Nonnull
    private SizeValue imageSize = new SizeValue("100%");
    @Nullable
    private LinearInterpolator interpolator;

    @Override
    public final void activate(@Nonnull Nifty nifty, @Nonnull Element element, @Nonnull EffectProperties parameter) {
        this.startSize = Float.parseFloat(parameter.getProperty("startSize", "1.0"));
        this.endSize = Float.parseFloat(parameter.getProperty("endSize", "2.0"));
        String maxSizeString = parameter.getProperty("maxSize");
        if (maxSizeString != null) {
            this.imageSize = new SizeValue(maxSizeString);
        }
        this.interpolator = parameter.getInterpolator();
    }

    @Override
    public void execute(@Nonnull Element element, float normalizedTime, @Nullable Falloff falloff, @Nonnull NiftyRenderEngine r) {
        float scale = falloff == null ? (this.interpolator != null ? this.interpolator.getValue(normalizedTime) : this.startSize + normalizedTime * (this.endSize - this.startSize)) : 1.0f + falloff.getFalloffValue() * this.imageSize.getValue(1.0f);
        r.setImageScale(scale);
    }

    @Override
    public void deactivate() {
    }
}

