/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects.impl;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.tools.Color;
import de.lessvoid.nifty.tools.pulsate.Pulsator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ColorPulsate
implements EffectImpl {
    private Color startColor;
    private Color endColor;
    private Pulsator pulsator;
    @Nonnull
    private final Color currentColor = new Color("#000f");

    @Override
    public void activate(@Nonnull Nifty nifty, @Nonnull Element element, @Nonnull EffectProperties parameter) {
        this.startColor = new Color(parameter.getProperty("startColor", "#00000000"));
        this.endColor = new Color(parameter.getProperty("endColor", "#ffffffff"));
        this.pulsator = new Pulsator(parameter, nifty.getTimeProvider());
    }

    @Override
    public void execute(@Nonnull Element element, float normalizedTime, @Nullable Falloff falloff, @Nonnull NiftyRenderEngine r) {
        float value = this.pulsator.update();
        this.currentColor.linear(this.startColor, this.endColor, value);
        r.setColor(this.currentColor);
    }

    @Override
    public void deactivate() {
    }
}

