/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.effects.Effect;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProcessor;
import de.lessvoid.nifty.effects.EffectProcessorImpl;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.spi.time.TimeProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EffectManager {
    private static final EffectEventId[] effectsRenderOrder = new EffectEventId[]{EffectEventId.onShow, EffectEventId.onHide, EffectEventId.onStartScreen, EffectEventId.onEndScreen, EffectEventId.onCustom, EffectEventId.onActive, EffectEventId.onHover, EffectEventId.onStartHover, EffectEventId.onEndHover, EffectEventId.onFocus, EffectEventId.onLostFocus, EffectEventId.onGetFocus, EffectEventId.onClick, EffectEventId.onEnabled, EffectEventId.onDisabled};
    private static final EffectEventId[] effectsHideShowOrder = new EffectEventId[]{EffectEventId.onStartScreen, EffectEventId.onEndScreen, EffectEventId.onShow, EffectEventId.onHide, EffectEventId.onCustom, EffectEventId.onHover, EffectEventId.onStartHover, EffectEventId.onEndHover, EffectEventId.onFocus, EffectEventId.onLostFocus, EffectEventId.onGetFocus, EffectEventId.onClick};
    @Nonnull
    private final Map<EffectEventId, EffectProcessor> effectProcessor = new EnumMap<EffectEventId, EffectProcessor>(EffectEventId.class);
    @Nonnull
    private final List<EffectProcessor> effectProcessorList = new ArrayList<EffectProcessor>(0);
    @Nullable
    private Falloff hoverFalloff;
    @Nullable
    private String alternateKey = null;
    private boolean isEmpty = true;
    @Nonnull
    private final Notify notify;
    @Nonnull
    private static final RenderPhase renderPhasePre = new RenderPhasePre();
    @Nonnull
    private static final RenderPhase renderPhasePost = new RenderPhasePost();
    @Nonnull
    private static final RenderPhase renderPhaseOverlay = new RenderPhaseOverlay();

    public EffectManager(@Nonnull Notify notify) {
        this.notify = notify;
    }

    public void registerEffect(@Nonnull EffectEventId id, @Nonnull Effect e) {
        EffectProcessor processor = this.effectProcessor.get((Object)id);
        if (processor == null) {
            processor = id.createEffectProcessor(new NotifyAdapter(id, this.notify));
            this.effectProcessor.put(id, processor);
            this.effectProcessorList.add(processor);
        }
        processor.registerEffect(e);
        this.isEmpty = false;
    }

    public void startEffect(@Nonnull EffectEventId id, @Nonnull Element w, @Nonnull TimeProvider time, @Nullable EndNotify listener) {
        this.startEffect(id, w, time, listener, null);
    }

    public void startEffect(@Nonnull EffectEventId id, @Nonnull Element w, @Nonnull TimeProvider time, @Nullable EndNotify listener, @Nullable String customKey) {
        this.stopEffect(id);
        EffectProcessor processor = this.getEffectProcessor(id);
        if (processor != null) {
            processor.activate(listener, this.alternateKey, customKey);
        }
    }

    public void stopEffect(@Nonnull EffectEventId effectId) {
        EffectProcessor processor = this.getEffectProcessor(effectId);
        if (processor != null) {
            processor.setActive(false);
        }
    }

    public void renderPre(@Nonnull NiftyRenderEngine renderEngine, Element element) {
        this.renderInternal(renderEngine, renderPhasePre);
    }

    public void renderPost(@Nonnull NiftyRenderEngine renderEngine, Element element) {
        this.renderInternal(renderEngine, renderPhasePost);
    }

    public void renderOverlay(@Nonnull NiftyRenderEngine renderEngine, Element element) {
        this.renderInternal(renderEngine, renderPhaseOverlay);
    }

    private void renderInternal(@Nonnull NiftyRenderEngine renderEngine, @Nonnull RenderPhase phase) {
        for (int i = 0; i < effectsRenderOrder.length; ++i) {
            EffectProcessor processor = this.getEffectProcessor(effectsRenderOrder[i]);
            if (processor == null) continue;
            phase.render(processor, renderEngine);
        }
    }

    public void handleHover(Element element, int x, int y) {
        EffectProcessor processor = this.getEffectProcessor(EffectEventId.onHover);
        if (processor != null) {
            processor.processHover(x, y);
        }
    }

    public void handleHoverStartAndEnd(Element element, int x, int y) {
        EffectProcessor processor = this.getEffectProcessor(EffectEventId.onStartHover);
        if (processor != null) {
            processor.processStartHover(x, y);
        }
        if ((processor = this.getEffectProcessor(EffectEventId.onEndHover)) != null) {
            processor.processEndHover(x, y);
        }
    }

    public void handleHoverDeactivate(Element element, int x, int y) {
        EffectProcessor processor = this.getEffectProcessor(EffectEventId.onHover);
        if (processor != null) {
            processor.processHoverDeactivate(x, y);
        }
    }

    public final boolean isActive(@Nonnull EffectEventId effectEventId) {
        EffectProcessor processor = this.getEffectProcessor(effectEventId);
        if (processor == null) {
            return false;
        }
        return processor.isActive();
    }

    public void reset() {
        this.resetSingleEffect(EffectEventId.onStartScreen);
        this.resetSingleEffect(EffectEventId.onEndScreen);
        this.resetSingleEffect(EffectEventId.onShow);
        this.resetSingleEffect(EffectEventId.onHide);
    }

    public void resetAll() {
        for (int i = 0; i < effectsHideShowOrder.length; ++i) {
            this.resetSingleEffect(effectsHideShowOrder[i]);
        }
    }

    public void resetForHide() {
        for (int i = 0; i < effectsHideShowOrder.length; ++i) {
            EffectProcessor processor = this.getEffectProcessor(effectsHideShowOrder[i]);
            if (processor == null) continue;
            processor.saveActiveNeverStopRenderingEffects();
        }
    }

    public void restoreForShow() {
        for (int i = 0; i < effectsHideShowOrder.length; ++i) {
            EffectProcessor processor = this.getEffectProcessor(effectsHideShowOrder[i]);
            if (processor == null) continue;
            processor.restoreNeverStopRenderingEffects();
        }
    }

    public void resetSingleEffect(@Nonnull EffectEventId effectEventId) {
        EffectProcessor processor = this.getEffectProcessor(effectEventId);
        if (processor != null) {
            processor.reset();
        }
    }

    public void resetSingleEffect(@Nonnull EffectEventId effectEventId, @Nonnull String customKey) {
        EffectProcessor processor = this.getEffectProcessor(effectEventId);
        if (processor != null) {
            processor.reset(customKey);
        }
    }

    public void setAlternateKey(@Nullable String newAlternateKey) {
        this.alternateKey = newAlternateKey;
    }

    @Nonnull
    public String getStateString(String offset) {
        StringBuilder data = new StringBuilder();
        int activeProcessors = 0;
        for (EffectEventId eventId : this.effectProcessor.keySet()) {
            EffectProcessor processor = this.getEffectProcessor(eventId);
            if (processor == null || !processor.isActive()) continue;
            ++activeProcessors;
            data.append(offset);
            data.append("  {").append(eventId.toString()).append("} ");
            data.append(processor.getStateString());
        }
        if (activeProcessors == 0) {
            return offset + "{}";
        }
        return data.toString();
    }

    public void setFalloff(Falloff newFalloff) {
        this.hoverFalloff = newFalloff;
    }

    @Nullable
    public Falloff getFalloff() {
        return this.hoverFalloff;
    }

    public void removeAllEffects() {
        for (int i = 0; i < this.effectProcessorList.size(); ++i) {
            this.effectProcessorList.get(i).removeAllEffects();
        }
        this.isEmpty = true;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Nonnull
    public <T extends EffectImpl> List<Effect> getEffects(@Nonnull EffectEventId effectEventId, @Nonnull Class<T> requestedClass) {
        EffectProcessor processor = this.getEffectProcessor(effectEventId);
        if (processor == null) {
            return Collections.emptyList();
        }
        return processor.getEffects(requestedClass);
    }

    @Nullable
    private EffectProcessor getEffectProcessor(@Nonnull EffectEventId id) {
        EffectProcessor processor = this.effectProcessor.get((Object)id);
        if (processor == null) {
            return null;
        }
        return processor;
    }

    private static class NotifyAdapter
    implements EffectProcessorImpl.Notify {
        @Nonnull
        private final Notify notify;
        @Nonnull
        private final EffectEventId eventId;

        public NotifyAdapter(@Nonnull EffectEventId eventId, @Nonnull Notify notify) {
            this.eventId = eventId;
            this.notify = notify;
        }

        @Override
        public void effectProcessorStateChanged(boolean active) {
            this.notify.effectStateChanged(this.eventId, active);
        }
    }

    public static interface Notify {
        public void effectStateChanged(@Nonnull EffectEventId var1, boolean var2);
    }

    private static final class RenderPhaseOverlay
    implements RenderPhase {
        private RenderPhaseOverlay() {
        }

        @Override
        public void render(@Nonnull EffectProcessor processor, @Nonnull NiftyRenderEngine renderEngine) {
            processor.renderOverlay(renderEngine);
        }
    }

    private static final class RenderPhasePost
    implements RenderPhase {
        private RenderPhasePost() {
        }

        @Override
        public void render(@Nonnull EffectProcessor processor, @Nonnull NiftyRenderEngine renderEngine) {
            processor.renderPost(renderEngine);
        }
    }

    private static final class RenderPhasePre
    implements RenderPhase {
        private RenderPhasePre() {
        }

        @Override
        public void render(@Nonnull EffectProcessor processor, @Nonnull NiftyRenderEngine renderEngine) {
            processor.renderPre(renderEngine);
        }
    }

    static interface RenderPhase {
        public void render(@Nonnull EffectProcessor var1, @Nonnull NiftyRenderEngine var2);
    }
}

