/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.effects.EffectEvents;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.spi.time.TimeProvider;
import de.lessvoid.nifty.tools.time.TimeInterpolator;
import java.util.Collection;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Effect {
    @Nonnull
    private static final Logger log = Logger.getLogger(Effect.class.getName());
    @Nonnull
    private final EffectEventId effectEventId;
    private boolean active;
    @Nonnull
    private final Element element;
    @Nonnull
    private final TimeInterpolator timeInterpolator;
    @Nonnull
    private final EffectImpl effectImpl;
    @Nonnull
    private final EffectProperties parameter;
    @Nonnull
    private final Object[] controllerArray;
    private final boolean post;
    private final boolean overlay;
    @Nullable
    private final String alternateEnable;
    @Nullable
    private final String alternateDisable;
    @Nullable
    private String alternate;
    @Nullable
    private final String customKey;
    private final boolean inherit;
    @Nonnull
    private final Nifty nifty;
    private boolean hoverEffect;
    private boolean infiniteEffect;
    @Nullable
    private Falloff falloff;
    @Nonnull
    private final EffectEvents effectEvents;
    private final boolean neverStopRendering;
    private boolean customFlag;

    public Effect(@Nonnull Nifty nifty, boolean inherit, boolean post, boolean overlay, @Nullable String alternateEnable, @Nullable String alternateDisable, @Nullable String customKey, boolean neverStopRendering, @Nonnull EffectEventId effectEventId, @Nonnull Element element, @Nonnull EffectImpl effectImpl, @Nonnull EffectProperties parameter, @Nonnull TimeProvider timeProvider, @Nonnull Collection<Object> controllers) {
        this.nifty = nifty;
        this.inherit = inherit;
        this.post = post;
        this.overlay = overlay;
        this.active = false;
        this.alternateEnable = alternateEnable;
        this.alternateDisable = alternateDisable;
        this.alternate = null;
        this.customKey = customKey;
        this.effectEventId = effectEventId;
        this.hoverEffect = false;
        this.infiniteEffect = false;
        this.neverStopRendering = neverStopRendering;
        this.effectEvents = new EffectEvents();
        this.customFlag = false;
        this.element = element;
        this.effectImpl = effectImpl;
        this.parameter = parameter;
        parameter.put("effectEventId", (Object)effectEventId);
        this.timeInterpolator = new TimeInterpolator(parameter, timeProvider, this.infiniteEffect);
        this.controllerArray = controllers.toArray();
        this.effectEvents.init(nifty, this.controllerArray, parameter);
        this.customFlag = false;
    }

    public void enableHover(Falloff falloffParameter) {
        this.hoverEffect = true;
        this.falloff = falloffParameter;
        this.element.setVisibleToMouseEvents(true);
    }

    public void disableHover() {
        this.hoverEffect = false;
        this.falloff = null;
    }

    public void disableInfinite() {
        this.setInfiniteEffect(false);
    }

    public void enableInfinite() {
        this.setInfiniteEffect(true);
    }

    public void setInfiniteEffect(boolean infinite) {
        if (infinite != this.infiniteEffect) {
            this.infiniteEffect = infinite;
            this.timeInterpolator.initialize(this.parameter, infinite);
        }
    }

    public void updateParameters() {
        this.timeInterpolator.initialize(this.parameter, this.infiniteEffect);
        this.effectEvents.init(this.nifty, this.controllerArray, this.parameter);
    }

    public boolean start(@Nullable String alternate, @Nullable String customKey) {
        this.alternate = alternate;
        if (!this.canStartEffect(alternate, customKey)) {
            return false;
        }
        log.fine("starting effect [" + this.getStateString() + "] with customKey [" + customKey + "]");
        this.internalStart();
        return true;
    }

    private void internalStart() {
        this.active = true;
        this.timeInterpolator.start();
        this.effectEvents.onStartEffect(this.parameter);
        this.effectImpl.activate(this.nifty, this.element, this.parameter);
    }

    public void update() {
        this.setActiveInternal(this.timeInterpolator.update(), !this.neverStopRendering);
    }

    public void execute(@Nonnull NiftyRenderEngine r) {
        if (this.isHoverEffect()) {
            this.effectImpl.execute(this.element, this.timeInterpolator.getValue(), this.falloff, r);
        } else {
            this.effectImpl.execute(this.element, this.timeInterpolator.getValue(), null, r);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void deactivate() {
        this.setActiveInternal(false, true);
    }

    private void setActiveInternal(boolean newActive, boolean callDeactivate) {
        boolean ended = false;
        if (this.active && !newActive) {
            if (callDeactivate) {
                this.effectImpl.deactivate();
            }
            ended = true;
        }
        this.active = newActive;
        if (ended) {
            this.effectEvents.onEndEffect();
        }
    }

    public boolean isPost() {
        return this.post;
    }

    public boolean isAlternateDisable() {
        return this.alternateDisable != null;
    }

    public boolean customKeyMatches(@Nullable String customKeyToCheck) {
        if (customKeyToCheck == null) {
            return this.customKey == null;
        }
        return customKeyToCheck.equals(this.customKey);
    }

    @Nonnull
    public String getStateString() {
        return "(" + this.effectImpl.getClass().getSimpleName() + "[" + this.customKey + "])";
    }

    @Nullable
    public <T extends EffectImpl> T getEffectImpl(@Nonnull Class<T> requestedClass) {
        if (requestedClass.isInstance(this.effectImpl)) {
            return (T)((EffectImpl)requestedClass.cast(this.effectImpl));
        }
        return null;
    }

    public boolean isInherit() {
        return this.inherit;
    }

    public boolean isHoverEffect() {
        return this.hoverEffect;
    }

    public void hoverDistance(int x, int y) {
        if (this.falloff != null) {
            this.falloff.updateFalloffValue(this.element, x, y);
        }
    }

    public boolean isInsideFalloff(int x, int y) {
        if (this.falloff != null && this.falloff.getFalloffConstraint() != Falloff.HoverFalloffConstraint.none) {
            return this.falloff.isInside(this.element, x, y);
        }
        return this.element.isMouseInsideElement(x, y);
    }

    public boolean isOverlay() {
        return this.overlay;
    }

    public boolean isNeverStopRendering() {
        return this.neverStopRendering;
    }

    @Nonnull
    public EffectProperties getParameters() {
        return this.parameter;
    }

    @Nullable
    public String getAlternate() {
        return this.alternate;
    }

    @Nullable
    public String getCustomKey() {
        return this.customKey;
    }

    private boolean canStartEffect(@Nullable String alternate, @Nullable String customKey) {
        if (alternate == null) {
            if (this.isAlternateEnable()) {
                log.fine("starting effect [" + this.getStateString() + "] canceled because alternateKey [NULL] and effect isAlternateEnable()");
                return false;
            }
        } else {
            if (this.isAlternateDisable() && this.alternateDisableMatches(alternate)) {
                log.fine("starting effect [" + this.getStateString() + "] canceled because alternateKey [" + alternate + "] matches alternateDisableMatches()");
                return false;
            }
            if (this.isAlternateEnable() && !this.alternateEnableMatches(alternate)) {
                log.fine("starting effect [" + this.getStateString() + "] canceled because alternateKey [" + alternate + "] does not match alternateEnableMatches()");
                return false;
            }
        }
        if (!this.customKeyMatches(customKey)) {
            log.fine("starting effect [" + this.getStateString() + "] canceled because customKey [" + customKey + "] does not match key set at the effect");
            return false;
        }
        return true;
    }

    private boolean isAlternateEnable() {
        return this.alternateEnable != null;
    }

    private boolean alternateEnableMatches(@Nullable String alternate) {
        return alternate != null && alternate.equals(this.alternateEnable);
    }

    private boolean alternateDisableMatches(@Nullable String alternate) {
        return alternate != null && alternate.equals(this.alternateDisable);
    }

    public boolean getCustomFlag() {
        return this.customFlag;
    }

    public void setCustomFlag(boolean customFlag) {
        this.customFlag = customFlag;
    }

    @Nonnull
    public EffectEventId getEffectEventId() {
        return this.effectEventId;
    }
}

