/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls;

import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.keyboard.KeyboardInputEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FocusHandler {
    private static final Logger log = Logger.getLogger(FocusHandler.class.getName());
    @Nonnull
    private final ArrayList<Element> entries = new ArrayList();
    @Nonnull
    private final ArrayList<ArrayList<Element>> elementBuffer = new ArrayList();
    @Nullable
    private Element mouseFocusElement = null;
    @Nonnull
    private final ArrayList<Element> mouseFocusElementBuffer = new ArrayList();
    @Nullable
    private Element keyboardFocusElement = null;
    @Nonnull
    private final ArrayList<Element> keyboardFocusElementBuffer = new ArrayList();

    public void addElement(Element element) {
        this.addElement(element, null);
    }

    public void addElement(Element element, @Nullable Element focusableInsertBeforeElement) {
        if (focusableInsertBeforeElement == null) {
            this.entries.add(element);
        } else {
            int idx = this.entries.indexOf(focusableInsertBeforeElement);
            if (idx == -1) {
                log.warning("requesting to add focusable element before [" + focusableInsertBeforeElement + "] but I can't find it on the current screen. Adding it to the end of the list (like in the regular case)");
                this.entries.add(element);
            } else {
                this.entries.add(idx, focusableInsertBeforeElement);
            }
        }
    }

    public void addElementAfter(Element existingElement, Element element) {
        int idx = this.entries.indexOf(existingElement);
        if (idx == -1) {
            log.warning("requesting to add focusable element after [" + existingElement + "] but I can't find it on the current screen. Adding it to the end of the list (like in the regular case)");
            this.entries.add(element);
        } else if (idx == this.entries.size() - 1) {
            this.entries.add(element);
        } else {
            this.entries.add(idx + 1, element);
        }
    }

    @Nonnull
    public Element getNext(@Nonnull Element current) {
        Element nextElement;
        if (this.entries.isEmpty()) {
            return current;
        }
        int index = this.entries.indexOf(this.keyboardFocusElement);
        if (index == -1) {
            return current;
        }
        do {
            if (++index >= this.entries.size()) {
                index = 0;
            }
            if ((nextElement = this.entries.get(index)) != current) continue;
            return current;
        } while (!nextElement.isFocusable());
        return nextElement;
    }

    public Element getPrev(Element current) {
        Element prevElement;
        if (this.entries.isEmpty()) {
            return current;
        }
        int index = this.entries.indexOf(this.keyboardFocusElement);
        if (index == -1) {
            return current;
        }
        do {
            if (--index < 0) {
                index = this.entries.size() - 1;
            }
            if ((prevElement = this.entries.get(index)) != current) continue;
            return current;
        } while (!prevElement.isFocusable());
        return prevElement;
    }

    public void remove(Element element) {
        this.entries.remove(element);
        this.lostKeyboardFocus(element);
        this.lostMouseFocus(element);
    }

    @Nullable
    public Element getFirstFocusElement() {
        if (this.entries.isEmpty()) {
            return null;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            if (!this.entries.get(i).isFocusable()) continue;
            return this.entries.get(i);
        }
        return null;
    }

    public void pushState() {
        ArrayList<Element> copy = new ArrayList<Element>();
        copy.addAll(this.entries);
        this.elementBuffer.add(copy);
        this.entries.clear();
        this.keyboardFocusElementBuffer.add(this.keyboardFocusElement);
        this.lostKeyboardFocus(this.keyboardFocusElement);
        this.mouseFocusElementBuffer.add(this.mouseFocusElement);
        this.lostMouseFocus(this.mouseFocusElement);
    }

    public void popState() {
        this.entries.clear();
        this.entries.addAll((Collection<Element>)this.elementBuffer.get(this.elementBuffer.size() - 1));
        this.setKeyFocus(this.keyboardFocusElementBuffer.remove(this.keyboardFocusElementBuffer.size() - 1));
        this.mouseFocusElement = this.mouseFocusElementBuffer.remove(this.mouseFocusElementBuffer.size() - 1);
        this.mouseFocusElement = null;
    }

    public void resetFocusElements() {
        this.entries.clear();
        this.lostKeyboardFocus(this.keyboardFocusElement);
        this.lostMouseFocus(this.mouseFocusElement);
    }

    public void setKeyFocus(Element newFocusElement) {
        if (this.keyboardFocusElement == newFocusElement) {
            return;
        }
        if (this.keyboardFocusElement != null) {
            this.keyboardFocusElement.stopEffect(EffectEventId.onFocus);
            this.keyboardFocusElement.startEffect(EffectEventId.onLostFocus);
        }
        boolean startOnGetFocus = false;
        if (this.keyboardFocusElement != newFocusElement) {
            startOnGetFocus = true;
        }
        this.keyboardFocusElement = newFocusElement;
        log.fine("keyboard focus element now changed to [" + (this.keyboardFocusElement == null ? "" : this.keyboardFocusElement.toString()) + "]");
        if (this.keyboardFocusElement != null) {
            this.keyboardFocusElement.startEffect(EffectEventId.onFocus);
            if (startOnGetFocus) {
                this.keyboardFocusElement.startEffect(EffectEventId.onGetFocus);
            }
        }
    }

    public void lostKeyboardFocus(@Nullable Element elementThatLostFocus) {
        if (elementThatLostFocus != null) {
            log.fine("lostKeyboardFocus for [" + elementThatLostFocus.toString() + "]");
            if (this.keyboardFocusElement == elementThatLostFocus) {
                this.keyboardFocusElement.stopEffect(EffectEventId.onFocus);
                this.keyboardFocusElement.startEffect(EffectEventId.onLostFocus);
                this.keyboardFocusElement = null;
            }
        }
    }

    public boolean keyEvent(@Nonnull KeyboardInputEvent inputEvent) {
        if (this.keyboardFocusElement != null) {
            return this.keyboardFocusElement.keyEvent(inputEvent);
        }
        return false;
    }

    public void requestExclusiveMouseFocus(Element newFocusElement) {
        if (this.mouseFocusElement == newFocusElement) {
            return;
        }
        this.mouseFocusElement = newFocusElement;
        log.fine("requestExclusiveMouseFocus for [" + this.mouseFocusElement.toString() + "]");
    }

    public boolean hasExclusiveMouseFocus(@Nonnull Element element) {
        return element.equals(this.mouseFocusElement);
    }

    public boolean canProcessMouseEvents(@Nonnull Element element) {
        if (this.mouseFocusElement == null) {
            return true;
        }
        boolean canProcess = this.mouseFocusElement == element;
        log.fine("canProcessMouseEvents for [" + element.toString() + "] ==> " + canProcess + " (" + this.mouseFocusElement.toString() + ")");
        return canProcess;
    }

    public void lostMouseFocus(@Nullable Element elementThatLostFocus) {
        if (elementThatLostFocus != null) {
            log.fine("lostMouseFocus for [" + elementThatLostFocus.toString() + "]");
            if (this.mouseFocusElement == elementThatLostFocus) {
                this.mouseFocusElement = null;
            }
        }
    }

    @Nonnull
    public String toString() {
        String mouseFocusString = "---";
        if (this.mouseFocusElement != null) {
            mouseFocusString = this.mouseFocusElement.toString();
        }
        String keyboardFocusString = "---";
        if (this.keyboardFocusElement != null) {
            keyboardFocusString = this.keyboardFocusElement.toString();
        }
        StringBuilder focusElements = new StringBuilder();
        for (int i = 0; i < this.entries.size(); ++i) {
            Element e = this.entries.get(i);
            if (i > 0) {
                focusElements.append(", ");
            }
            focusElements.append(e.getId()).append(!e.isFocusable() ? "*" : "");
        }
        return "\nfocus element (mouse):    " + mouseFocusString + "\nfocus element (keyboard): " + keyboardFocusString + "\nfocus element size: " + this.entries.size() + " [" + focusElements.toString() + "]";
    }

    public boolean hasAnyElementTheKeyboardFocus() {
        return this.keyboardFocusElement != null;
    }

    public boolean hasAnyElementTheMouseFocus() {
        return this.mouseFocusElement != null;
    }

    @Nullable
    public Element findElement(@Nonnull String defaultFocusElementId) {
        for (Element element : this.entries) {
            if (!defaultFocusElementId.equals(element.getId())) continue;
            return element;
        }
        return null;
    }

    @Nullable
    public Element getKeyboardFocusElement() {
        return this.keyboardFocusElement;
    }

    @Nullable
    public Element getMouseFocusElement() {
        return this.mouseFocusElement;
    }
}

