/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.builder;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyStopwatch;
import de.lessvoid.nifty.builder.LayerBuilder;
import de.lessvoid.nifty.controls.dynamic.ScreenCreator;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.screen.ScreenController;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class ScreenBuilder {
    private final ScreenCreator creator;
    @Nonnull
    private final List<LayerBuilder> layerBuilders = new ArrayList<LayerBuilder>();

    public ScreenBuilder(@Nonnull String id) {
        this.creator = this.createScreenCreator(id);
    }

    public ScreenBuilder(String id, ScreenController controller) {
        this(id);
        this.creator.setScreenController(controller);
    }

    public ScreenBuilder controller(ScreenController controller) {
        this.creator.setScreenController(controller);
        return this;
    }

    public ScreenBuilder defaultFocusElement(String defaultFocusElement) {
        this.creator.setDefaultFocusElement(defaultFocusElement);
        return this;
    }

    public ScreenBuilder inputMapping(String inputMapping) {
        this.creator.setInputMapping(inputMapping);
        return this;
    }

    public ScreenBuilder inputMappingPre(String inputMappingPre) {
        this.creator.setInputMappingPre(inputMappingPre);
        return this;
    }

    public ScreenBuilder layer(LayerBuilder layerBuilder) {
        this.layerBuilders.add(layerBuilder);
        return this;
    }

    @Nonnull
    public Screen build(@Nonnull Nifty nifty) {
        NiftyStopwatch.start();
        Screen screen = this.creator.create(nifty);
        Element screenRootElement = screen.getRootElement();
        for (LayerBuilder layerBuilder : this.layerBuilders) {
            layerBuilder.build(nifty, screen, screenRootElement);
        }
        NiftyStopwatch.stop("ScreenBuilder.build ()");
        return screen;
    }

    ScreenCreator createScreenCreator(@Nonnull String id) {
        return new ScreenCreator(id);
    }
}

