/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty;

import de.lessvoid.nifty.Parameterizable;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ParameterizedObjectFactory<T extends Parameterizable> {
    @Nonnull
    private static final Logger log = Logger.getLogger(ParameterizedObjectFactory.class.getName());
    @Nonnull
    private final Map<String, Class<? extends T>> m_objectNameToClassMapping;
    @Nonnull
    private final String m_fallbackObjectName;

    public ParameterizedObjectFactory(@Nonnull Map<String, Class<? extends T>> objectNameToClassMapping, @Nonnull String fallbackObjectName) {
        this.m_objectNameToClassMapping = objectNameToClassMapping;
        this.m_fallbackObjectName = fallbackObjectName;
    }

    @Nonnull
    public T create(@Nullable String objectDescription) {
        T object;
        try {
            object = this.createInternal(objectDescription);
        }
        catch (IllegalArgumentException e) {
            log.warning(e.getMessage() + " -> Falling back to default " + this.m_fallbackObjectName + ".");
            object = this.createInternal(this.m_fallbackObjectName);
        }
        return object;
    }

    @Nonnull
    private T createInternal(@Nullable String objectDescription) {
        T object = this.instanciateObject(objectDescription);
        this.initializeObject(object, objectDescription);
        return object;
    }

    @Nonnull
    private T instanciateObject(@Nullable String objectDescription) {
        Class<T> objectClass;
        String objectName = this.m_fallbackObjectName;
        if (objectDescription != null) {
            objectName = objectDescription.split(":")[0];
        }
        if ((objectClass = this.m_objectNameToClassMapping.get(objectName)) == null) {
            throw new IllegalArgumentException("No class found for [" + objectName + "].");
        }
        try {
            return (T)((Parameterizable)objectClass.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate class [" + objectClass.getName() + "].", e);
        }
    }

    private void initializeObject(@Nonnull T object, @Nullable String objectDescription) {
        String[] tokens;
        String objectParameters = null;
        if (objectDescription != null && (tokens = objectDescription.split(":")).length > 1) {
            objectParameters = tokens[1];
        }
        object.setParameters(objectParameters);
    }
}

