/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty;

import de.lessvoid.nifty.Clipboard;
import de.lessvoid.nifty.ClipboardAWT;
import de.lessvoid.nifty.ClipboardInternal;
import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.NiftyDefaults;
import de.lessvoid.nifty.NiftyDelayedMethodInvoke;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.NiftyEventAnnotationProcessor;
import de.lessvoid.nifty.NiftyIdCreator;
import de.lessvoid.nifty.NiftyInputConsumer;
import de.lessvoid.nifty.NiftyInputConsumerNotify;
import de.lessvoid.nifty.NiftyLocaleChangedEvent;
import de.lessvoid.nifty.NiftyMouse;
import de.lessvoid.nifty.controls.StandardControl;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.elements.Action;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.ElementMoveAction;
import de.lessvoid.nifty.elements.ElementRemoveAction;
import de.lessvoid.nifty.elements.EndOfFrameElementAction;
import de.lessvoid.nifty.input.NiftyInputMapping;
import de.lessvoid.nifty.input.NiftyMouseInputEvent;
import de.lessvoid.nifty.input.keyboard.KeyboardInputEvent;
import de.lessvoid.nifty.input.mouse.MouseInputEventProcessor;
import de.lessvoid.nifty.layout.Box;
import de.lessvoid.nifty.layout.BoxConstraints;
import de.lessvoid.nifty.layout.LayoutPart;
import de.lessvoid.nifty.loaderv2.ControllerFactory;
import de.lessvoid.nifty.loaderv2.NiftyLoader;
import de.lessvoid.nifty.loaderv2.RootLayerFactory;
import de.lessvoid.nifty.loaderv2.types.ControlDefinitionType;
import de.lessvoid.nifty.loaderv2.types.ElementType;
import de.lessvoid.nifty.loaderv2.types.LayerType;
import de.lessvoid.nifty.loaderv2.types.NiftyType;
import de.lessvoid.nifty.loaderv2.types.PopupType;
import de.lessvoid.nifty.loaderv2.types.RegisterEffectType;
import de.lessvoid.nifty.loaderv2.types.RegisterMusicType;
import de.lessvoid.nifty.loaderv2.types.RegisterSoundType;
import de.lessvoid.nifty.loaderv2.types.ResourceBundleType;
import de.lessvoid.nifty.loaderv2.types.StyleType;
import de.lessvoid.nifty.loaderv2.types.resolver.style.StyleResolver;
import de.lessvoid.nifty.loaderv2.types.resolver.style.StyleResolverDefault;
import de.lessvoid.nifty.render.NiftyImage;
import de.lessvoid.nifty.render.NiftyMouseImpl;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.render.NiftyRenderEngineImpl;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.screen.ScreenController;
import de.lessvoid.nifty.sound.SoundSystem;
import de.lessvoid.nifty.spi.input.InputSystem;
import de.lessvoid.nifty.spi.render.RenderDevice;
import de.lessvoid.nifty.spi.render.RenderFont;
import de.lessvoid.nifty.spi.sound.SoundDevice;
import de.lessvoid.nifty.spi.time.TimeProvider;
import de.lessvoid.nifty.tools.FlipFlop;
import de.lessvoid.nifty.tools.SizeValue;
import de.lessvoid.nifty.tools.resourceloader.NiftyResourceLoader;
import de.lessvoid.xml.tools.BundleInfo;
import de.lessvoid.xml.tools.BundleInfoBasename;
import de.lessvoid.xml.tools.BundleInfoResourceBundle;
import de.lessvoid.xml.tools.SpecialValuesReplace;
import de.lessvoid.xml.xpp3.Attributes;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import org.bushe.swing.event.EventService;
import org.bushe.swing.event.EventServiceExistsException;
import org.bushe.swing.event.EventServiceLocator;
import org.bushe.swing.event.EventTopicSubscriber;
import org.bushe.swing.event.ProxySubscriber;
import org.bushe.swing.event.ThreadSafeEventService;
import org.bushe.swing.event.annotation.ReferenceStrength;

public class Nifty {
    @Nonnull
    private static final Logger log = Logger.getLogger(Nifty.class.getName());
    @Nonnull
    private final NiftyRenderEngine renderEngine;
    @Nonnull
    private final SoundSystem soundSystem;
    @Nonnull
    private final InputSystem inputSystem;
    @Nonnull
    private final TimeProvider timeProvider;
    @Nonnull
    private final NiftyResourceLoader resourceLoader;
    @Nonnull
    private final NiftyLoader loader;
    @Nonnull
    private final NiftyMouseImpl niftyMouse;
    @Nonnull
    private final MouseInputEventProcessor mouseInputEventProcessor;
    @Nonnull
    private final Map<String, Screen> screens;
    @Nonnull
    private final Map<String, PopupType> popupTypes;
    @Nonnull
    private final Map<String, Element> popups;
    @Nonnull
    private final Map<String, StyleType> styles;
    @Nonnull
    private final Set<String> controlStylesChanged;
    @Nonnull
    private final Map<String, ControlDefinitionType> controlDefinitions;
    @Nonnull
    private final Map<String, RegisterEffectType> registeredEffects;
    @Nonnull
    private final Map<String, ScreenController> registeredScreenControllers;
    @Nonnull
    private final ControllerFactory controllerFactory;
    @Nonnull
    private final FlipFlop<List<DelayedMethodInvoke>> delayedMethodInvokes;
    @Nonnull
    private final FlipFlop<List<EndOfFrameElementAction>> endOfFrameElementActions;
    @Nonnull
    private Locale locale;
    @Nullable
    private Screen currentScreen;
    @Nullable
    private String currentLoaded;
    private boolean exit;
    private boolean resolutionChanged;
    private final Set<String> closedPopups = new HashSet<String>();
    @Nonnull
    private final List<ClosePopUp> closePopupList = new ArrayList<ClosePopUp>();
    @Nullable
    private String alternateKeyForNextLoadXml;
    private long lastTime;
    private boolean gotoScreenInProgress;
    @Nullable
    private String alternateKey;
    @Nonnull
    private final Map<String, BundleInfo> resourceBundles = new HashMap<String, BundleInfo>();
    @Nullable
    private Properties globalProperties;
    @Nonnull
    private final RootLayerFactory rootLayerFactory = new RootLayerFactory();
    @Nonnull
    private final NiftyInputConsumerImpl niftyInputConsumer = new NiftyInputConsumerImpl();
    private NiftyInputConsumerNotify niftyInputConsumerNotify = new NiftyInputConsumerNotifyDefault();
    @Nonnull
    private final SubscriberRegistry subscriberRegister = new SubscriberRegistry();
    private boolean debugOptionPanelColors;
    @Nonnull
    private Clipboard clipboard;
    private boolean ignoreMouseEvents;
    private boolean ignoreKeyboardEvents;
    private boolean niftyMethodInvokerDebugEnabled;

    public Nifty(@Nonnull RenderDevice newRenderDevice, @Nonnull SoundDevice newSoundDevice, @Nonnull InputSystem newInputSystem, @Nonnull TimeProvider newTimeProvider) {
        this.screens = new HashMap<String, Screen>();
        this.popupTypes = new HashMap<String, PopupType>();
        this.popups = new HashMap<String, Element>();
        this.styles = new HashMap<String, StyleType>();
        this.controlDefinitions = new HashMap<String, ControlDefinitionType>();
        this.registeredEffects = new HashMap<String, RegisterEffectType>();
        this.registeredScreenControllers = new HashMap<String, ScreenController>();
        this.controllerFactory = new ControllerFactory();
        this.controlStylesChanged = new HashSet<String>();
        this.delayedMethodInvokes = new FlipFlop(new ArrayList(), new ArrayList());
        this.endOfFrameElementActions = new FlipFlop(new ArrayList(), new ArrayList());
        this.resourceLoader = new NiftyResourceLoader();
        newRenderDevice.setResourceLoader(this.resourceLoader);
        newSoundDevice.setResourceLoader(this.resourceLoader);
        newInputSystem.setResourceLoader(this.resourceLoader);
        this.renderEngine = new NiftyRenderEngineImpl(newRenderDevice);
        this.soundSystem = new SoundSystem(newSoundDevice);
        this.inputSystem = newInputSystem;
        this.timeProvider = newTimeProvider;
        this.mouseInputEventProcessor = new MouseInputEventProcessor();
        this.niftyMouse = new NiftyMouseImpl(newRenderDevice, newInputSystem, newTimeProvider);
        this.loader = new NiftyLoader(this, this.timeProvider);
        this.locale = Locale.getDefault();
        try {
            Class.forName("java.awt.datatransfer.Clipboard", false, Nifty.class.getClassLoader());
            this.clipboard = new ClipboardAWT();
        }
        catch (Throwable e) {
            log.warning("unable to access class 'java.awt.datatransfer.Clipboard'. clipboard will be disabled.");
            this.clipboard = new ClipboardInternal();
        }
        this.initializeLoaderSchemas();
        NiftyDefaults.initDefaultEffects(this);
        this.initializeEventBus();
        this.lastTime = this.timeProvider.getMsTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersion() {
        String result = "N/A";
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        InputStream stream = Nifty.class.getClassLoader().getResourceAsStream("version");
        try {
            int len;
            byte[] buffer = new byte[1024];
            while ((len = stream.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            result = out.toString("ISO-8859-1");
        }
        catch (Exception e) {
            log.log(Level.WARNING, "unable to read version file from classpath", e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                log.log(Level.WARNING, "unable to close version file from classpath stream. this is a bit odd", e);
            }
        }
        return result;
    }

    private void initializeLoaderSchemas() {
        this.loaderLoadSchema("nifty.nxs");
        this.loaderLoadSchema("nifty-styles.nxs");
        this.loaderLoadSchema("nifty-controls.nxs");
    }

    private void loaderLoadSchema(@Nonnull String schemaName) {
        try {
            InputStream stream = this.getResourceAsStream(schemaName);
            if (stream == null) {
                throw new IOException("Failed to open stream to schema resource \"" + schemaName + "\".");
            }
            this.loader.registerSchema(schemaName, stream);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to load the schema \"" + schemaName + "\" for the NiftyLoader", e);
        }
    }

    private void initializeEventBus() {
        try {
            if (EventServiceLocator.getEventService("NiftyEventBus") == null) {
                EventServiceLocator.setEventService("NiftyEventBus", new ThreadSafeEventService());
            }
        }
        catch (EventServiceExistsException e) {
            log.log(Level.SEVERE, "Initialization failure. EventBus failed to initialize.", e);
        }
    }

    @Nonnull
    public EventService getEventService() {
        EventService service = EventServiceLocator.getEventService("NiftyEventBus");
        if (service == null) {
            log.severe("NiftyEventBus service was not found. Problem during initialization is likely.");
            return EventServiceLocator.getEventBusService();
        }
        return service;
    }

    public void publishEvent(@Nonnull String id, @Nonnull NiftyEvent event) {
        this.getEventService().publish(id, (Object)event);
    }

    public void subscribeAnnotations(@Nonnull Object object) {
        NiftyEventAnnotationProcessor.process(object);
    }

    public void unsubscribeAnnotations(@Nonnull Object object) {
        NiftyEventAnnotationProcessor.unprocess(object);
    }

    public <T, S extends EventTopicSubscriber<? extends T>> void subscribe(@Nonnull Screen screen, @Nonnull String elementId, @Nonnull Class<T> eventClass, @Nonnull S subscriber) {
        ClassSaveEventTopicSubscriber theSubscriber = new ClassSaveEventTopicSubscriber(elementId, subscriber, eventClass);
        this.getEventService().subscribeStrongly(elementId, (EventTopicSubscriber)theSubscriber);
        log.fine("-> subscribe [" + elementId + "] screen [" + screen + "] -> [" + theSubscriber + "(" + subscriber + "),(" + eventClass + ")]");
        this.subscriberRegister.register(screen, elementId, theSubscriber);
    }

    public void unsubscribe(@Nullable String elementId, Object object) {
        if (object instanceof EventTopicSubscriber) {
            if (elementId == null) {
                log.warning("trying to unsubscribe events for an element with elementId = null. this won't work. offending object \"" + object + "\". try to find the offending element and give it an id!");
                return;
            }
            this.getEventService().unsubscribe(elementId, (EventTopicSubscriber)object);
            log.fine("<- unsubscribe [" + elementId + "] -> [" + object + "]");
        }
    }

    public void unsubscribeScreen(@Nonnull Screen screen) {
        this.subscriberRegister.unsubscribeScreen(screen);
    }

    public void unsubscribeElement(@Nonnull Screen screen, @Nonnull String elementId) {
        this.subscriberRegister.unsubscribeElement(screen, elementId);
    }

    public void setAlternateKeyForNextLoadXml(@Nullable String alternateKeyForNextLoadXmlParam) {
        this.alternateKeyForNextLoadXml = alternateKeyForNextLoadXmlParam;
    }

    public boolean update() {
        if (this.currentScreen != null) {
            this.mouseInputEventProcessor.begin();
            this.inputSystem.forwardEvents(this.niftyInputConsumer);
            if (this.mouseInputEventProcessor.hasLastMouseDownEvent()) {
                this.forwardMouseEventToScreen(this.mouseInputEventProcessor.getLastMouseDownEvent(), this.currentScreen);
            }
        }
        this.handleDynamicElements();
        this.updateSoundSystem();
        if (this.currentScreen != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(this.currentScreen.debugOutput());
            } else if (log.isLoggable(Level.FINER)) {
                log.fine(this.currentScreen.debugOutputFocusElements());
            }
        }
        return this.exit;
    }

    private boolean forwardMouseEventToScreen(@Nonnull NiftyMouseInputEvent mouseEvent, @Nonnull Screen screen) {
        this.niftyMouse.updateMousePosition(mouseEvent.getMouseX(), mouseEvent.getMouseY());
        return screen.mouseEvent(mouseEvent);
    }

    public void render(boolean clearScreen) {
        this.renderEngine.beginFrame();
        if (clearScreen) {
            this.renderEngine.clear();
        }
        this.renderEngine.applyAbsoluteClip();
        if (this.currentScreen != null) {
            this.currentScreen.renderLayers(this.renderEngine);
        }
        if (this.exit) {
            this.renderEngine.clear();
        }
        this.renderEngine.endFrame();
        if (this.resolutionChanged) {
            this.resolutionChanged = false;
            this.displayResolutionChanged();
        }
    }

    private void updateSoundSystem() {
        long current = this.timeProvider.getMsTime();
        int delta = (int)(current - this.lastTime);
        this.soundSystem.update(delta);
        this.lastTime = current;
    }

    public void resetMouseInputEvents() {
        this.niftyInputConsumer.resetMouseDown();
        this.mouseInputEventProcessor.reset();
        if (this.currentScreen != null) {
            this.currentScreen.resetMouseDown();
        }
    }

    private void handleDynamicElements() {
        while (this.hasDynamics()) {
            this.invokeMethods();
            this.closePopUps();
            this.removeLayerElements();
            this.executeEndOfFrameElementActionsInternal();
        }
    }

    private boolean hasDynamics() {
        return this.hasInvokeMethods() || this.hasClosePopups() || this.hasRemoveLayerElements() || this.hasEndOfFrameElementActions();
    }

    private boolean hasRemoveLayerElements() {
        if (this.currentScreen == null) {
            return false;
        }
        return this.currentScreen.hasDynamicElements();
    }

    private void removeLayerElements() {
        if (this.currentScreen != null) {
            this.currentScreen.processAddAndRemoveLayerElements();
        }
    }

    private boolean hasClosePopups() {
        return !this.closePopupList.isEmpty();
    }

    private void closePopUps() {
        if (this.hasClosePopups()) {
            if (this.currentScreen == null) {
                this.closePopupList.clear();
                return;
            }
            ArrayList<ClosePopUp> copy = new ArrayList<ClosePopUp>(this.closePopupList);
            this.closePopupList.clear();
            for (int i = 0; i < copy.size(); ++i) {
                ClosePopUp closePopup = copy.get(i);
                closePopup.close();
            }
        }
    }

    private void executeEndOfFrameElementActionsInternal() {
        if (this.hasEndOfFrameElementActions()) {
            this.endOfFrameElementActions.flip();
            List<EndOfFrameElementAction> workingCopy = this.endOfFrameElementActions.getSecond();
            int size = workingCopy.size();
            for (int i = 0; i < size; ++i) {
                workingCopy.get(i).perform();
            }
            workingCopy.clear();
        }
    }

    @Deprecated
    public void executeEndOfFrameElementActions() {
        log.warning("executeEndOfFrameElementActions() is a method that is basically the root of all evil. If you need to use it, your application most likely has a real bad design flaw. The trouble you can cause using this function is... big.");
        this.executeEndOfFrameElementActionsInternal();
    }

    private boolean hasEndOfFrameElementActions() {
        return !this.endOfFrameElementActions.getFirst().isEmpty();
    }

    public void fromXml(@Nonnull String filename, @Nonnull String startScreen) {
        this.prepareScreens(filename);
        this.loadFromFile(filename);
        this.gotoScreen(startScreen);
    }

    public void fromXmlWithoutStartScreen(@Nonnull String filename) {
        this.prepareScreens(filename);
        this.loadFromFile(filename);
    }

    public void fromXml(@Nonnull String filename, @Nonnull String startScreen, ScreenController ... controllers) {
        this.registerScreenController(controllers);
        this.prepareScreens(filename);
        this.loadFromFile(filename);
        this.gotoScreen(startScreen);
    }

    public void fromXml(@Nonnull String fileId, @Nonnull InputStream input, @Nonnull String startScreen) {
        this.prepareScreens(fileId);
        this.loadFromStream(input);
        this.gotoScreen(startScreen);
    }

    public void fromXmlWithoutStartScreen(@Nonnull String fileId, @Nonnull InputStream input) {
        this.prepareScreens(fileId);
        this.loadFromStream(input);
    }

    public void fromXml(@Nonnull String fileId, @Nonnull InputStream input, @Nonnull String startScreen, ScreenController ... controllers) {
        this.registerScreenController(controllers);
        this.prepareScreens(fileId);
        this.loadFromStream(input);
        this.gotoScreen(startScreen);
    }

    public void addXml(@Nonnull String filename) {
        this.loadFromFile(filename);
    }

    public void addXml(@Nonnull @WillClose InputStream stream) {
        this.loadFromStream(stream);
    }

    public void validateXml(@Nonnull String filename) throws Exception {
        InputStream stream = this.getResourceAsStream(filename);
        if (stream == null) {
            throw new IOException("Failed to open stream to resource \"" + filename + "\" for validating.");
        }
        this.validateXml(stream);
    }

    public void validateXml(@Nonnull @WillClose InputStream stream) throws Exception {
        this.loader.validateNiftyXml("nifty.xsd", stream);
    }

    void loadFromFile(@Nonnull String filename) {
        log.fine("loadFromFile [" + filename + "]");
        try {
            long start = this.timeProvider.getMsTime();
            InputStream stream = this.getResourceAsStream(filename);
            if (stream == null) {
                throw new IOException("Failed to open stream to resource \"" + filename + "\" for loading.");
            }
            NiftyType niftyType = this.loader.loadNiftyXml("nifty.nxs", stream);
            niftyType.create(this, this.timeProvider);
            if (log.isLoggable(Level.FINE)) {
                log.fine(niftyType.output());
            }
            long end = this.timeProvider.getMsTime();
            log.fine("loadFromFile took [" + (end - start) + "]");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void loadFromStream(@Nonnull @WillClose InputStream stream) {
        log.fine("loadFromStream []");
        try {
            long start = this.timeProvider.getMsTime();
            NiftyType niftyType = this.loader.loadNiftyXml("nifty.nxs", stream);
            niftyType.create(this, this.timeProvider);
            if (log.isLoggable(Level.FINE)) {
                log.fine(niftyType.output());
            }
            long end = this.timeProvider.getMsTime();
            log.fine("loadFromStream took [" + (end - start) + "]");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void prepareScreens(@Nonnull String xmlId) {
        this.renderEngine.screensClear(this.screens.values());
        this.screens.clear();
        this.currentLoaded = xmlId;
        this.exit = false;
    }

    public void gotoScreen(final @Nonnull String id) {
        if (this.gotoScreenInProgress) {
            log.fine("gotoScreen [" + id + "] aborted because still in gotoScreenInProgress phase");
            return;
        }
        log.fine("gotoScreen [" + id + "]");
        this.gotoScreenInProgress = true;
        if (this.currentScreen == null) {
            this.gotoScreenInternal(id);
        } else {
            this.currentScreen.endScreen(new EndNotify(){

                @Override
                public void perform() {
                    Nifty.this.gotoScreenInternal(id);
                }
            });
        }
    }

    private void gotoScreenInternal(@Nonnull String id) {
        log.fine("gotoScreenInternal [" + id + "]");
        if (this.hasClosePopups()) {
            ArrayList<ClosePopUp> copy = new ArrayList<ClosePopUp>(this.closePopupList);
            this.closePopupList.clear();
            for (int i = 0; i < copy.size(); ++i) {
                ClosePopUp closePopup = copy.get(i);
                closePopup.forcedCloseWithoutEndNotify();
            }
        }
        this.currentScreen = this.screens.get(id);
        if (this.currentScreen == null) {
            log.warning("screen [" + id + "] not found");
            this.gotoScreenInProgress = false;
            return;
        }
        if (this.alternateKeyForNextLoadXml != null) {
            this.currentScreen.setAlternateKey(this.alternateKeyForNextLoadXml);
            this.alternateKeyForNextLoadXml = null;
        }
        this.currentScreen.startScreen(new EndNotify(){

            @Override
            public void perform() {
                Nifty.this.gotoScreenInProgress = false;
            }
        });
    }

    public void setAlternateKey(@Nullable String alternateKey) {
        this.alternateKey = alternateKey;
        for (Screen screen : this.screens.values()) {
            screen.setAlternateKey(alternateKey);
        }
    }

    @Nonnull
    public Collection<String> getAllScreensName() {
        LinkedList<String> sn = new LinkedList<String>();
        for (Screen screen : this.screens.values()) {
            sn.add(screen.getScreenId());
        }
        return sn;
    }

    public void removeScreen(final @Nonnull String id) {
        if (this.currentScreen != null) {
            if (this.currentScreen.getScreenId().equals(id)) {
                this.currentScreen.endScreen(new EndNotify(){

                    @Override
                    public void perform() {
                        Nifty.this.currentScreen = null;
                        Nifty.this.removeScreenInternal(id);
                    }
                });
                return;
            }
            this.removeScreenInternal(id);
        }
    }

    private void removeScreenInternal(@Nonnull String id) {
        Screen screen = this.screens.remove(id);
        if (screen == null) {
            log.log(Level.SEVERE, "Internal delete of screen \"" + id + "\" failed: Screen instance not found.");
        } else {
            this.renderEngine.screenRemoved(screen);
            if (screen.getLayerElements().size() == 0) {
                return;
            }
            for (int i = 0; i < screen.getLayerElements().size(); ++i) {
                this.removeElement(screen, screen.getLayerElements().get(i));
            }
        }
    }

    @Nonnull
    public Collection<String> getAllStylesName() {
        return this.styles.keySet();
    }

    public void exit() {
        if (this.currentScreen == null) {
            return;
        }
        this.currentScreen.endScreen(new EndNotify(){

            @Override
            public final void perform() {
                Nifty.this.exit = true;
                Nifty.this.currentScreen = null;
            }
        });
    }

    public void resolutionChanged() {
        this.resolutionChanged = true;
    }

    private void displayResolutionChanged() {
        this.getRenderEngine().displayResolutionChanged();
        this.resetMouseInputEvents();
        int newWidth = this.getRenderEngine().getWidth();
        int newHeight = this.getRenderEngine().getHeight();
        for (Screen screen : this.screens.values()) {
            this.updateLayoutPart(screen.getRootElement().getLayoutPart(), newWidth, newHeight);
            for (Element e : screen.getLayerElements()) {
                this.updateLayoutPart(e.getLayoutPart(), newWidth, newHeight);
            }
            screen.resetLayout();
        }
        for (Element e : this.popups.values()) {
            this.updateLayoutPart(e.getLayoutPart(), newWidth, newHeight);
        }
        if (this.currentScreen != null) {
            this.currentScreen.layoutLayers();
        }
    }

    private void updateLayoutPart(@Nonnull LayoutPart layoutPart, int width, int height) {
        Box box = layoutPart.getBox();
        box.setWidth(width);
        box.setHeight(height);
        BoxConstraints boxConstraints = layoutPart.getBoxConstraints();
        boxConstraints.setWidth(SizeValue.px(width));
        boxConstraints.setHeight(SizeValue.px(height));
    }

    @Nullable
    public Screen getScreen(@Nonnull String id) {
        Screen screen = this.screens.get(id);
        if (screen == null) {
            log.warning("screen [" + id + "] not found");
            return null;
        }
        return screen;
    }

    @Nonnull
    public SoundSystem getSoundSystem() {
        return this.soundSystem;
    }

    @Nonnull
    public NiftyRenderEngine getRenderEngine() {
        return this.renderEngine;
    }

    @Nullable
    public Screen getCurrentScreen() {
        return this.currentScreen;
    }

    public boolean isActive(@Nonnull String filename, @Nonnull String screenId) {
        return this.currentLoaded != null && this.currentLoaded.equals(filename) && this.currentScreen != null && this.currentScreen.getScreenId().equals(screenId);
    }

    public void registerPopup(@Nonnull PopupType popup) {
        this.popupTypes.put(popup.getAttributes().get("id"), popup);
    }

    public void showPopup(@Nonnull Screen screen, @Nonnull String id, @Nullable Element defaultFocusElement) {
        Element popup = this.popups.get(id);
        if (popup == null) {
            log.warning("missing popup [" + id + "] o_O");
        } else {
            screen.addPopup(popup, defaultFocusElement);
        }
    }

    @Nonnull
    private Element createPopupFromType(@Nonnull Screen screen, @Nonnull PopupType popupTypeParam, @Nonnull String id) {
        LayoutPart layerLayout = this.rootLayerFactory.createRootLayerLayoutPart(this);
        PopupType popupType = new PopupType(popupTypeParam);
        popupType.prepare(this, screen, screen.getRootElement().getElementType());
        Element element = popupType.create(screen.getRootElement(), this, screen, layerLayout);
        element.setId(id);
        this.fixupSubIds(element, id);
        if (screen.isBound()) {
            element.layoutElements();
            element.bindControls(screen);
        }
        return element;
    }

    private void fixupSubIds(@Nonnull Element element, @Nonnull String parentId) {
        String currentId = element.getId();
        if (currentId != null && currentId.startsWith("#")) {
            currentId = parentId + currentId;
            element.setId(currentId);
        }
        if (currentId == null) {
            currentId = parentId;
        }
        for (int i = 0; i < element.getChildren().size(); ++i) {
            Element e = element.getChildren().get(i);
            this.fixupSubIds(e, currentId);
        }
    }

    @Nullable
    public Element createPopup(@Nonnull String popupId) {
        return this.createPopupWithId(popupId, NiftyIdCreator.generate());
    }

    @Nonnull
    public Element createPopup(@Nonnull Screen screen, @Nonnull String popupId) {
        return this.createPopupWithId(screen, popupId, NiftyIdCreator.generate());
    }

    @Nullable
    public Element createPopupWithId(@Nonnull String popupId, @Nonnull String id) {
        return this.createPopupWithStyle(popupId, id, null, null);
    }

    @Nonnull
    public Element createPopupWithId(@Nonnull Screen screen, @Nonnull String popupId, @Nonnull String id) {
        return this.createPopupWithStyle(screen, popupId, id, null, null);
    }

    @Nullable
    public Element createPopupWithStyle(@Nonnull String popupId, @Nullable String style) {
        return this.createPopupWithStyle(popupId, NiftyIdCreator.generate(), style);
    }

    @Nonnull
    public Element createPopupWithStyle(@Nonnull Screen screen, @Nonnull String popupId, @Nullable String style) {
        return this.createPopupWithStyle(screen, popupId, NiftyIdCreator.generate(), style);
    }

    @Nullable
    public Element createPopupWithStyle(@Nonnull String popupId, @Nonnull String id, @Nullable String style) {
        return this.createPopupWithStyle(popupId, id, style, null);
    }

    @Nonnull
    public Element createPopupWithStyle(@Nonnull Screen screen, @Nonnull String popupId, @Nonnull String id, @Nullable String style) {
        return this.createPopupWithStyle(screen, popupId, id, style, null);
    }

    @Nullable
    public Element createPopupWithStyle(@Nonnull String popupId, @Nullable String style, @Nullable Attributes parameters) {
        return this.createPopupWithStyle(popupId, NiftyIdCreator.generate(), style, parameters);
    }

    @Nonnull
    public Element createPopupWithStyle(@Nonnull Screen screen, @Nonnull String popupId, @Nullable String style, @Nullable Attributes parameters) {
        return this.createPopupWithStyle(screen, popupId, NiftyIdCreator.generate(), style, parameters);
    }

    @Nullable
    public Element createPopupWithStyle(@Nonnull String popupId, @Nonnull String id, @Nullable String style, @Nullable Attributes parameters) {
        Screen screen = this.getCurrentScreen();
        if (screen == null) {
            return null;
        }
        return this.createPopupWithStyle(screen, popupId, id, style, parameters);
    }

    @Nonnull
    public Element createPopupWithStyle(@Nonnull Screen screen, @Nonnull String popupId, @Nonnull String id, @Nullable String style, @Nullable Attributes parameters) {
        PopupType popupType = this.popupTypes.get(popupId);
        if (popupType == null) {
            throw new IllegalArgumentException("Popup ID \"" + popupId + "\" can't be matched to a popup type.");
        }
        popupType = popupType.copy();
        if (style != null) {
            popupType.getAttributes().set("style", style);
        }
        if (parameters != null) {
            popupType.getAttributes().merge(parameters);
        }
        return this.createAndAddPopup(screen, id, popupType);
    }

    @Nonnull
    private Element createAndAddPopup(@Nonnull Screen screen, @Nonnull String id, @Nonnull PopupType popupType) {
        Element popupElement = this.createPopupFromType(screen, popupType, id);
        this.popups.put(id, popupElement);
        return popupElement;
    }

    public Element findPopupByName(String id) {
        return this.popups.get(id);
    }

    @Nullable
    public Element getTopMostPopup() {
        if (this.currentScreen != null) {
            return this.currentScreen.getTopMostPopup();
        }
        return null;
    }

    public void closePopup(@Nonnull String id) {
        this.closePopupInternal(id, null);
    }

    public void closePopup(@Nonnull String id, @Nullable EndNotify closeNotify) {
        this.closePopupInternal(id, closeNotify);
    }

    private void closePopupInternal(final @Nonnull String id, final @Nullable EndNotify closeNotify) {
        Element popup = this.popups.get(id);
        if (popup == null) {
            log.warning("missing popup [" + id + "] o_O");
            return;
        }
        if (this.closedPopups.contains(id)) {
            log.fine("popup [" + id + "] already scheduled to be closed. Additional close call ignored.");
            return;
        }
        this.closedPopups.add(id);
        popup.resetAllEffects();
        popup.startEffect(EffectEventId.onEndScreen, new EndNotify(){

            @Override
            public void perform() {
                Nifty.this.closePopupList.add(new ClosePopUp(id, closeNotify));
            }
        });
    }

    @Nonnull
    public Element addControl(@Nonnull Screen screen, @Nonnull Element parent, @Nonnull StandardControl standardControl) {
        try {
            Element newControl = standardControl.createControl(this, screen, parent);
            if (screen.isBound()) {
                newControl.bindControls(screen);
                newControl.initControls(false);
            }
            if (screen.isRunning()) {
                newControl.startEffect(EffectEventId.onStartScreen);
                newControl.startEffect(EffectEventId.onActive);
                newControl.onStartScreen();
            }
            return newControl;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void removeElement(@Nonnull Screen screen, @Nonnull Element element) {
        this.removeElement(screen, element, null);
    }

    public void removeElement(final @Nonnull Screen screen, final @Nonnull Element element, final @Nullable EndNotify endNotify) {
        element.startEffect(EffectEventId.onEndScreen, new EndNotify(){

            @Override
            public void perform() {
                Nifty.this.scheduleEndOfFrameElementAction(new ElementRemoveAction(screen, element), endNotify);
            }
        });
    }

    public void moveElement(@Nonnull Screen screen, @Nonnull Element elementToMove, @Nonnull Element destination, @Nullable EndNotify endNotify) {
        elementToMove.removeFromFocusHandler();
        this.scheduleEndOfFrameElementAction(new ElementMoveAction(elementToMove, destination), endNotify);
    }

    @Deprecated
    public void scheduleEndOfFrameElementAction(@Nonnull Screen screen, @Nonnull Element element, @Nonnull Action action, @Nullable EndNotify endNotify) {
        this.scheduleEndOfFrameElementAction(action, endNotify);
    }

    public void scheduleEndOfFrameElementAction(@Nonnull Action action, @Nullable EndNotify endNotify) {
        this.endOfFrameElementActions.getFirst().add(new EndOfFrameElementAction(action, endNotify));
    }

    @Nonnull
    public MouseInputEventProcessor getMouseInputEventQueue() {
        return this.mouseInputEventProcessor;
    }

    public void registerScreenController(ScreenController ... controllers) {
        for (ScreenController c : controllers) {
            this.registeredScreenControllers.put(c.getClass().getName(), c);
        }
    }

    @Nullable
    public ScreenController findScreenController(@Nonnull String controllerClass) {
        return this.registeredScreenControllers.get(controllerClass);
    }

    public void unregisterScreenController(ScreenController ... controllers) {
        for (ScreenController c : controllers) {
            this.registeredScreenControllers.remove(c.getClass().getName());
        }
    }

    @Nonnull
    public ControllerFactory getControllerFactory() {
        return this.controllerFactory;
    }

    @Nonnull
    public NiftyLoader getLoader() {
        return this.loader;
    }

    @Nonnull
    public TimeProvider getTimeProvider() {
        return this.timeProvider;
    }

    public void addScreen(@Nonnull String id, @Nonnull Screen screen) {
        this.screens.put(id, screen);
        this.renderEngine.screenAdded(screen);
    }

    public void registerStyle(@Nonnull StyleType style) {
        String styleId = style.getStyleId();
        log.fine("registerStyle " + styleId);
        if (!this.styles.containsKey(styleId)) {
            this.styles.put(styleId, style);
            return;
        }
        log.warning("Style: " + styleId + " was already registered. The new definition will override the previous.");
        this.styles.put(styleId, style);
        if (styleId.contains("#")) {
            String simpleId = styleId.split("#")[0];
            this.controlStylesChanged.add(simpleId);
        } else {
            this.getEventService().publish("style-refresh:" + styleId, (Object)styleId);
        }
    }

    public void registerControlDefintion(@Nonnull ControlDefinitionType controlDefinition) {
        this.controlDefinitions.put(controlDefinition.getName(), controlDefinition);
    }

    public void registerEffect(@Nonnull RegisterEffectType registerEffectType) {
        this.registeredEffects.put(registerEffectType.getName(), registerEffectType);
    }

    @Nullable
    public ControlDefinitionType resolveControlDefinition(@Nullable String name) {
        if (name == null) {
            return null;
        }
        return this.controlDefinitions.get(name);
    }

    @Nullable
    public RegisterEffectType resolveRegisteredEffect(@Nullable String name) {
        if (name == null) {
            return null;
        }
        return this.registeredEffects.get(name);
    }

    @Nonnull
    public StyleResolver getDefaultStyleResolver() {
        return new StyleResolverDefault(this.styles);
    }

    @Nullable
    public String getAlternateKey() {
        return this.alternateKey;
    }

    public void delayedMethodInvoke(@Nonnull NiftyDelayedMethodInvoke method, Object ... params) {
        this.delayedMethodInvokes.getFirst().add(new DelayedMethodInvoke(method, params));
    }

    public void invokeMethods() {
        if (this.hasInvokeMethods()) {
            this.delayedMethodInvokes.flip();
            List<DelayedMethodInvoke> workingList = this.delayedMethodInvokes.getSecond();
            int count = workingList.size();
            for (int i = 0; i < count; ++i) {
                workingList.get(i).perform();
            }
            workingList.clear();
        }
    }

    private boolean hasInvokeMethods() {
        return !this.delayedMethodInvokes.getFirst().isEmpty();
    }

    public void setLocale(@Nonnull Locale locale) {
        this.locale = locale;
        this.getEventService().publish(new NiftyLocaleChangedEvent(locale));
        if (this.resourceBundles.size() > 0) {
            log.log(Level.WARNING, "Changing the locale will not effect ALL loaded resource bundles. TextRenderer should work now tho :)");
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    @Nonnull
    public Map<String, BundleInfo> getResourceBundles() {
        return this.resourceBundles;
    }

    public void addResourceBundle(@Nonnull String id, @Nonnull String filename) {
        this.resourceBundles.put(id, new BundleInfoBasename(filename));
    }

    public void addResourceBundle(@Nonnull String id, @Nonnull ResourceBundle resourceBundle) {
        BundleInfo bundleInfo = this.resourceBundles.get(id);
        if (bundleInfo != null && bundleInfo instanceof BundleInfoResourceBundle) {
            ((BundleInfoResourceBundle)bundleInfo).add(resourceBundle);
            return;
        }
        this.resourceBundles.put(id, new BundleInfoResourceBundle(resourceBundle));
    }

    @Nullable
    public Properties getGlobalProperties() {
        return this.globalProperties;
    }

    public void setGlobalProperties(@Nullable Properties globalProperties) {
        this.globalProperties = globalProperties;
    }

    @Nonnull
    public RootLayerFactory getRootLayerFactory() {
        return this.rootLayerFactory;
    }

    public void loadStyleFile(@Nonnull String styleFile) {
        try {
            NiftyType niftyType = new NiftyType();
            this.loader.loadStyleFile("nifty-styles.nxs", styleFile, niftyType, this);
            niftyType.create(this, this.getTimeProvider());
            if (log.isLoggable(Level.FINE)) {
                log.fine("loadStyleFile");
                log.fine(niftyType.output());
            }
            for (String id : this.controlStylesChanged) {
                this.getEventService().publish("style-refresh:" + id, (Object)id);
            }
            this.controlStylesChanged.clear();
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public void loadControlFile(@Nonnull String controlFile) {
        try {
            NiftyType niftyType = new NiftyType();
            this.loader.loadControlFile("nifty-controls.nxs", controlFile, niftyType);
            niftyType.create(this, this.getTimeProvider());
            if (log.isLoggable(Level.FINE)) {
                log.fine("loadControlFile");
                log.fine(niftyType.output());
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public void registerResourceBundle(@Nonnull String id, @Nonnull String filename) {
        try {
            NiftyType niftyType = new NiftyType();
            ResourceBundleType resourceBundle = new ResourceBundleType();
            resourceBundle.getAttributes().set("id", id);
            resourceBundle.getAttributes().set("filename", filename);
            niftyType.addResourceBundle(resourceBundle);
            niftyType.create(this, this.getTimeProvider());
            if (log.isLoggable(Level.FINE)) {
                log.fine("registerResourceBundle");
                log.fine(niftyType.output());
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public void registerEffect(@Nonnull String name, @Nonnull String classParam) {
        try {
            NiftyType niftyType = new NiftyType();
            RegisterEffectType registerEffect = new RegisterEffectType(name, classParam);
            niftyType.addRegisterEffect(registerEffect);
            niftyType.create(this, this.getTimeProvider());
            if (log.isLoggable(Level.FINE)) {
                log.fine("registerEffect");
                log.fine(niftyType.output());
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public void registerSound(@Nonnull String id, @Nonnull String filename) {
        try {
            NiftyType niftyType = new NiftyType();
            RegisterSoundType registerSound = new RegisterSoundType();
            registerSound.getAttributes().set("id", id);
            registerSound.getAttributes().set("filename", filename);
            niftyType.addRegisterSound(registerSound);
            niftyType.create(this, this.getTimeProvider());
            if (log.isLoggable(Level.FINE)) {
                log.fine("registerSound");
                log.fine(niftyType.output());
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public void registerMusic(@Nonnull String id, @Nonnull String filename) {
        try {
            NiftyType niftyType = new NiftyType();
            RegisterMusicType registerMusic = new RegisterMusicType();
            registerMusic.getAttributes().set("id", id);
            registerMusic.getAttributes().set("filename", filename);
            niftyType.addRegisterMusic(registerMusic);
            niftyType.create(this, this.getTimeProvider());
            if (log.isLoggable(Level.FINE)) {
                log.fine("registerMusic");
                log.fine(niftyType.output());
            }
        }
        catch (Exception e) {
            log.warning(e.getMessage());
        }
    }

    public void registerMouseCursor(@Nonnull String id, @Nonnull String filename, int hotspotX, int hotspotY) {
        try {
            this.getNiftyMouse().registerMouseCursor(id, filename, hotspotX, hotspotY);
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
    }

    @Nonnull
    public NiftyMouse getNiftyMouse() {
        return this.niftyMouse;
    }

    @Nonnull
    public Element createElementFromType(@Nonnull Screen screen, @Nonnull Element parent, ElementType type, int index) {
        if (type instanceof LayerType) {
            return this.createElementFromTypeInternal(screen, parent, type, this.getRootLayerFactory().createRootLayerLayoutPart(this), index);
        }
        return this.createElementFromTypeInternal(screen, parent, type, new LayoutPart(), index);
    }

    @Nonnull
    public Element createElementFromType(@Nonnull Screen screen, @Nonnull Element parent, ElementType type) {
        if (type instanceof LayerType) {
            return this.createElementFromTypeInternal(screen, parent, type, this.getRootLayerFactory().createRootLayerLayoutPart(this), parent.getChildren().size());
        }
        return this.createElementFromTypeInternal(screen, parent, type, new LayoutPart(), parent.getChildren().size());
    }

    @Nonnull
    private Element createElementFromTypeInternal(@Nonnull Screen screen, @Nonnull Element parent, @Nonnull ElementType type, @Nonnull LayoutPart layoutPart, int index) {
        ElementType elementType = type.isPrepared() ? type.copy() : type;
        elementType.prepare(this, screen, screen.getRootElement().getElementType());
        elementType.connectParentControls(parent);
        Element element = elementType.create(parent, this, screen, layoutPart, index);
        if (screen.isBound()) {
            element.bindControls(screen);
            element.initControls(false);
            element.startEffect(EffectEventId.onStartScreen);
            element.startEffect(EffectEventId.onActive);
            element.onStartScreen();
        }
        return element;
    }

    @Nullable
    public NiftyImage createImage(@Nonnull String name, boolean filterLinear) {
        Screen screen = this.getCurrentScreen();
        if (screen == null) {
            throw new IllegalStateException("Can't create a image with this method, while there is currently not active screen");
        }
        return this.renderEngine.createImage(screen, name, filterLinear);
    }

    @Nullable
    public NiftyImage createImage(@Nonnull Screen screen, @Nonnull String name, boolean filterLinear) {
        return this.renderEngine.createImage(screen, name, filterLinear);
    }

    public void setDebugOptionPanelColors(boolean option) {
        this.debugOptionPanelColors = option;
    }

    public boolean isDebugOptionPanelColors() {
        return this.debugOptionPanelColors;
    }

    @Nonnull
    public String specialValuesReplace(@Nullable String value) {
        return SpecialValuesReplace.replace(value, this.getResourceBundles(), this.currentScreen == null ? null : this.currentScreen.getScreenController(), this.globalProperties, this.locale);
    }

    @Nonnull
    public Clipboard getClipboard() {
        return this.clipboard;
    }

    public void setClipboard(@Nonnull Clipboard clipboard) {
        this.clipboard = clipboard;
    }

    @Nullable
    public RenderFont createFont(@Nonnull String name) {
        return this.getRenderEngine().createFont(name);
    }

    @Nonnull
    public String getFontname(@Nonnull RenderFont font) {
        return this.getRenderEngine().getFontname(font);
    }

    public void enableAutoScaling(int baseResolutionX, int baseResolutionY) {
        this.renderEngine.enableAutoScaling(baseResolutionX, baseResolutionY);
    }

    public void enableAutoScaling(int baseResolutionX, int baseResolutionY, float scaleX, float scaleY) {
        this.renderEngine.enableAutoScaling(baseResolutionX, baseResolutionY, scaleX, scaleY);
    }

    public void disableAutoScaling() {
        this.renderEngine.disableAutoScaling();
    }

    @Nullable
    public InputStream getResourceAsStream(@Nonnull String ref) {
        return this.resourceLoader.getResourceAsStream(ref);
    }

    @Nonnull
    public NiftyResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setIgnoreMouseEvents(boolean newValue) {
        this.ignoreMouseEvents = newValue;
    }

    public boolean isIgnoreMouseEvents() {
        return this.ignoreMouseEvents;
    }

    public void setIgnoreKeyboardEvents(boolean newValue) {
        this.ignoreKeyboardEvents = newValue;
    }

    public boolean isIgnoreKeyboardEvents() {
        return this.ignoreKeyboardEvents;
    }

    public NiftyInputConsumerNotify getNiftyInputConsumerNotify() {
        return this.niftyInputConsumerNotify;
    }

    public void setNiftyInputConsumerNotify(NiftyInputConsumerNotify newNotify) {
        this.niftyInputConsumerNotify = newNotify;
    }

    public void setAbsoluteClip(int x0, int y0, int x1, int y1) {
        this.renderEngine.setAbsoluteClip(x0, y0, x1, y1);
    }

    public void setAbsoluteClipRect(int x, int y, int width, int height) {
        this.setAbsoluteClip(x, y, x + width, y + height);
    }

    public void disableAbsoluteClip() {
        this.renderEngine.disableAbsoluteClip();
    }

    public void internalPopupRemoved(String id) {
        this.closedPopups.remove(id);
    }

    public void setNiftyMethodInvokerDebugEnabled(boolean debugEnabled) {
        this.niftyMethodInvokerDebugEnabled = debugEnabled;
    }

    public boolean isNiftyMethodInvokerDebugEnabled() {
        return this.niftyMethodInvokerDebugEnabled;
    }

    public static void setDefaultInputMappingType(@Nonnull Class<? extends NiftyInputMapping> defaultInputMappingType) {
        NiftyDefaults.setDefaultInputMapping(defaultInputMappingType);
    }

    private static class NiftyInputConsumerNotifyDefault
    implements NiftyInputConsumerNotify {
        private NiftyInputConsumerNotifyDefault() {
        }

        @Override
        public void processedMouseEvent(int mouseX, int mouseY, int mouseWheel, int button, boolean buttonDown, boolean processed) {
        }

        @Override
        public void processKeyboardEvent(KeyboardInputEvent keyEvent, boolean processed) {
        }
    }

    private class SubscriberRegistry {
        @Nonnull
        private final Map<Screen, Map<String, List<ClassSaveEventTopicSubscriber>>> screenBasedSubscribers = new HashMap<Screen, Map<String, List<ClassSaveEventTopicSubscriber>>>();

        private SubscriberRegistry() {
        }

        public void register(Screen screen, String elementId, ClassSaveEventTopicSubscriber subscriber) {
            List<ClassSaveEventTopicSubscriber> list;
            Map<String, List<ClassSaveEventTopicSubscriber>> elements = this.screenBasedSubscribers.get(screen);
            if (elements == null) {
                elements = new HashMap<String, List<ClassSaveEventTopicSubscriber>>();
                this.screenBasedSubscribers.put(screen, elements);
            }
            if ((list = elements.get(elementId)) == null) {
                list = new ArrayList<ClassSaveEventTopicSubscriber>();
                elements.put(elementId, list);
            }
            list.add(subscriber);
        }

        public void unsubscribeScreen(@Nonnull Screen screen) {
            Map<String, List<ClassSaveEventTopicSubscriber>> elements = this.screenBasedSubscribers.get(screen);
            if (elements != null && !elements.isEmpty()) {
                for (Map.Entry<String, List<ClassSaveEventTopicSubscriber>> entry : elements.entrySet()) {
                    List<ClassSaveEventTopicSubscriber> list = entry.getValue();
                    for (int i = 0; i < list.size(); ++i) {
                        ClassSaveEventTopicSubscriber subscriber = list.get(i);
                        Nifty.this.getEventService().unsubscribe(subscriber.getElementId(), (EventTopicSubscriber)subscriber);
                        log.fine("<- unsubscribe screen for [" + screen + "] [" + subscriber.getElementId() + "] -> [" + subscriber + "]");
                    }
                    list.clear();
                }
                elements.clear();
            }
            this.screenBasedSubscribers.remove(screen);
        }

        public void unsubscribeElement(@Nonnull Screen screen, @Nonnull String elementId) {
            List<ClassSaveEventTopicSubscriber> list;
            Map<String, List<ClassSaveEventTopicSubscriber>> elements = this.screenBasedSubscribers.get(screen);
            if (elements != null && !elements.isEmpty() && (list = elements.get(elementId)) != null && !list.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    ClassSaveEventTopicSubscriber subscriber = list.get(i);
                    Nifty.this.getEventService().unsubscribe(subscriber.getElementId(), (EventTopicSubscriber)subscriber);
                    log.fine("<- unsubscribe element [" + elementId + "] [" + subscriber.getElementId() + "] -> [" + subscriber + "]");
                }
                list.clear();
            }
        }
    }

    private static class ClassSaveEventTopicSubscriber
    implements EventTopicSubscriber,
    ProxySubscriber {
        @Nonnull
        private final String elementId;
        @Nullable
        private EventTopicSubscriber target;
        @Nonnull
        private final Class eventClass;

        private ClassSaveEventTopicSubscriber(@Nonnull String elementId, @Nullable EventTopicSubscriber target, @Nonnull Class eventClass) {
            this.elementId = elementId;
            this.target = target;
            this.eventClass = eventClass;
        }

        @Nonnull
        public String toString() {
            return super.toString() + "{" + this.elementId + "}{" + this.target + "}{" + this.eventClass + "}";
        }

        public void onEvent(String topic, Object data) {
            if (this.target != null && this.eventClass.isInstance(data)) {
                this.target.onEvent(topic, data);
            }
        }

        @Nonnull
        public String getElementId() {
            return this.elementId;
        }

        @Override
        @Nullable
        public Object getProxiedSubscriber() {
            return this.target;
        }

        @Override
        public void proxyUnsubscribed() {
            this.target = null;
        }

        @Override
        @Nonnull
        public ReferenceStrength getReferenceStrength() {
            return ReferenceStrength.STRONG;
        }
    }

    private class NiftyInputConsumerImpl
    implements NiftyInputConsumer {
        private boolean button0Down = false;
        private boolean button1Down = false;
        private boolean button2Down = false;

        private NiftyInputConsumerImpl() {
        }

        @Override
        public boolean processMouseEvent(int mouseX, int mouseY, int mouseWheel, int button, boolean buttonDown) {
            boolean processed = false;
            if (!Nifty.this.isIgnoreMouseEvents()) {
                processed = this.processEvent(this.createEvent(mouseX, mouseY, mouseWheel, button, buttonDown));
                if (log.isLoggable(Level.FINE)) {
                    log.fine("[processMouseEvent] [" + mouseX + ", " + mouseY + ", " + mouseWheel + ", " + button + ", " + buttonDown + "] processed [" + processed + "]");
                }
            }
            Nifty.this.niftyInputConsumerNotify.processedMouseEvent(mouseX, mouseY, mouseWheel, button, buttonDown, processed);
            return processed;
        }

        @Override
        public boolean processKeyboardEvent(@Nonnull KeyboardInputEvent keyEvent) {
            boolean processed = false;
            if (!Nifty.this.isIgnoreKeyboardEvents() && Nifty.this.currentScreen != null) {
                processed = Nifty.this.currentScreen.keyEvent(keyEvent);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("[processKeyboardEvent] " + keyEvent + " processed [" + processed + "]");
                }
            }
            Nifty.this.niftyInputConsumerNotify.processKeyboardEvent(keyEvent, processed);
            return processed;
        }

        void resetMouseDown() {
            this.button0Down = false;
            this.button1Down = false;
            this.button2Down = false;
        }

        @Nonnull
        private NiftyMouseInputEvent createEvent(int mouseX, int mouseY, int mouseWheel, int button, boolean buttonDown) {
            switch (button) {
                case 0: {
                    this.button0Down = buttonDown;
                    break;
                }
                case 1: {
                    this.button1Down = buttonDown;
                    break;
                }
                case 2: {
                    this.button2Down = buttonDown;
                }
            }
            NiftyMouseInputEvent result = new NiftyMouseInputEvent();
            result.initialize(Nifty.this.renderEngine.convertFromNativeX(mouseX), Nifty.this.renderEngine.convertFromNativeY(mouseY), mouseWheel, this.button0Down, this.button1Down, this.button2Down);
            return result;
        }

        private boolean processEvent(@Nonnull NiftyMouseInputEvent mouseInputEvent) {
            Nifty.this.mouseInputEventProcessor.process(mouseInputEvent);
            if (Nifty.this.currentScreen == null) {
                return false;
            }
            boolean handled = Nifty.this.forwardMouseEventToScreen(mouseInputEvent, Nifty.this.currentScreen);
            Nifty.this.handleDynamicElements();
            return handled;
        }
    }

    private static class DelayedMethodInvoke {
        @Nonnull
        private final NiftyDelayedMethodInvoke method;
        @Nonnull
        private final Object[] params;

        public DelayedMethodInvoke(@Nonnull NiftyDelayedMethodInvoke method, Object ... params) {
            this.method = method;
            this.params = params;
        }

        public void perform() {
            this.method.performInvoke(this.params);
        }
    }

    public class ClosePopUp {
        @Nonnull
        private final String removePopupId;
        @Nullable
        private final EndNotify closeNotify;

        public ClosePopUp(@Nullable String popupId, EndNotify closeNotifyParam) {
            this.removePopupId = popupId;
            this.closeNotify = closeNotifyParam;
        }

        public void close() {
            this.close(this.closeNotify);
        }

        public void forcedCloseWithoutEndNotify() {
            this.close(null);
        }

        private void close(@Nullable EndNotify endNotify) {
            Element popup;
            if (Nifty.this.currentScreen != null && (popup = (Element)Nifty.this.popups.get(this.removePopupId)) != null) {
                Nifty.this.currentScreen.closePopup(popup, endNotify);
            }
        }
    }
}

