/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.tutorial.screen;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.DropDown;
import de.lessvoid.nifty.controls.FocusHandler;
import de.lessvoid.nifty.controls.ListBox;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.input.NiftyStandardInputEvent;
import de.lessvoid.nifty.screen.Screen;
import javax.annotation.Nonnull;

public class PageControl
implements Controller {
    private Element element;
    private FocusHandler focusHandler;
    private Screen screen;

    public void bind(@Nonnull Nifty nifty, @Nonnull Screen screenParam, @Nonnull Element newElement, @Nonnull Parameters parameter) {
        this.element = newElement;
        this.screen = screenParam;
    }

    public void init(@Nonnull Parameters parameter) {
        DropDown dropDown = (DropDown)this.screen.findNiftyControl("dropDownControl", DropDown.class);
        dropDown.addItem((Object)"a");
        dropDown.addItem((Object)"b");
        dropDown.addItem((Object)"c");
        ListBox listBox = (ListBox)this.screen.findNiftyControl("listBox", ListBox.class);
        listBox.addItem((Object)"a");
        listBox.addItem((Object)"b");
        listBox.addItem((Object)"c");
        listBox.addItem((Object)"d");
        listBox.addItem((Object)"e");
        listBox.addItem((Object)"f");
    }

    public void onStartScreen() {
        this.focusHandler = this.screen.getFocusHandler();
    }

    public void onFocus(boolean getFocus) {
    }

    public boolean inputEvent(@Nonnull NiftyInputEvent inputEvent) {
        Element prevElement;
        if (inputEvent == NiftyStandardInputEvent.NextInputElement) {
            this.focusHandler.getNext(this.element).setFocus();
            return true;
        }
        if (inputEvent == NiftyStandardInputEvent.PrevInputElement) {
            this.focusHandler.getPrev(this.element).setFocus();
            return true;
        }
        if (inputEvent == NiftyStandardInputEvent.Activate) {
            this.element.onClickAndReleasePrimaryMouseButton();
            return true;
        }
        if (inputEvent == NiftyStandardInputEvent.MoveCursorDown) {
            Element nextElement;
            if (this.focusHandler != null && (nextElement = this.focusHandler.getNext(this.element)).getParent().equals(this.element.getParent())) {
                nextElement.setFocus();
                return true;
            }
        } else if (inputEvent == NiftyStandardInputEvent.MoveCursorUp && this.focusHandler != null && (prevElement = this.focusHandler.getPrev(this.element)).getParent().equals(this.element.getParent())) {
            prevElement.setFocus();
            return true;
        }
        return false;
    }

    public void onEndScreen() {
    }
}

