/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.window;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.controls.Window;
import de.lessvoid.nifty.controls.WindowClosedEvent;
import de.lessvoid.nifty.controls.dragndrop.DraggableControl;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Deprecated
public class WindowControl
extends AbstractController
implements Window {
    @Nonnull
    private static final Logger log = Logger.getLogger(WindowControl.class.getName());
    @Nonnull
    private final DraggableControl draggableControl = new DraggableControl();
    @Nullable
    private Nifty nifty;
    private boolean removeCloseButton;
    private boolean hideOnClose;

    public void bind(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element element, @Nonnull Parameters parameter) {
        Element closeButton;
        Element title;
        super.bind(element);
        this.nifty = nifty;
        this.draggableControl.bind(nifty, screen, element, parameter);
        this.removeCloseButton = !parameter.getAsBoolean("closeable", true);
        this.hideOnClose = parameter.getAsBoolean("hideOnClose", false);
        Element content = this.getContent();
        if (content == null) {
            log.severe("Content element of window not found. Window will not display properly.");
        }
        if ((title = this.getTitleElement()) == null) {
            log.severe("Title element of window not found. Window will not display its head properly.");
        }
        if ((closeButton = this.getCloseButton()) == null) {
            log.severe("Close button of window not found. Window will not offer a control to close the window.");
        }
    }

    public void onStartScreen() {
        Element closeButton;
        this.draggableControl.onStartScreen();
        if (this.removeCloseButton && (closeButton = this.getCloseButton()) != null) {
            closeButton.markForRemoval();
        }
    }

    public boolean inputEvent(@Nonnull NiftyInputEvent inputEvent) {
        return this.draggableControl.inputEvent(inputEvent);
    }

    public void onFocus(boolean getFocus) {
        super.onFocus(getFocus);
        this.draggableControl.onFocus(getFocus);
    }

    public void bringToFront() {
        this.draggableControl.bringToFront();
    }

    public void drag(int mouseX, int mouseY) {
        this.draggableControl.drag(mouseX, mouseY);
    }

    public void dragStop() {
        this.draggableControl.dragStop();
    }

    @Nullable
    private Element getTitleElement() {
        Element element = this.getElement();
        if (element == null) {
            return null;
        }
        return element.findElementById("#window-title");
    }

    @Nullable
    private Element getCloseButton() {
        Element element = this.getElement();
        if (element == null) {
            return null;
        }
        return element.findElementById("#window-close-button");
    }

    @Nullable
    public Element getContent() {
        Element element = this.getElement();
        if (element == null) {
            return null;
        }
        return element.findElementById("#window-content");
    }

    @Override
    @Nullable
    public String getTitle() {
        Element title = this.getTitleElement();
        if (title == null) {
            return null;
        }
        TextRenderer renderer = (TextRenderer)title.getRenderer(TextRenderer.class);
        if (renderer == null) {
            return null;
        }
        return renderer.getOriginalText();
    }

    @Override
    public void setTitle(@Nonnull String title) {
        Element titleElement = this.getTitleElement();
        if (titleElement == null) {
            return;
        }
        TextRenderer renderer = (TextRenderer)titleElement.getRenderer(TextRenderer.class);
        if (renderer == null) {
            return;
        }
        renderer.setText(title);
    }

    @Override
    public void closeWindow() {
        Element element;
        if (this.nifty != null && (element = this.getElement()) != null) {
            if (this.hideOnClose) {
                element.hide((EndNotify)new CloseEndNotify(this.nifty, this, element, true));
            } else {
                element.markForRemoval((EndNotify)new CloseEndNotify(this.nifty, this, element, false));
            }
        }
    }

    @Override
    public void moveToFront() {
        this.draggableControl.moveToFront();
    }

    private static class CloseEndNotify
    implements EndNotify {
        @Nonnull
        private final Nifty nifty;
        @Nonnull
        private final Window window;
        @Nonnull
        private final Element element;
        private final boolean hidden;

        public CloseEndNotify(@Nonnull Nifty nifty, @Nonnull Window window, @Nonnull Element element, boolean hidden) {
            this.nifty = nifty;
            this.window = window;
            this.element = element;
            this.hidden = hidden;
        }

        public void perform() {
            String id = this.element.getId();
            if (id != null) {
                this.nifty.publishEvent(this.element.getId(), (NiftyEvent)new WindowClosedEvent(this.window, this.hidden));
            }
        }
    }
}

