/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.treebox;

import de.lessvoid.nifty.builder.ElementBuilder;
import de.lessvoid.nifty.controls.Label;
import de.lessvoid.nifty.controls.ListBox;
import de.lessvoid.nifty.controls.TreeItem;
import de.lessvoid.nifty.controls.label.builder.LabelBuilder;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.spi.render.RenderFont;
import de.lessvoid.nifty.tools.SizeValue;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class TreeBoxViewConverter<T>
implements ListBox.ListBoxViewConverter<TreeItem<T>> {
    @Nonnull
    private static final Logger log = Logger.getLogger(TreeBoxViewConverter.class.getName());

    @Override
    public void display(@Nonnull Element element, @Nonnull TreeItem<T> item) {
        Element spacer = element.findElementById("#tree-item-spacer");
        if (spacer == null) {
            log.warning("Spacing area used for indenting of the tree was not found. Looked for: #tree-item-spacer");
        } else {
            spacer.setConstraintWidth(SizeValue.px((int)item.getIndent()));
            spacer.setConstraintHeight(SizeValue.px((int)1));
            spacer.setVisible(item.getIndent() > 0);
        }
        Element icon = element.findElementById("#tree-item-icon");
        if (icon == null) {
            log.warning("Icon area for the tree was not found. Looked for: #tree-item-icon");
        } else if (item.isLeaf()) {
            icon.setStyle(element.getStyle() + "#leaf");
        } else if (item.isExpanded()) {
            icon.setStyle(element.getStyle() + "#opened");
        } else {
            icon.setStyle(element.getStyle() + "#closed");
        }
        Element text = element.findElementById("#tree-item-content");
        if (text == null) {
            log.warning("Content area of tree node couldn't be found. Looked for: #tree-item-content");
        } else {
            Label displayLabel = (Label)text.findNiftyControl("#label", Label.class);
            if (displayLabel == null) {
                Screen screen = text.getNifty().getCurrentScreen();
                if (screen == null) {
                    log.warning("Can't create content label while there is no active screen.");
                } else {
                    LabelBuilder builder = new LabelBuilder(text.getId() + "#label");
                    builder.text(String.valueOf(item.getValue()));
                    builder.textHAlign(ElementBuilder.Align.Left);
                    builder.width(SizeValue.wildcard());
                    builder.build(text.getNifty(), screen, text);
                }
            } else {
                displayLabel.setText(String.valueOf(item.getValue()));
            }
        }
        element.layoutElements();
    }

    @Override
    public int getWidth(@Nonnull Element element, @Nonnull TreeItem<T> item) {
        RenderFont font;
        TextRenderer textRenderer;
        Element displayLabelElement;
        Label displayLabel;
        Element text;
        int width = item.getIndent();
        Element icon = element.findElementById("#tree-item-icon");
        if (icon != null) {
            width += icon.getWidth();
        }
        if ((text = element.findElementById("#tree-item-content")) != null && (displayLabel = (Label)text.findNiftyControl("#label", Label.class)) != null && (displayLabelElement = displayLabel.getElement()) != null && (textRenderer = (TextRenderer)displayLabelElement.getRenderer(TextRenderer.class)) != null && (font = textRenderer.getFont()) != null) {
            width += font.getWidth(String.valueOf(item.getValue()));
        }
        return width;
    }
}

