/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.treebox;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.ListBox;
import de.lessvoid.nifty.controls.ListBoxSelectionChangedEvent;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.controls.TreeBox;
import de.lessvoid.nifty.controls.TreeItem;
import de.lessvoid.nifty.controls.TreeItemSelectionChangedEvent;
import de.lessvoid.nifty.controls.listbox.ListBoxControl;
import de.lessvoid.nifty.controls.listbox.ListBoxItemProcessor;
import de.lessvoid.nifty.controls.treebox.TreeBoxItemController;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Deprecated
public final class TreeBoxControl<T>
extends ListBoxControl<TreeItem<T>>
implements TreeBox<T> {
    @Nonnull
    private static final Logger log = Logger.getLogger(TreeBoxControl.class.getName());
    private static final int DEFAULT_INDENT = 15;
    private int indentWidth;
    @Nullable
    private TreeItem<T> treeRoot;
    @Nullable
    private Nifty nifty;

    public TreeBoxControl() {
        this.getListBox().addItemProcessor(new ListBoxItemProcessor(){

            @Override
            public void processElement(@Nonnull Element element) {
                TreeBoxItemController listBoxItemController = (TreeBoxItemController)element.getControl(TreeBoxItemController.class);
                if (listBoxItemController != null) {
                    listBoxItemController.setParentControl(TreeBoxControl.this);
                }
            }
        });
    }

    @Override
    public void bind(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element element, @Nonnull Parameters parameter) {
        super.bind(nifty, screen, element, parameter);
        this.nifty = nifty;
        this.indentWidth = parameter.getAsInteger("indentWidth", 15);
    }

    @Override
    public boolean inputEvent(@Nonnull NiftyInputEvent inputEvent) {
        super.inputEvent(inputEvent);
        return true;
    }

    @Override
    public void setTree(@Nonnull TreeItem<T> treeRoot) {
        this.treeRoot = treeRoot;
        this.updateList();
    }

    @Nonnull
    private ListBox<TreeItem<T>> getListBox() {
        return this;
    }

    public void updateList(@Nonnull TreeItem<T> selectItem) {
        this.updateList();
        this.selectItem(selectItem);
    }

    private void updateList() {
        if (this.treeRoot == null) {
            log.warning("Update of list triggered while root not is not set.");
            return;
        }
        ListBox<TreeItem<T>> list = this.getListBox();
        list.clear();
        for (TreeItem<T> item : this.treeRoot) {
            this.addListItem(list, item, 0);
        }
    }

    @Override
    public void publish(@Nonnull ListBoxSelectionChangedEvent<TreeItem<T>> event) {
        String id;
        if (this.nifty != null && (id = this.getId()) != null) {
            this.nifty.publishEvent(id, new TreeItemSelectionChangedEvent<T>(this, event));
        }
    }

    private void addListItem(@Nonnull ListBox<TreeItem<T>> list, @Nonnull TreeItem<T> currentItem, int currentIndent) {
        list.addItem(currentItem);
        currentItem.setIndent(currentIndent);
        if (currentItem.isExpanded()) {
            for (TreeItem<T> item : currentItem) {
                this.addListItem(list, item, currentIndent + this.indentWidth);
            }
        }
    }
}

