/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.slider;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.NextPrevHelper;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.controls.Slider;
import de.lessvoid.nifty.controls.SliderChangedEvent;
import de.lessvoid.nifty.controls.slider.SliderImpl;
import de.lessvoid.nifty.controls.slider.SliderView;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.input.NiftyMouseInputEvent;
import de.lessvoid.nifty.input.NiftyStandardInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.SizeValue;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Deprecated
public class SliderControl
extends AbstractController
implements Slider {
    @Nonnull
    private static final Logger log = Logger.getLogger(SliderControl.class.getName());
    @Nonnull
    private final SliderImpl sliderImpl = new SliderImpl();
    @Nullable
    private SliderView sliderView;
    @Nullable
    private Element elementPosition;
    @Nullable
    private Element elementBackground;
    @Nullable
    private NextPrevHelper nextPrevHelper;

    public void bind(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element element, @Nonnull Parameters parameter) {
        this.bind(element);
        this.elementBackground = element.findElementById("#background");
        this.elementPosition = element.findElementById("#position");
        this.nextPrevHelper = new NextPrevHelper(element, screen.getFocusHandler());
        if (this.elementBackground == null) {
            log.severe("Background element of slider not found. Slider will not work properly. Looked for: #background");
        }
        if (this.elementPosition == null) {
            log.severe("Position element of slider not found. Slider will not work properly. Looked for: #position");
        } else if (this.elementBackground != null) {
            this.sliderView = "verticalSlider".equals(parameter.get("name")) ? new SliderViewVertical(nifty, this, this.elementBackground, this.elementPosition) : new SliderViewHorizontal(nifty, this, this.elementBackground, this.elementPosition);
        }
        float min = parameter.getAsFloat("min", 0.0f);
        float max = parameter.getAsFloat("max", 100.0f);
        float initial = parameter.getAsFloat("initial", 0.0f);
        float stepSize = parameter.getAsFloat("stepSize", 1.0f);
        float buttonStepSize = parameter.getAsFloat("buttonStepSize", 25.0f);
        this.sliderImpl.bindToView(this.sliderView, min, max, stepSize, buttonStepSize);
        this.sliderImpl.setValue(initial);
    }

    public void onStartScreen() {
    }

    public void layoutCallback() {
        this.sliderImpl.updateView();
    }

    public boolean inputEvent(@Nonnull NiftyInputEvent inputEvent) {
        if (this.nextPrevHelper != null && this.nextPrevHelper.handleNextPrev(inputEvent)) {
            return true;
        }
        if (inputEvent == NiftyStandardInputEvent.MoveCursorUp || inputEvent == NiftyStandardInputEvent.MoveCursorLeft) {
            this.sliderImpl.stepDown();
            return true;
        }
        if (inputEvent == NiftyStandardInputEvent.MoveCursorDown || inputEvent == NiftyStandardInputEvent.MoveCursorRight) {
            this.sliderImpl.stepUp();
            return true;
        }
        return false;
    }

    public void upClick() {
        this.sliderImpl.stepDown();
    }

    public void downClick() {
        this.sliderImpl.stepUp();
    }

    public void mouseClick(int mouseX, int mouseY) {
        if (this.elementBackground != null && this.elementPosition != null) {
            this.sliderImpl.setValueFromPosition(mouseX - this.elementBackground.getX() - this.elementPosition.getWidth() / 2, mouseY - this.elementBackground.getY() - this.elementPosition.getHeight() / 2);
        }
    }

    public void mouseWheel(Element element, @Nonnull NiftyMouseInputEvent inputEvent) {
        int mouseWheel = inputEvent.getMouseWheel();
        float currentValue = this.sliderImpl.getValue();
        if (mouseWheel < 0) {
            this.sliderImpl.setValue(currentValue - this.sliderImpl.getButtonStepSize() * (float)mouseWheel);
        } else if (mouseWheel > 0) {
            this.sliderImpl.setValue(currentValue - this.sliderImpl.getButtonStepSize() * (float)mouseWheel);
        }
    }

    @Override
    public void setValue(float value) {
        this.sliderImpl.setValue(value);
    }

    @Override
    public float getValue() {
        return this.sliderImpl.getValue();
    }

    @Override
    public void setMin(float min) {
        this.sliderImpl.setMin(min);
    }

    @Override
    public float getMin() {
        return this.sliderImpl.getMin();
    }

    @Override
    public void setMax(float max) {
        this.sliderImpl.setMax(max);
    }

    @Override
    public float getMax() {
        return this.sliderImpl.getMax();
    }

    @Override
    public void setStepSize(float stepSize) {
        this.sliderImpl.setStepSize(stepSize);
    }

    @Override
    public float getStepSize() {
        return this.sliderImpl.getStepSize();
    }

    @Override
    public void setButtonStepSize(float buttonStepSize) {
        this.sliderImpl.setButtonStepSize(buttonStepSize);
    }

    @Override
    public float getButtonStepSize() {
        return this.sliderImpl.getButtonStepSize();
    }

    @Override
    public void setup(float min, float max, float current, float stepSize, float buttonStepSize) {
        this.sliderImpl.setup(min, max, current, stepSize, buttonStepSize);
    }

    private static class SliderViewHorizontal
    implements SliderView {
        @Nonnull
        private final Nifty nifty;
        @Nonnull
        private final SliderControl slider;
        @Nonnull
        private final Element elementBackground;
        @Nonnull
        private final Element elementPosition;

        public SliderViewHorizontal(@Nonnull Nifty nifty, @Nonnull SliderControl slider, @Nonnull Element elementBackground, @Nonnull Element elementPosition) {
            this.nifty = nifty;
            this.slider = slider;
            this.elementBackground = elementBackground;
            this.elementPosition = elementPosition;
        }

        @Override
        public int getSize() {
            return this.elementBackground.getWidth() - this.elementPosition.getWidth();
        }

        @Override
        public void update(int position) {
            this.elementPosition.setConstraintX(SizeValue.px((int)position));
            this.elementBackground.layoutElements();
        }

        @Override
        public int filter(int pixelX, int pixelY) {
            return pixelX;
        }

        @Override
        public void valueChanged(float value) {
            String id = this.slider.getId();
            if (id != null) {
                this.nifty.publishEvent(id, (NiftyEvent)new SliderChangedEvent(this.slider, value));
            }
        }
    }

    private static class SliderViewVertical
    implements SliderView {
        @Nonnull
        private final Nifty nifty;
        @Nonnull
        private final SliderControl slider;
        @Nonnull
        private final Element elementBackground;
        @Nonnull
        private final Element elementPosition;

        public SliderViewVertical(@Nonnull Nifty nifty, @Nonnull SliderControl slider, @Nonnull Element elementBackground, @Nonnull Element elementPosition) {
            this.nifty = nifty;
            this.slider = slider;
            this.elementBackground = elementBackground;
            this.elementPosition = elementPosition;
        }

        @Override
        public int getSize() {
            return this.elementBackground.getHeight() - this.elementPosition.getHeight();
        }

        @Override
        public void update(int position) {
            this.elementPosition.setConstraintY(SizeValue.px((int)position));
            this.elementBackground.layoutElements();
        }

        @Override
        public int filter(int pixelX, int pixelY) {
            return pixelY;
        }

        @Override
        public void valueChanged(float value) {
            String id = this.slider.getId();
            if (id != null) {
                this.nifty.publishEvent(id, (NiftyEvent)new SliderChangedEvent(this.slider, value));
            }
        }
    }
}

