/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.radiobutton;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.controls.RadioButtonGroup;
import de.lessvoid.nifty.controls.RadioButtonGroupStateChangedEvent;
import de.lessvoid.nifty.controls.radiobutton.RadioButtonControl;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.events.ElementDisableEvent;
import de.lessvoid.nifty.elements.events.ElementEnableEvent;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bushe.swing.event.EventTopicSubscriber;

@Deprecated
public class RadioButtonGroupControl
extends AbstractController
implements RadioButtonGroup {
    @Nonnull
    private static final Logger log = Logger.getLogger(RadioButtonGroupControl.class.getName());
    @Nullable
    private Nifty nifty;
    @Nullable
    private Screen screen;
    @Nullable
    private RadioButtonControl activeButton;
    @Nonnull
    private final List<RadioButtonControl> registeredRadioButtons = new ArrayList<RadioButtonControl>();
    private boolean allowDeselection = false;

    public void bind(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element element, @Nonnull Parameters parameter) {
        this.bind(element);
        this.nifty = nifty;
        this.screen = screen;
        this.allowDeselection = parameter.getAsBoolean("allowDeselection", false);
    }

    public void onStartScreen() {
        if (this.nifty == null || this.screen == null) {
            log.severe("Can't subscribe to the required events while the control is not bound.");
            return;
        }
        String id = this.getId();
        if (id == null) {
            log.warning("Radio group has no id, functionality will be severely limited.");
            return;
        }
        this.nifty.subscribe(this.screen, id, ElementDisableEvent.class, (EventTopicSubscriber)new EventTopicSubscriber<ElementDisableEvent>(){

            public void onEvent(String topic, ElementDisableEvent disableEvent) {
                RadioButtonGroupControl.this.enableAllRadioButtons(false);
            }
        });
        this.nifty.subscribe(this.screen, id, ElementEnableEvent.class, (EventTopicSubscriber)new EventTopicSubscriber<ElementEnableEvent>(){

            public void onEvent(String topic, ElementEnableEvent disableEvent) {
                RadioButtonGroupControl.this.enableAllRadioButtons(true);
            }
        });
        this.nifty.publishEvent(id, (NiftyEvent)new RadioButtonGroupStateChangedEvent(this.activeButton, null));
    }

    public boolean inputEvent(@Nonnull NiftyInputEvent inputEvent) {
        return false;
    }

    public void registerRadioButton(@Nonnull RadioButtonControl radioButtonControl) {
        this.registeredRadioButtons.add(radioButtonControl);
        if (this.activeButton == null) {
            this.onRadioButtonClick(this.registeredRadioButtons.get(0));
        }
    }

    public void onRadioButtonClick(@Nonnull RadioButtonControl clickedRadioButton) {
        if (this.activeButton == clickedRadioButton) {
            if (!this.allowDeselection) {
                return;
            }
            clickedRadioButton.deactivate();
            String id = this.getId();
            if (id != null && this.nifty != null) {
                this.nifty.publishEvent(id, (NiftyEvent)new RadioButtonGroupStateChangedEvent(null, this.activeButton));
            }
            this.activeButton = null;
            return;
        }
        if (this.activeButton != null) {
            this.activeButton.deactivate();
        }
        clickedRadioButton.activate();
        String id = this.getId();
        if (id != null && this.nifty != null) {
            this.nifty.publishEvent(id, (NiftyEvent)new RadioButtonGroupStateChangedEvent(clickedRadioButton, this.activeButton));
        }
        this.activeButton = clickedRadioButton;
    }

    @Override
    public void allowDeselection(boolean allowDeselection) {
        this.allowDeselection = allowDeselection;
        if (!allowDeselection && !this.registeredRadioButtons.isEmpty()) {
            this.onRadioButtonClick(this.registeredRadioButtons.get(0));
        }
    }

    private void enableAllRadioButtons(boolean enabled) {
        for (int i = 0; i < this.registeredRadioButtons.size(); ++i) {
            this.registeredRadioButtons.get(i).setEnabled(enabled);
        }
    }
}

