/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.listbox;

import de.lessvoid.nifty.controls.listbox.ListBoxSelectionMode;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class ListBoxSelectionModeSingle<T>
implements ListBoxSelectionMode<T> {
    @Nullable
    private T selection;
    private boolean requiresSelection = false;

    ListBoxSelectionModeSingle() {
    }

    @Override
    public void clear() {
        this.selection = null;
    }

    @Override
    @Nonnull
    public List<T> getSelection() {
        if (this.selection == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.selection);
    }

    @Override
    public void remove(@Nonnull T item) {
        if (this.requiresSelection) {
            return;
        }
        this.removeForced(item);
    }

    @Override
    public void removeForced(@Nonnull T item) {
        if (item.equals(this.selection)) {
            this.selection = null;
        }
    }

    @Override
    public void add(@Nonnull T item) {
        this.selection = item;
    }

    @Override
    public void enableRequiresSelection(boolean enable) {
        this.requiresSelection = enable;
    }

    @Override
    public boolean requiresAutoSelection() {
        return this.requiresSelection && this.selection == null;
    }
}

