/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.listbox;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.FocusHandler;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.controls.listbox.ListBoxImpl;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.input.NiftyStandardInputEvent;
import de.lessvoid.nifty.screen.Screen;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ListBoxPanel<T>
extends AbstractController {
    @Nullable
    private FocusHandler focusHandler;
    @Nullable
    private ListBoxImpl<T> listBox;
    private boolean hasFocus = false;

    public void bind(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element element, @Nonnull Parameters parameter) {
        this.bind(element);
        this.focusHandler = screen.getFocusHandler();
    }

    public void onStartScreen() {
    }

    public boolean inputEvent(@Nonnull NiftyInputEvent inputEvent) {
        Element element = this.getElement();
        if (inputEvent == NiftyStandardInputEvent.NextInputElement) {
            if (this.focusHandler != null && element != null) {
                Element nextElement = this.focusHandler.getNext(element);
                nextElement.setFocus();
                return true;
            }
        } else if (inputEvent == NiftyStandardInputEvent.PrevInputElement) {
            if (this.focusHandler != null && element != null) {
                Element prevElement = this.focusHandler.getPrev(element);
                prevElement.setFocus();
                return true;
            }
        } else if (inputEvent == NiftyStandardInputEvent.MoveCursorDown) {
            if (this.hasElements()) {
                assert (this.listBox != null);
                int focusItemIndex = this.listBox.getFocusItemIndex();
                if (focusItemIndex < this.listBox.itemCount() - 1) {
                    this.listBox.setFocusItemByIndex(focusItemIndex + 1);
                    return true;
                }
            }
        } else if (inputEvent == NiftyStandardInputEvent.MoveCursorUp) {
            if (this.hasElements()) {
                assert (this.listBox != null);
                int focusItemIndex = this.listBox.getFocusItemIndex();
                if (focusItemIndex > 0) {
                    this.listBox.setFocusItemByIndex(focusItemIndex - 1);
                    return true;
                }
            }
        } else if (inputEvent == NiftyStandardInputEvent.Activate && this.hasElements()) {
            assert (this.listBox != null);
            int focusItemIndex = this.listBox.getFocusItemIndex();
            if (focusItemIndex >= 0) {
                if (this.listBox.getSelection().contains(this.listBox.getFocusItem())) {
                    this.listBox.deselectItemByIndex(focusItemIndex);
                } else {
                    this.listBox.selectItemByIndex(focusItemIndex);
                }
            }
        }
        return false;
    }

    private boolean hasElements() {
        return this.listBox != null && this.listBox.itemCount() > 0;
    }

    public void onFocus(boolean getFocus) {
        super.onFocus(getFocus);
        this.hasFocus = getFocus;
        if (this.listBox != null) {
            this.listBox.updateView();
        }
    }

    public void setListBox(@Nullable ListBoxImpl<T> listBox) {
        this.listBox = listBox;
    }

    public boolean hasFocus() {
        return this.hasFocus;
    }
}

