/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.listbox;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.controls.listbox.ListBoxImpl;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ListBoxItemController<T>
extends AbstractController {
    @Nullable
    private ListBoxImpl<T> listBox;
    private int visualItemIndex;
    @Nullable
    private Nifty nifty;
    @Nullable
    private Screen screen;

    public void bind(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element element, @Nonnull Parameters properties) {
        this.bind(element);
        this.nifty = nifty;
        this.screen = screen;
    }

    public void onStartScreen() {
    }

    public void onFocus(boolean getFocus) {
        super.onFocus(getFocus);
    }

    public boolean inputEvent(@Nonnull NiftyInputEvent inputEvent) {
        return false;
    }

    @Nullable
    protected ListBoxImpl<T> getListBox() {
        return this.listBox;
    }

    protected int getVisualItemIndex() {
        return this.visualItemIndex;
    }

    @Nullable
    protected Nifty getNifty() {
        return this.nifty;
    }

    @Nullable
    protected Screen getScreen() {
        return this.screen;
    }

    public void listBoxItemClicked() {
        if (this.listBox != null) {
            T item = this.getItem();
            this.listBox.setFocusItem(item);
            if (this.listBox.getSelection().contains(item)) {
                this.listBox.deselectItemByVisualIndex(this.visualItemIndex);
            } else {
                this.listBox.selectItemByVisualIndex(this.visualItemIndex);
            }
        }
    }

    @Nullable
    protected T getItem() {
        if (this.listBox == null) {
            return null;
        }
        return this.listBox.getItemByVisualIndex(this.visualItemIndex);
    }

    public void setListBox(@Nullable ListBoxImpl<T> listBox) {
        this.listBox = listBox;
    }

    public void setItemIndex(int visualItemIndex) {
        this.visualItemIndex = visualItemIndex;
    }
}

