/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.listbox;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyIdCreator;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.ListBox;
import de.lessvoid.nifty.controls.ListBoxSelectionChangedEvent;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.controls.Scrollbar;
import de.lessvoid.nifty.controls.ScrollbarChangedEvent;
import de.lessvoid.nifty.controls.listbox.ListBoxImpl;
import de.lessvoid.nifty.controls.listbox.ListBoxItemController;
import de.lessvoid.nifty.controls.listbox.ListBoxItemProcessor;
import de.lessvoid.nifty.controls.listbox.ListBoxPanel;
import de.lessvoid.nifty.controls.listbox.ListBoxView;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.events.ElementShowEvent;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.input.NiftyMouseInputEvent;
import de.lessvoid.nifty.loaderv2.types.ElementType;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.SizeValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bushe.swing.event.EventTopicSubscriber;

@Deprecated
public class ListBoxControl<T>
extends AbstractController
implements ListBox<T>,
ListBoxView<T> {
    @Nonnull
    private final Logger log = Logger.getLogger(ListBoxControl.class.getName());
    @Nonnull
    private final ListBoxImpl<T> listBoxImpl;
    @Nullable
    private Element[] labelElements;
    @Nullable
    private Nifty nifty;
    @Nullable
    private Screen screen;
    @Nonnull
    private ScrollbarMode verticalScrollbarMode;
    @Nullable
    private ElementType verticalScrollbarTemplate;
    @Nullable
    private Scrollbar verticalScrollbar;
    private boolean verticalScrollbarState;
    @Nullable
    private Element scrollElement;
    @Nonnull
    private ScrollbarMode horizontalScrollbarMode;
    @Nullable
    private ElementType horizontalScrollbarTemplate;
    @Nullable
    private Scrollbar horizontalScrollbar;
    private boolean horizontalScrollbarState;
    @Nullable
    private Element childRootElement;
    @Nullable
    private ElementType labelTemplateElementType;
    @Nullable
    private Element listBoxPanelElement;
    @Nullable
    private ElementType bottomRightTemplate;
    private int labelTemplateHeight;
    private int displayItems;
    @Nullable
    private ListBox.ListBoxViewConverter<T> viewConverter;
    @Nonnull
    private final EventTopicSubscriber<ScrollbarChangedEvent> verticalScrollbarSubscriber = new EventTopicSubscriber<ScrollbarChangedEvent>(){

        public void onEvent(String id, @Nonnull ScrollbarChangedEvent event) {
            ListBoxControl.this.listBoxImpl.updateView((int)(event.getValue() / (float)ListBoxControl.this.labelTemplateHeight));
        }
    };
    @Nonnull
    private final EventTopicSubscriber<ScrollbarChangedEvent> horizontalScrollbarSubscriber = new EventTopicSubscriber<ScrollbarChangedEvent>(){

        public void onEvent(String id, @Nonnull ScrollbarChangedEvent event) {
            if (ListBoxControl.this.childRootElement != null) {
                ListBoxControl.this.childRootElement.setConstraintX(SizeValue.px((int)(-((int)event.getValue()))));
                ListBoxControl.this.childRootElement.getParent().layoutElements();
            }
        }
    };
    @Nonnull
    private final EventTopicSubscriber<ElementShowEvent> listBoxControlShowEventSubscriber = new EventTopicSubscriber<ElementShowEvent>(){

        public void onEvent(String id, ElementShowEvent event) {
            ListBoxControl.this.listBoxImpl.updateView();
        }
    };
    private int lastMaxWidth;
    private int applyWidthConstraintsLastWidth = -1;
    @Nonnull
    private final List<ListBoxItemProcessor> itemProcessors;

    public ListBoxControl() {
        this.listBoxImpl = new ListBoxImpl(this);
        this.itemProcessors = new ArrayList<ListBoxItemProcessor>();
        this.itemProcessors.add(new ListBoxItemProcessor(){

            @Override
            public void processElement(@Nonnull Element element) {
                ListBoxItemController listBoxItemController = (ListBoxItemController)element.getControl(ListBoxItemController.class);
                if (listBoxItemController != null) {
                    listBoxItemController.setListBox(ListBoxControl.this.listBoxImpl);
                }
            }
        });
        this.horizontalScrollbarMode = ScrollbarMode.on;
        this.verticalScrollbarMode = ScrollbarMode.on;
    }

    public void bind(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element element, @Nonnull Parameters parameter) {
        this.bind(element);
        this.nifty = nifty;
        this.screen = screen;
        String viewConverterClass = parameter.get("viewConverterClass");
        this.viewConverter = viewConverterClass == null ? new ListBox.ListBoxViewConverterSimple() : this.createViewConverter(viewConverterClass);
        this.verticalScrollbarState = true;
        Element verticalScrollbar = this.getVerticalScrollbarElement();
        if (verticalScrollbar == null) {
            this.log.severe("Failed to locate vertical scrollbar. Scrollbar disabled. Looked for: #vertical-scrollbar");
            this.verticalScrollbarMode = ScrollbarMode.off;
            this.verticalScrollbarState = false;
        } else {
            this.verticalScrollbarMode = (ScrollbarMode)parameter.getAsEnum("vertical", ScrollbarMode.class, (Enum)ScrollbarMode.on);
            this.verticalScrollbarTemplate = verticalScrollbar.getElementType();
        }
        this.horizontalScrollbarState = true;
        Element horizontalScrollbarParent = this.getHorizontalScrollbarParentElement();
        if (horizontalScrollbarParent == null) {
            this.log.severe("Failed to locate horizontal scrollbar. Scrollbar disabled. Looked for: #horizontal-scrollbar-parent");
            this.horizontalScrollbarMode = ScrollbarMode.off;
            this.horizontalScrollbarState = false;
        } else {
            this.horizontalScrollbarMode = (ScrollbarMode)parameter.getAsEnum("horizontal", ScrollbarMode.class, (Enum)ScrollbarMode.on);
            this.horizontalScrollbarTemplate = horizontalScrollbarParent.getElementType();
        }
        Element bottomRight = this.getChildElement(horizontalScrollbarParent, "#bottom-right");
        this.scrollElement = this.getChildElement("#scrollpanel");
        if (bottomRight == null) {
            this.log.severe("Failed to locate bottom right spacer. Scrollbars will not display properly. Looked for: #bottom-right");
        } else {
            this.bottomRightTemplate = bottomRight.getElementType();
        }
        if (this.scrollElement == null) {
            this.log.severe("Failed to locate scroll panel. Scrolling will not work properly. Looked for: #scrollpanel");
        }
        this.displayItems = parameter.getAsInteger("displayItems", 2);
        if (this.displayItems < 1) {
            this.log.warning(this.displayItems + " items to display?! Really? Falling back to 2.");
            this.displayItems = 2;
        }
        this.applyWidthConstraintsLastWidth = -1;
        this.childRootElement = this.getChildElement("#child-root");
        if (this.childRootElement == null) {
            this.log.severe("Failed to locate child root element. Displaying will not work properly. Looked for: #child-root");
        } else if (!this.childRootElement.getChildren().isEmpty()) {
            Element templateElement = (Element)this.childRootElement.getChildren().get(0);
            this.childRootElement.layoutElements();
            this.labelTemplateHeight = templateElement.getHeight();
            this.labelTemplateElementType = templateElement.getElementType().copy();
            nifty.removeElement(screen, templateElement);
        }
        this.listBoxPanelElement = this.getChildElement("#panel");
        if (this.listBoxPanelElement == null) {
            this.log.severe("Failed to locate list box panel element. List box will not work properly. Looked for: #panel");
        }
        this.listBoxImpl.bindToView(this, this.displayItems);
        this.connectListBoxAndListBoxPanel();
        this.lastMaxWidth = this.childRootElement.getWidth();
        this.ensureVerticalScrollbar();
        this.createLabels();
    }

    @Nullable
    private Element getChildElement(@Nonnull String id) {
        return this.getChildElement(this.getElement(), id);
    }

    @Nullable
    private Element getChildElement(@Nullable Element searchRoot, @Nonnull String id) {
        if (searchRoot != null) {
            return searchRoot.findElementById(id);
        }
        return null;
    }

    @Nullable
    private Scrollbar getScrollbar(@Nonnull String id) {
        Element element = this.getElement();
        if (element == null) {
            return null;
        }
        return (Scrollbar)element.findNiftyControl(id, Scrollbar.class);
    }

    @Override
    @Nullable
    public Scrollbar getVerticalScrollbar() {
        if (!this.verticalScrollbarState) {
            return null;
        }
        if (this.verticalScrollbar == null) {
            this.verticalScrollbar = this.getScrollbar("#vertical-scrollbar");
        }
        return this.verticalScrollbar;
    }

    @Override
    @Nullable
    public Scrollbar getHorizontalScrollbar() {
        if (!this.horizontalScrollbarState) {
            return null;
        }
        if (this.horizontalScrollbar == null) {
            this.horizontalScrollbar = this.getScrollbar("#horizontal-scrollbar");
        }
        return this.horizontalScrollbar;
    }

    @Nullable
    private Element getVerticalScrollbarElement() {
        Scrollbar scrollbar = this.getVerticalScrollbar();
        if (scrollbar != null) {
            return scrollbar.getElement();
        }
        return null;
    }

    @Nullable
    private Element getHorizontalScrollbarParentElement() {
        Element scrollbar = this.getHorizontalScrollbarElement();
        if (scrollbar != null) {
            return scrollbar.getParent();
        }
        return null;
    }

    @Nullable
    private Element getHorizontalScrollbarElement() {
        Scrollbar scrollbar = this.getHorizontalScrollbar();
        if (scrollbar != null) {
            return scrollbar.getElement();
        }
        return null;
    }

    public void init(@Nonnull Parameters parameter) {
        super.init(parameter);
        if (this.nifty == null || this.screen == null) {
            this.log.severe("Init of controller called before binding was done.");
            return;
        }
        this.initializeScrollPanel();
        this.initializeScrollElementHeight();
        this.listBoxImpl.updateView(0);
        this.initializeHorizontalScrollbar();
        this.initializeVerticalScrollbar(this.labelTemplateHeight, 0);
        this.initSelectionMode(this.listBoxImpl, parameter.getWithDefault("selectionMode", "Single"), parameter.getWithDefault("forceSelection", "false"));
        this.listBoxImpl.updateViewTotalCount();
        this.listBoxImpl.updateViewScroll();
        String id = this.getId();
        if (id == null) {
            this.log.warning("ListBox has no ID. Functionality will be limited.");
        } else {
            this.nifty.subscribe(this.screen, this.getId(), ElementShowEvent.class, this.listBoxControlShowEventSubscriber);
        }
        Element element = this.getElement();
        if (element != null) {
            element.getParent().layoutElements();
        }
    }

    public void onStartScreen() {
    }

    public void mouseWheel(@Nonnull Element e, @Nonnull NiftyMouseInputEvent inputEvent) {
        int mouseWheel = inputEvent.getMouseWheel();
        Scrollbar scrollbar = this.getVerticalScrollbar();
        if (scrollbar != null) {
            float currentValue = scrollbar.getValue();
            if (mouseWheel < 0) {
                scrollbar.setValue(currentValue - scrollbar.getButtonStepSize() * (float)mouseWheel);
            } else if (mouseWheel > 0) {
                scrollbar.setValue(currentValue - scrollbar.getButtonStepSize() * (float)mouseWheel);
            }
        }
    }

    @Nullable
    private String getChildId(@Nonnull String id) {
        Element element = this.getElement();
        if (element == null) {
            return null;
        }
        Element child = element.findElementById(id);
        if (child == null) {
            return null;
        }
        return child.getId();
    }

    private void subscribeVerticalScrollbar(@Nonnull Element scrollbar) {
        if (this.nifty == null || this.screen == null) {
            this.log.severe("Subscribing scrollbar before binding is done.");
            return;
        }
        String id = scrollbar.getId();
        if (id != null) {
            this.nifty.subscribe(this.screen, id, ScrollbarChangedEvent.class, this.verticalScrollbarSubscriber);
        }
    }

    private void subscribeHorizontalScrollbar(@Nonnull Element scrollbar) {
        if (this.nifty == null || this.screen == null) {
            this.log.severe("Subscribing scrollbar before binding is done.");
            return;
        }
        String id = scrollbar.getId();
        if (id != null) {
            this.nifty.subscribe(this.screen, id, ScrollbarChangedEvent.class, this.horizontalScrollbarSubscriber);
        }
    }

    private void createHorizontalScrollbar() {
        if (this.horizontalScrollbarState || this.nifty == null || this.screen == null || this.horizontalScrollbarTemplate == null) {
            return;
        }
        Element element = this.getElement();
        if (element == null) {
            return;
        }
        ElementType type = this.horizontalScrollbarTemplate.copy();
        String id = this.getId();
        if (id != null) {
            this.applyIdPrefixToElementType(id, type);
        }
        Element scrollbarElement = this.nifty.createElementFromType(this.screen, element, type);
        this.horizontalScrollbar = (Scrollbar)scrollbarElement.findNiftyControl("#horizontal-scrollbar", Scrollbar.class);
        if (this.horizontalScrollbar == null) {
            this.log.severe("Recreating the scrollbar resulted in a object that does not seem to be a scrollbar. Strange thing.");
        } else {
            this.subscribeHorizontalScrollbar(scrollbarElement);
        }
        this.horizontalScrollbarState = true;
        this.updateBottomRightElement();
    }

    private void createVerticalScrollbar() {
        if (this.verticalScrollbarState || this.nifty == null || this.screen == null || this.verticalScrollbarTemplate == null) {
            return;
        }
        if (this.scrollElement == null) {
            return;
        }
        ElementType type = this.verticalScrollbarTemplate.copy();
        Element scrollbarElement = this.nifty.createElementFromType(this.screen, this.scrollElement, type);
        this.verticalScrollbar = (Scrollbar)scrollbarElement.getNiftyControl(Scrollbar.class);
        if (this.verticalScrollbar == null) {
            this.log.severe("Recreating the scrollbar resulted in a object that does not seem to be a scrollbar. Strange thing.");
        } else {
            this.subscribeVerticalScrollbar(scrollbarElement);
        }
        this.verticalScrollbarState = true;
        this.ensureWidthConstraints();
        this.updateBottomRightElement();
    }

    private void removeHorizontalScrollbar() {
        Element scrollbarParentPanel;
        String scrollbarId;
        if (!this.horizontalScrollbarState || this.nifty == null || this.screen == null) {
            return;
        }
        Element scrollbar = this.getHorizontalScrollbarElement();
        if (scrollbar != null && (scrollbarId = scrollbar.getId()) != null) {
            this.nifty.unsubscribe(scrollbarId, this.horizontalScrollbarSubscriber);
        }
        if ((scrollbarParentPanel = this.getHorizontalScrollbarParentElement()) != null) {
            this.nifty.removeElement(this.screen, scrollbarParentPanel);
        }
        this.horizontalScrollbar = null;
        this.horizontalScrollbarState = false;
    }

    private void removeVerticalScrollbar() {
        if (!this.verticalScrollbarState || this.nifty == null || this.screen == null) {
            return;
        }
        Element scrollbar = this.getVerticalScrollbarElement();
        if (scrollbar != null) {
            String scrollbarId = scrollbar.getId();
            if (scrollbarId != null) {
                this.nifty.unsubscribe(scrollbarId, this.verticalScrollbarSubscriber);
            }
            this.nifty.removeElement(this.screen, scrollbar, new EndNotify(){

                public void perform() {
                    ListBoxControl.this.ensureWidthConstraints();
                    ListBoxControl.this.updateBottomRightElement();
                }
            });
            this.verticalScrollbar = null;
            this.verticalScrollbarState = false;
        }
    }

    public boolean inputEvent(@Nonnull NiftyInputEvent inputEvent) {
        return false;
    }

    public void setFocus() {
        if (this.childRootElement != null) {
            this.childRootElement.setFocus();
        }
    }

    @Nonnull
    private ListBox.ListBoxViewConverter<T> createViewConverter(@Nonnull String className) {
        try {
            return (ListBox.ListBoxViewConverter)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Unable to instantiate given class [" + className + "] with error: " + e.getMessage(), e);
            return new ListBox.ListBoxViewConverterSimple();
        }
    }

    @Nullable
    public ListBox.ListBoxViewConverter<T> getViewConverter() {
        return this.viewConverter;
    }

    @Override
    public void display(@Nonnull List<T> visibleItems, int focusElement, @Nonnull List<Integer> selectedElements) {
        this.ensureWidthConstraints();
        if (this.labelElements == null) {
            this.log.warning("Can't display anything. Control binding is not done yet.");
        } else {
            int i;
            int count = Math.min(visibleItems.size(), this.labelElements.length);
            if (visibleItems.size() > count) {
                this.log.warning("Trying to show more elements in list then there are display labels.");
            }
            Element element = this.getElement();
            for (i = 0; i < count; ++i) {
                T item = visibleItems.get(i);
                if (this.labelElements[i] == null) continue;
                this.labelElements[i].setVisible(element != null && element.isVisible());
                this.displayElement(i, item);
                this.setListBoxItemIndex(i);
                this.handleElementFocus(i, focusElement);
                this.handleElementSelection(i, item, selectedElements);
            }
            if (count < this.labelElements.length) {
                for (i = count; i < this.labelElements.length; ++i) {
                    if (this.labelElements[i] == null) continue;
                    this.labelElements[i].setVisible(false);
                }
            }
        }
    }

    @Override
    public void updateTotalCount(int newCount) {
        if (this.nifty == null || this.screen == null || this.scrollElement == null || this.verticalScrollbarTemplate == null) {
            this.log.severe("Can't update the total count as long as the control is not bound.");
            return;
        }
        if (this.verticalScrollbarMode == ScrollbarMode.optional) {
            Element element = this.getElement();
            if (element == null) {
                return;
            }
            if (newCount > this.displayItems) {
                this.createVerticalScrollbar();
            } else if (newCount <= this.displayItems) {
                this.removeVerticalScrollbar();
            }
        }
        this.initializeVerticalScrollbar(this.labelTemplateHeight, newCount);
    }

    private static void layoutSilently(@Nullable Element element) {
        if (element != null) {
            element.layoutElements();
        }
    }

    private void applyIdPrefixToElementType(@Nonnull String prefix, @Nonnull ElementType type) {
        type.getAttributes().set("id", prefix + type.getAttributes().get("id"));
        for (ElementType child : type.getElements()) {
            this.applyIdPrefixToElementType(prefix, child);
        }
    }

    @Override
    public void updateTotalWidth(int newWidth) {
        this.lastMaxWidth = newWidth;
        if (this.nifty == null || this.screen == null || this.listBoxPanelElement == null || this.horizontalScrollbarTemplate == null) {
            this.log.severe("Can't update the total count as long as the control is not bound.");
            return;
        }
        Element element = this.getElement();
        if (element == null) {
            return;
        }
        if (this.horizontalScrollbarMode == ScrollbarMode.optional) {
            if (newWidth > this.listBoxPanelElement.getWidth()) {
                this.createHorizontalScrollbar();
            } else if (newWidth <= this.listBoxPanelElement.getWidth()) {
                this.removeHorizontalScrollbar();
            }
        }
        this.initializeHorizontalScrollbar();
        this.ensureWidthConstraints();
        ListBoxControl.layoutSilently(element.getParent());
    }

    public void ensureWidthConstraints() {
        if (this.listBoxPanelElement != null) {
            this.applyWidthConstraints(Math.max(this.lastMaxWidth, this.listBoxPanelElement.getWidth()));
        }
    }

    public void layoutCallback() {
        this.ensureWidthConstraints();
        this.initializeHorizontalScrollbar();
    }

    private void applyWidthConstraints(int width) {
        if (this.applyWidthConstraintsLastWidth == width) {
            return;
        }
        this.applyWidthConstraintsLastWidth = width;
        SizeValue newWidthSizeValue = SizeValue.px((int)width);
        if (this.labelElements != null) {
            for (int i = 0; i < this.labelElements.length; ++i) {
                Element element = this.labelElements[i];
                if (element == null) continue;
                element.setConstraintWidth(newWidthSizeValue);
            }
        }
        if (this.childRootElement != null) {
            this.childRootElement.setConstraintWidth(newWidthSizeValue);
        }
        ListBoxControl.layoutSilently(this.getElement());
    }

    @Override
    public void scrollTo(int newPosition) {
        Scrollbar verticalS = this.getVerticalScrollbar();
        if (verticalS != null) {
            verticalS.setValue(newPosition * this.labelTemplateHeight);
        }
    }

    @Override
    public int getWidth(@Nonnull T item) {
        if (this.viewConverter == null | this.labelElements == null || this.labelElements[0] == null) {
            return 0;
        }
        return this.viewConverter.getWidth(this.labelElements[0], item);
    }

    @Override
    public void changeSelectionMode(@Nonnull ListBox.SelectionMode listBoxSelectionMode, boolean forceSelection) {
        this.listBoxImpl.changeSelectionMode(listBoxSelectionMode, forceSelection);
    }

    @Override
    public void addItem(@Nonnull T newItem) {
        this.listBoxImpl.addItem(newItem);
    }

    @Override
    public void insertItem(@Nonnull T item, int index) {
        this.listBoxImpl.insertItem(item, index);
    }

    @Override
    public int itemCount() {
        return this.listBoxImpl.itemCount();
    }

    @Override
    public void clear() {
        this.listBoxImpl.clear();
    }

    @Override
    public void selectItemByIndex(int selectionIndex) {
        this.listBoxImpl.selectItemByIndex(selectionIndex);
    }

    @Override
    public void selectItem(@Nonnull T item) {
        this.listBoxImpl.selectItem(item);
    }

    @Override
    public void selectNext() {
        this.listBoxImpl.selectNext();
    }

    @Override
    public void selectPrevious() {
        this.listBoxImpl.selectPrevious();
    }

    @Override
    public void deselectItemByIndex(int itemIndex) {
        this.listBoxImpl.deselectItemByIndex(itemIndex);
    }

    @Override
    public void deselectItem(@Nonnull T item) {
        this.listBoxImpl.deselectItem(item);
    }

    @Override
    @Nonnull
    public List<T> getSelection() {
        return this.listBoxImpl.getSelection();
    }

    @Override
    @Nonnull
    public List<Integer> getSelectedIndices() {
        return this.listBoxImpl.getSelectedIndices();
    }

    @Override
    public void removeItemByIndex(int itemIndex) {
        this.listBoxImpl.removeItemByIndex(itemIndex);
    }

    @Override
    public void removeItem(@Nonnull T item) {
        this.listBoxImpl.removeItem(item);
    }

    @Override
    @Nonnull
    public List<T> getItems() {
        return this.listBoxImpl.getItems();
    }

    @Override
    public void showItem(@Nonnull T item) {
        this.listBoxImpl.showItem(item);
    }

    @Override
    public void showItemByIndex(int itemIndex) {
        this.listBoxImpl.showItemByIndex(itemIndex);
    }

    @Override
    public void setFocusItem(@Nullable T item) {
        this.listBoxImpl.setFocusItem(item);
    }

    @Override
    public void setFocusItemByIndex(int itemIndex) {
        this.listBoxImpl.setFocusItemByIndex(itemIndex);
    }

    @Override
    @Nullable
    public T getFocusItem() {
        return this.listBoxImpl.getFocusItem();
    }

    @Override
    public int getFocusItemIndex() {
        return this.listBoxImpl.getFocusItemIndex();
    }

    @Override
    public void setListBoxViewConverter(@Nonnull ListBox.ListBoxViewConverter<T> viewConverter) {
        this.viewConverter = viewConverter;
    }

    @Override
    public void publish(@Nonnull ListBoxSelectionChangedEvent<T> event) {
        String id;
        if (this.nifty != null && (id = this.getId()) != null) {
            this.nifty.publishEvent(id, event);
        }
    }

    @Override
    public void addAllItems(@Nonnull Collection<T> itemsToAdd) {
        this.listBoxImpl.addAllItems(itemsToAdd);
    }

    @Override
    public void removeAllItems(@Nonnull Collection<T> itemsToRemove) {
        this.listBoxImpl.removeAllItems(itemsToRemove);
    }

    @Override
    public void sortAllItems() {
        this.listBoxImpl.sortItems(null);
    }

    @Override
    public void sortAllItems(@Nullable Comparator<T> comparator) {
        this.listBoxImpl.sortItems(comparator);
    }

    @Override
    public int getDisplayItemCount() {
        return this.displayItems;
    }

    @Override
    public void refresh() {
        this.listBoxImpl.updateView();
    }

    private void initSelectionMode(@Nonnull ListBoxImpl<T> listBoxImpl, @Nonnull String selectionMode, @Nonnull String forceSelection) {
        ListBox.SelectionMode listBoxSelectionMode = ListBox.SelectionMode.Single;
        try {
            listBoxSelectionMode = ListBox.SelectionMode.valueOf(selectionMode);
        }
        catch (RuntimeException e) {
            this.log.warning("Unsupported value for selectionMode [" + selectionMode + "]. Fall back to using single selection mode.");
        }
        listBoxImpl.changeSelectionMode(listBoxSelectionMode, "true".equalsIgnoreCase(forceSelection), false);
    }

    private void initializeScrollPanel() {
        Element scrollbar;
        if (this.nifty == null) {
            this.log.severe("Can't init the scroll panel as long as the controller is not properly bound.");
            return;
        }
        Element element = this.getElement();
        if (element == null) {
            return;
        }
        if (this.horizontalScrollbarMode == ScrollbarMode.off || this.horizontalScrollbarMode == ScrollbarMode.optional) {
            this.removeHorizontalScrollbar();
        } else {
            scrollbar = this.getHorizontalScrollbarElement();
            if (scrollbar != null) {
                this.subscribeHorizontalScrollbar(scrollbar);
            }
        }
        if (this.verticalScrollbarMode == ScrollbarMode.off || this.verticalScrollbarMode == ScrollbarMode.optional) {
            this.removeVerticalScrollbar();
        } else {
            scrollbar = this.getVerticalScrollbarElement();
            if (scrollbar != null) {
                this.subscribeVerticalScrollbar(scrollbar);
            }
        }
        if (this.childRootElement != null) {
            this.childRootElement.setConstraintX(SizeValue.px((int)0));
            this.childRootElement.setConstraintY(SizeValue.px((int)0));
            this.childRootElement.getParent().layoutElements();
        }
    }

    private void updateBottomRightElement() {
        if (this.nifty == null || this.screen == null) {
            this.log.severe("Can't apply the bottom right spacer as long as the controller is not properly bound.");
            return;
        }
        final Element element = this.getElement();
        if (element == null) {
            return;
        }
        Element horizontal = this.getHorizontalScrollbarParentElement();
        Element vertical = this.getVerticalScrollbarElement();
        Element bottomRight = this.getChildElement(horizontal, "#bottom-right");
        if (horizontal != null) {
            if (vertical == null) {
                if (bottomRight != null) {
                    this.nifty.removeElement(this.screen, bottomRight, new EndNotify(){

                        public void perform() {
                            ListBoxControl.this.initializeHorizontalScrollbar();
                            element.getParent().layoutElements();
                        }
                    });
                }
            } else if (bottomRight == null) {
                if (this.bottomRightTemplate == null) {
                    this.log.severe("Need to create bottom right element to apply a proper spacing. But there is no template. List box is expected to look crappy.");
                } else {
                    this.nifty.createElementFromType(this.screen, horizontal, this.bottomRightTemplate);
                    this.initializeHorizontalScrollbar();
                    element.getParent().layoutElements();
                }
            }
        }
    }

    private void initializeHorizontalScrollbar() {
        Scrollbar horizontalS = this.getHorizontalScrollbar();
        if (horizontalS != null && horizontalS.isBound()) {
            horizontalS.setWorldMax(this.lastMaxWidth);
            horizontalS.setWorldPageSize(this.listBoxPanelElement != null ? (float)this.listBoxPanelElement.getWidth() : 0.0f);
        }
    }

    private void initializeVerticalScrollbar(float labelTemplateHeight, int itemCount) {
        Scrollbar verticalS = this.getVerticalScrollbar();
        if (verticalS != null && verticalS.isBound()) {
            verticalS.setWorldMax((float)itemCount * labelTemplateHeight);
            verticalS.setWorldPageSize((float)this.displayItems * labelTemplateHeight);
            verticalS.setButtonStepSize(labelTemplateHeight);
        }
    }

    @Override
    public void addItemProcessor(@Nonnull ListBoxItemProcessor processor) {
        this.itemProcessors.add(processor);
    }

    private void createLabels() {
        if (this.nifty == null || this.screen == null || this.childRootElement == null) {
            this.log.severe("Label creation failed. Binding not done properly");
            return;
        }
        if (this.labelTemplateElementType == null) {
            this.log.severe("Label creation failed. Template element set.");
            return;
        }
        String templateId = this.labelTemplateElementType.getAttributes().get("id");
        for (Element e : this.childRootElement.getChildren()) {
            this.nifty.removeElement(this.screen, e);
        }
        this.labelElements = new Element[this.displayItems];
        for (int i = 0; i < this.displayItems; ++i) {
            String newId;
            ElementType templateType = this.labelTemplateElementType.copy();
            String oldId = templateId;
            if (oldId == null) {
                oldId = this.getChildId("#child-root");
            }
            if (oldId == null) {
                this.log.severe("Failed to locate proper ID, label element will be created with global id.");
                newId = NiftyIdCreator.generate();
            } else {
                newId = oldId + "#" + NiftyIdCreator.generate();
            }
            templateType.getAttributes().set("id", newId);
            if (oldId != null) {
                this.replaceAllIds(templateType, oldId, newId);
            }
            this.labelElements[i] = this.nifty.createElementFromType(this.screen, this.childRootElement, templateType);
            for (ListBoxItemProcessor processor : this.itemProcessors) {
                processor.processElement(this.labelElements[i]);
            }
        }
    }

    private void replaceAllIds(@Nonnull ElementType type, @Nonnull String oldId, @Nonnull String newId) {
        Collection children = type.getElements();
        for (ElementType child : children) {
            String id = child.getAttributes().get("id");
            if (id != null) {
                child.getAttributes().set("id", id.replace(oldId, newId));
            }
            this.replaceAllIds(child, oldId, newId);
        }
    }

    private void initializeScrollElementHeight() {
        if (this.scrollElement != null) {
            this.scrollElement.setConstraintHeight(SizeValue.px((int)(this.displayItems * this.labelTemplateHeight)));
        }
    }

    private void ensureVerticalScrollbar() {
        if (this.displayItems == 1) {
            this.verticalScrollbarMode = ScrollbarMode.off;
        }
    }

    private void connectListBoxAndListBoxPanel() {
        if (this.listBoxPanelElement == null) {
            this.log.severe("Can't connect list box and panel while panel is not set. Binding not done?");
            return;
        }
        ListBoxPanel listBoxPanel = (ListBoxPanel)this.listBoxPanelElement.getControl(ListBoxPanel.class);
        if (listBoxPanel == null) {
            this.log.severe("List box panel element does not contain proper control. Corrupted control.");
        } else {
            listBoxPanel.setListBox(this.listBoxImpl);
        }
    }

    private void displayElement(int index, @Nonnull T item) {
        if (this.viewConverter != null && this.labelElements != null) {
            this.viewConverter.display(this.labelElements[index], item);
        }
    }

    private void handleElementSelection(int index, @Nullable T item, @Nonnull List<Integer> selectedElements) {
        if (this.labelElements != null) {
            if (item != null && selectedElements.contains(index)) {
                this.labelElements[index].startEffect(EffectEventId.onCustom, null, "select");
            } else {
                this.labelElements[index].resetSingleEffect(EffectEventId.onCustom, "select");
            }
        }
    }

    private void handleElementFocus(int index, int focusElement) {
        if (this.listBoxPanelElement != null && this.labelElements != null) {
            if (index < 0 || index >= this.labelElements.length) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            ListBoxPanel listBoxPanel = (ListBoxPanel)this.listBoxPanelElement.getControl(ListBoxPanel.class);
            if (listBoxPanel != null && listBoxPanel.hasFocus()) {
                if (focusElement == index) {
                    this.labelElements[index].startEffect(EffectEventId.onCustom, null, "focus");
                } else {
                    this.labelElements[index].resetSingleEffect(EffectEventId.onCustom, "focus");
                }
            } else {
                this.labelElements[index].resetSingleEffect(EffectEventId.onCustom, "focus");
            }
        }
    }

    private void setListBoxItemIndex(int itemIndex) {
        if (this.labelElements != null) {
            if (itemIndex < 0 || itemIndex >= this.labelElements.length) {
                throw new ArrayIndexOutOfBoundsException(itemIndex);
            }
            ListBoxItemController listBoxItemController = (ListBoxItemController)this.labelElements[itemIndex].getControl(ListBoxItemController.class);
            if (listBoxItemController != null) {
                listBoxItemController.setItemIndex(itemIndex);
            }
        }
    }

    private static enum ScrollbarMode {
        off,
        on,
        optional;

    }
}

