/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.dropdown;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.DropDown;
import de.lessvoid.nifty.controls.DropDownSelectionChangedEvent;
import de.lessvoid.nifty.controls.ListBox;
import de.lessvoid.nifty.controls.ListBoxSelectionChangedEvent;
import de.lessvoid.nifty.controls.dropdown.DropDownControl;
import de.lessvoid.nifty.controls.listbox.ListBoxControl;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.screen.Screen;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bushe.swing.event.EventTopicSubscriber;

public class DropDownListBoxSelectionChangedEventSubscriber
implements EventTopicSubscriber<ListBoxSelectionChangedEvent> {
    @Nonnull
    private final Nifty nifty;
    @Nonnull
    private final Screen screen;
    @Nonnull
    private final ListBox listBox;
    @Nonnull
    private final DropDown dropDown;
    @Nonnull
    private final Element popupInstance;

    public DropDownListBoxSelectionChangedEventSubscriber(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull ListBox listBox, @Nonnull DropDown dropDown, @Nonnull Element popupInstance) {
        this.nifty = nifty;
        this.screen = screen;
        this.listBox = listBox;
        this.dropDown = dropDown;
        this.popupInstance = popupInstance;
    }

    public void onEvent(String topic, @Nonnull ListBoxSelectionChangedEvent data) {
        final Object selectedItem = this.getSelectedItem(data.getSelection());
        if (selectedItem == null) {
            return;
        }
        ListBoxControl listBoxControl = (ListBoxControl)this.listBox;
        Element dropDownElement = this.dropDown.getElement();
        if (dropDownElement != null) {
            Element dropDownTextDisplay;
            ListBox.ListBoxViewConverter<Object> converter = listBoxControl.getViewConverter();
            if (converter != null && (dropDownTextDisplay = dropDownElement.findElementById("#text")) != null) {
                converter.display(dropDownTextDisplay, selectedItem);
            }
            final int selectedItemIndex = this.getSelectedIndex(data);
            final String id = this.dropDown.getId();
            if (id != null) {
                if (this.screen.isActivePopup(this.popupInstance)) {
                    DropDownControl control = (DropDownControl)dropDownElement.getControl(DropDownControl.class);
                    if (control != null) {
                        control.close(new EndNotify(){

                            public void perform() {
                                DropDownListBoxSelectionChangedEventSubscriber.this.nifty.publishEvent(id, new DropDownSelectionChangedEvent<Object>(DropDownListBoxSelectionChangedEventSubscriber.this.dropDown, selectedItem, selectedItemIndex));
                            }
                        });
                    }
                } else {
                    this.nifty.publishEvent(id, new DropDownSelectionChangedEvent<Object>(this.dropDown, selectedItem, selectedItemIndex));
                }
            }
        }
    }

    private int getSelectedIndex(@Nonnull ListBoxSelectionChangedEvent<?> data) {
        int selectedItemIndex = -1;
        List<Integer> selectionIndices = data.getSelectionIndices();
        if (!selectionIndices.isEmpty()) {
            selectedItemIndex = selectionIndices.get(0);
        }
        return selectedItemIndex;
    }

    @Nullable
    private Object getSelectedItem(@Nonnull List selection) {
        if (selection.isEmpty()) {
            return null;
        }
        return selection.get(0);
    }
}

