/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.dropdown;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.DropDown;
import de.lessvoid.nifty.controls.FocusHandler;
import de.lessvoid.nifty.controls.ListBox;
import de.lessvoid.nifty.controls.ListBoxSelectionChangedEvent;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.controls.dropdown.DropDownListBoxSelectionChangedEventSubscriber;
import de.lessvoid.nifty.controls.dropdown.DropDownPopup;
import de.lessvoid.nifty.controls.listbox.ListBoxControl;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.input.NiftyStandardInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bushe.swing.event.EventTopicSubscriber;

@Deprecated
public class DropDownControl<T>
extends AbstractController
implements DropDown<T> {
    @Nonnull
    private static final Logger log = Logger.getLogger(DropDownControl.class.getName());
    @Nullable
    private Nifty nifty;
    private boolean alreadyOpen = false;
    @Nullable
    private FocusHandler focusHandler;
    @Nullable
    private Screen screen;
    @Nullable
    private Element popup;
    @Nullable
    private ListBox<T> listBox;

    public void bind(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element element, @Nonnull Parameters properties) {
        DropDown.DropDownViewConverter<T> converter;
        super.bind(element);
        this.nifty = nifty;
        this.screen = screen;
        this.focusHandler = screen.getFocusHandler();
        String elementId = this.getId();
        if (elementId == null) {
            log.warning("The DropDownControl requires an id but this one is missing it.");
            return;
        }
        Attributes parameters = new Attributes(new String[]{"displayItems", properties.getWithDefault("displayItems", "4")});
        this.popup = nifty.createPopupWithStyle(screen, "dropDownBoxSelectPopup", properties.get("style"), parameters);
        DropDownPopup popupControl = (DropDownPopup)this.popup.getControl(DropDownPopup.class);
        if (popupControl == null) {
            log.severe("Popup of drop down does not contain the proper controller. Dropdown element will not work. Expected controller class: " + DropDownPopup.class.getName());
        } else {
            popupControl.setDropDownElement(this, this.popup);
        }
        this.listBox = (ListBox)this.popup.findNiftyControl("#listBox", ListBox.class);
        if (this.listBox == null) {
            log.severe("Failed to locate list box of the drop down. Drop down element will not work. Looked for: #listBox");
        }
        if ((converter = this.createViewConverter(properties.getProperty("viewConverterClass"))) != null) {
            this.setViewConverter(converter);
        }
    }

    @Nullable
    private DropDown.DropDownViewConverter<T> createViewConverter(@Nullable String className) {
        if (className == null) {
            return null;
        }
        try {
            return (DropDown.DropDownViewConverter)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Unable to instantiate given class [" + className + "] with error: " + e.getMessage(), e);
            return null;
        }
    }

    public void onStartScreen() {
        String listBoxId;
        this.updateEnabled();
        if (this.listBox instanceof ListBoxControl) {
            ListBox.ListBoxViewConverter<T> converter;
            T selectedItem;
            Element textElement;
            ListBoxControl listBoxControl = (ListBoxControl)this.listBox;
            Element element = this.getElement();
            if (element != null && (textElement = element.findElementById("#text")) != null && (selectedItem = this.getSelection()) != null && (converter = listBoxControl.getViewConverter()) != null) {
                converter.display(textElement, selectedItem);
            }
        }
        if (this.nifty != null && this.screen != null && this.listBox != null && this.popup != null && (listBoxId = this.listBox.getId()) != null) {
            this.nifty.subscribe(this.screen, listBoxId, ListBoxSelectionChangedEvent.class, (EventTopicSubscriber)new DropDownListBoxSelectionChangedEventSubscriber(this.nifty, this.screen, this.listBox, this, this.popup));
        }
    }

    public boolean inputEvent(@Nonnull NiftyInputEvent inputEvent) {
        Element element;
        if (inputEvent == NiftyStandardInputEvent.Activate) {
            this.dropDownClicked();
            return true;
        }
        if (this.listBox != null) {
            if (inputEvent == NiftyStandardInputEvent.MoveCursorUp) {
                this.listBox.selectPrevious();
                return true;
            }
            if (inputEvent == NiftyStandardInputEvent.MoveCursorDown) {
                this.listBox.selectNext();
                return true;
            }
        }
        if ((element = this.getElement()) != null && this.focusHandler != null) {
            if (inputEvent == NiftyStandardInputEvent.NextInputElement) {
                this.focusHandler.getNext(element).setFocus();
                return true;
            }
            if (inputEvent == NiftyStandardInputEvent.PrevInputElement) {
                this.focusHandler.getPrev(element).setFocus();
                return true;
            }
        }
        return false;
    }

    public void dropDownClicked() {
        if (this.popup == null || this.nifty == null || this.screen == null || this.alreadyOpen) {
            return;
        }
        String popupId = this.popup.getId();
        if (popupId != null) {
            this.alreadyOpen = true;
            this.nifty.showPopup(this.screen, this.popup.getId(), null);
        }
    }

    public void close() {
        this.closeInternal(null);
    }

    public void close(EndNotify endNotify) {
        this.closeInternal(endNotify);
    }

    private void closeInternal(final @Nullable EndNotify endNotify) {
        this.alreadyOpen = false;
        if (this.nifty == null || this.popup == null || this.screen == null || this.listBox == null) {
            return;
        }
        String popupId = this.popup.getId();
        final String listBoxId = this.listBox.getId();
        if (popupId == null || listBoxId == null) {
            return;
        }
        this.nifty.closePopup(popupId, new EndNotify(){

            public void perform() {
                DropDownControl.this.nifty.subscribe(DropDownControl.this.screen, listBoxId, ListBoxSelectionChangedEvent.class, (EventTopicSubscriber)new DropDownListBoxSelectionChangedEventSubscriber(DropDownControl.this.nifty, DropDownControl.this.screen, DropDownControl.this.listBox, DropDownControl.this, DropDownControl.this.popup));
                if (endNotify != null) {
                    endNotify.perform();
                }
            }
        });
    }

    public void refresh() {
    }

    private void updateEnabled() {
        this.setEnabled(this.listBox == null || !this.listBox.getItems().isEmpty());
    }

    @Override
    public void setViewConverter(final @Nonnull DropDown.DropDownViewConverter<T> viewConverter) {
        if (this.listBox == null) {
            log.warning("Can't apply view converter before the binding is done.");
        } else {
            this.listBox.setListBoxViewConverter(new ListBox.ListBoxViewConverter<T>(){

                @Override
                public void display(@Nonnull Element listBoxItem, @Nonnull T item) {
                    viewConverter.display(listBoxItem, item);
                }

                @Override
                public int getWidth(@Nonnull Element element, @Nonnull T item) {
                    return viewConverter.getWidth(element, item);
                }
            });
        }
    }

    @Override
    public void addItem(@Nonnull T newItem) {
        if (this.listBox == null) {
            if (!this.isBound()) {
                throw new IllegalStateException("Can't add item before the binding is done.");
            }
            log.severe("Binding seems to have failed, can't add item.");
            return;
        }
        this.listBox.addItem(newItem);
        this.updateEnabled();
    }

    @Override
    public void insertItem(@Nonnull T item, int index) {
        if (this.listBox == null) {
            if (!this.isBound()) {
                throw new IllegalStateException("Can't insert item before the binding is done.");
            }
            log.severe("Binding seems to have failed, can't insert item.");
            return;
        }
        this.listBox.insertItem(item, index);
        this.updateEnabled();
    }

    @Override
    public int itemCount() {
        if (this.listBox == null) {
            return 0;
        }
        return this.listBox.itemCount();
    }

    @Override
    public void clear() {
        if (this.listBox != null) {
            this.listBox.clear();
            this.updateEnabled();
        }
    }

    @Override
    public void selectItemByIndex(int selectionIndex) {
        if (this.listBox == null) {
            if (!this.isBound()) {
                throw new IllegalStateException("Can't select item before the binding is done.");
            }
            log.severe("Binding seems to have failed, can't select item.");
            return;
        }
        this.listBox.selectItemByIndex(selectionIndex);
    }

    @Override
    public void selectItem(@Nonnull T item) {
        if (this.listBox == null) {
            if (!this.isBound()) {
                throw new IllegalStateException("Can't select item before the binding is done.");
            }
            log.severe("Binding seems to have failed, can't select item.");
            return;
        }
        this.listBox.selectItem(item);
    }

    @Override
    @Nullable
    public T getSelection() {
        if (this.listBox == null) {
            return null;
        }
        List<T> selection = this.listBox.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return selection.get(0);
    }

    @Override
    public int getSelectedIndex() {
        if (this.listBox == null) {
            return -1;
        }
        List<Integer> selection = this.listBox.getSelectedIndices();
        if (selection.isEmpty()) {
            return -1;
        }
        return selection.get(0);
    }

    @Override
    public void removeItemByIndex(int itemIndex) {
        if (this.listBox == null) {
            if (!this.isBound()) {
                throw new IllegalStateException("Can't remove item before the binding is done.");
            }
            log.severe("Binding seems to have failed, can't remove item.");
            return;
        }
        this.listBox.removeItemByIndex(itemIndex);
        this.updateEnabled();
    }

    @Override
    public void removeItem(@Nonnull T item) {
        if (this.listBox == null) {
            if (!this.isBound()) {
                throw new IllegalStateException("Can't add item before the binding is done.");
            }
            log.severe("Binding seems to have failed, can't add item.");
            return;
        }
        this.listBox.removeItem(item);
        this.updateEnabled();
    }

    @Override
    @Nonnull
    public List<T> getItems() {
        if (this.listBox == null) {
            return Collections.emptyList();
        }
        return this.listBox.getItems();
    }

    @Override
    public void addAllItems(@Nonnull Collection<T> itemsToAdd) {
        if (this.listBox == null) {
            if (!this.isBound()) {
                throw new IllegalStateException("Can't add items before the binding is done.");
            }
            log.severe("Binding seems to have failed, can't add items.");
            return;
        }
        this.listBox.addAllItems(itemsToAdd);
        this.updateEnabled();
    }

    @Override
    public void removeAllItems(@Nonnull Collection<T> itemsToRemove) {
        if (this.listBox == null) {
            if (!this.isBound()) {
                throw new IllegalStateException("Can't remove items before the binding is done.");
            }
            log.severe("Binding seems to have failed, can't remove items.");
            return;
        }
        this.listBox.removeAllItems(itemsToRemove);
        this.updateEnabled();
    }
}

