/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.chatcontrol;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.Chat;
import de.lessvoid.nifty.controls.ChatTextSendEvent;
import de.lessvoid.nifty.controls.ListBox;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.controls.TextField;
import de.lessvoid.nifty.controls.chatcontrol.ChatEntryModelClass;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.input.NiftyStandardInputEvent;
import de.lessvoid.nifty.render.NiftyImage;
import de.lessvoid.nifty.screen.KeyInputHandler;
import de.lessvoid.nifty.screen.Screen;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Deprecated
public class ChatControl
extends AbstractController
implements Chat,
KeyInputHandler {
    private static final String CHAT_BOX = "#chatBox";
    private static final String PLAYER_LIST = "#playerList";
    private static final String CHAT_TEXT_INPUT = "#chat-text-input";
    private static final Logger LOGGER = Logger.getLogger(ChatControl.class.getName());
    @Nullable
    private TextField textControl;
    @Nonnull
    private final PlayerComparator playerComparator = new PlayerComparator();
    private Nifty nifty;
    @Nonnull
    private final List<ChatEntryModelClass> playerBuffer = new ArrayList<ChatEntryModelClass>();
    @Nonnull
    private final List<ChatEntryModelClass> linesBuffer = new ArrayList<ChatEntryModelClass>();

    public final void bind(@Nonnull Nifty niftyParam, @Nonnull Screen screenParam, @Nonnull Element newElement, @Nonnull Parameters properties) {
        super.bind(newElement);
        LOGGER.fine("binding chat control");
        this.nifty = niftyParam;
        ListBox<ChatEntryModelClass> playerList = this.getListBox(PLAYER_LIST);
        if (playerList == null) {
            LOGGER.severe("Element for player list \"#playerList\" not found. ChatControl will not work.");
        } else {
            while (!this.playerBuffer.isEmpty()) {
                ChatEntryModelClass player = this.playerBuffer.remove(0);
                LOGGER.log(Level.FINE, "adding player {0}", playerList.itemCount() + 1);
                playerList.addItem(player);
                playerList.sortAllItems(this.playerComparator);
                playerList.showItem(player);
            }
        }
        ListBox<ChatEntryModelClass> chatBox = this.getListBox(CHAT_BOX);
        if (chatBox == null) {
            LOGGER.severe("Element for chat box \"#chatBox\" not found. ChatControl will not work.");
        } else {
            while (!this.linesBuffer.isEmpty()) {
                ChatEntryModelClass line = this.linesBuffer.remove(0);
                LOGGER.log(Level.FINE, "adding message {0}", chatBox.itemCount() + 1);
                chatBox.addItem(line);
                chatBox.showItemByIndex(chatBox.itemCount() - 1);
            }
        }
    }

    public void onFocus(boolean arg0) {
        if (this.textControl != null) {
            this.textControl.setFocus();
        }
    }

    public final void onStartScreen() {
        Element element = this.getElement();
        if (element != null) {
            this.textControl = (TextField)element.findNiftyControl(CHAT_TEXT_INPUT, TextField.class);
            if (this.textControl == null) {
                LOGGER.severe("Text input field for chat box was not found!");
            } else {
                Element textControlElement = this.textControl.getElement();
                if (textControlElement != null) {
                    textControlElement.addInputHandler((KeyInputHandler)this);
                }
            }
        }
    }

    @Override
    public final void receivedChatLine(@Nonnull String text, @Nullable NiftyImage icon) {
        this.receivedChatLine(text, icon, null);
    }

    @Override
    public void receivedChatLine(@Nonnull String text, @Nullable NiftyImage icon, @Nullable String style) {
        if (this.linesBuffer.isEmpty()) {
            ListBox<ChatEntryModelClass> chatBox = this.getListBox(CHAT_BOX);
            if (chatBox != null) {
                LOGGER.log(Level.FINE, "adding message {0}", chatBox.itemCount() + 1);
                ChatEntryModelClass item = new ChatEntryModelClass(text, icon, style);
                chatBox.addItem(item);
                chatBox.showItemByIndex(chatBox.itemCount() - 1);
            } else {
                this.linesBuffer.add(new ChatEntryModelClass(text, icon, style));
            }
        } else {
            this.linesBuffer.add(new ChatEntryModelClass(text, icon, style));
        }
    }

    @Override
    public final void addPlayer(@Nonnull String playerName, @Nullable NiftyImage playerIcon) {
        this.addPlayer(playerName, playerIcon, null);
    }

    @Override
    public void addPlayer(@Nonnull String playerName, @Nullable NiftyImage playerIcon, @Nullable String style) {
        if (this.playerBuffer.isEmpty()) {
            ListBox<ChatEntryModelClass> playerList = this.getListBox(PLAYER_LIST);
            if (playerList != null) {
                LOGGER.log(Level.FINE, "adding player {0}", playerList.itemCount() + 1);
                ChatEntryModelClass item = new ChatEntryModelClass(playerName, playerIcon, style);
                playerList.addItem(item);
                playerList.sortAllItems(this.playerComparator);
                playerList.showItem(item);
            } else {
                this.playerBuffer.add(new ChatEntryModelClass(playerName, playerIcon, style));
            }
        } else {
            this.playerBuffer.add(new ChatEntryModelClass(playerName, playerIcon, style));
        }
    }

    @Override
    public final void removePlayer(@Nonnull String playerName) {
        ListBox<ChatEntryModelClass> playerList = this.getListBox(PLAYER_LIST);
        if (playerList != null) {
            LOGGER.log(Level.FINE, "removing player {0}", playerName);
            List<ChatEntryModelClass> itemList = playerList.getItems();
            int playerCount = itemList.size();
            for (int i = 0; i < playerCount; ++i) {
                ChatEntryModelClass item = itemList.get(i);
                if (!item.getLabel().equals(playerName)) continue;
                playerList.removeItemByIndex(i);
                break;
            }
        }
    }

    @Override
    @Nonnull
    public List<ChatEntryModelClass> getPlayers() {
        ListBox<ChatEntryModelClass> playerList = this.getListBox(PLAYER_LIST);
        if (playerList == null) {
            return Collections.emptyList();
        }
        return playerList.getItems();
    }

    @Override
    @Nonnull
    public List<ChatEntryModelClass> getLines() {
        ListBox<ChatEntryModelClass> chatBox = this.getListBox(CHAT_BOX);
        if (chatBox == null) {
            return Collections.emptyList();
        }
        return chatBox.getItems();
    }

    @Override
    public void update() {
        ListBox<ChatEntryModelClass> playerList = this.getListBox(PLAYER_LIST);
        if (playerList != null) {
            playerList.refresh();
        }
    }

    public final void sendText() {
        String text;
        if (this.textControl == null) {
            text = "";
        } else {
            text = this.textControl.getRealText();
            this.textControl.setText("");
        }
        String id = this.getId();
        if (id != null) {
            this.nifty.publishEvent(id, (NiftyEvent)new ChatTextSendEvent(this, text));
        }
    }

    @Nullable
    private ListBox<ChatEntryModelClass> getListBox(@Nonnull String name) {
        Element element = this.getElement();
        if (element == null) {
            return null;
        }
        return (ListBox)element.findNiftyControl(name, ListBox.class);
    }

    public boolean keyEvent(@Nonnull NiftyInputEvent inputEvent) {
        if (inputEvent == NiftyStandardInputEvent.SubmitText) {
            this.sendText();
            return true;
        }
        return false;
    }

    public boolean inputEvent(@Nonnull NiftyInputEvent inputEvent) {
        return this.keyEvent(inputEvent);
    }

    private static class PlayerComparator
    implements Comparator<ChatEntryModelClass> {
        @Override
        public int compare(@Nonnull ChatEntryModelClass player1, @Nonnull ChatEntryModelClass player2) {
            return player1.getLabel().compareToIgnoreCase(player2.getLabel());
        }
    }
}

