/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.button;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.Button;
import de.lessvoid.nifty.controls.ButtonClickedEvent;
import de.lessvoid.nifty.controls.ButtonReleasedEvent;
import de.lessvoid.nifty.controls.FocusHandler;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.input.NiftyStandardInputEvent;
import de.lessvoid.nifty.layout.align.HorizontalAlign;
import de.lessvoid.nifty.layout.align.VerticalAlign;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.spi.render.RenderFont;
import de.lessvoid.nifty.tools.Color;
import de.lessvoid.nifty.tools.SizeValue;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Deprecated
public class ButtonControl
extends AbstractController
implements Button {
    @Nonnull
    private static final Logger log = Logger.getLogger(ButtonControl.class.getName());
    @Nullable
    private Nifty nifty;
    @Nullable
    private FocusHandler focusHandler;
    @Nullable
    private Element buttonTextElement;
    @Nullable
    private TextRenderer buttonTextRenderer;

    public void bind(@Nonnull Nifty niftyParam, @Nonnull Screen screenParam, @Nonnull Element newElement, @Nonnull Parameters parameter) {
        TextRenderer renderer;
        super.bind(newElement);
        this.nifty = niftyParam;
        Element text = newElement.findElementById("#text");
        if (text == null) {
            log.severe("Button element misses the text content element.");
            return;
        }
        this.buttonTextElement = text;
        if (newElement.getId() == null) {
            log.warning("Button element has no ID and can't publish any events properly.");
        }
        if ((renderer = (TextRenderer)this.buttonTextElement.getRenderer(TextRenderer.class)) == null) {
            throw new RuntimeException("ButtonControl is corrupted, #text element found, but missing TextRenderer");
        }
        this.buttonTextRenderer = renderer;
        this.focusHandler = screenParam.getFocusHandler();
    }

    public void onStartScreen() {
    }

    public void onFocus(boolean getFocus) {
        super.onFocus(getFocus);
    }

    public boolean onClick() {
        String id;
        if (this.nifty != null && (id = this.getId()) != null) {
            this.nifty.publishEvent(id, (NiftyEvent)new ButtonClickedEvent(this));
        }
        return true;
    }

    public boolean onRelease() {
        String id;
        if (this.nifty != null && (id = this.getId()) != null) {
            this.nifty.publishEvent(id, (NiftyEvent)new ButtonReleasedEvent(this));
        }
        return true;
    }

    public boolean inputEvent(@Nonnull NiftyInputEvent inputEvent) {
        if (inputEvent == NiftyStandardInputEvent.Activate) {
            this.activate();
            return true;
        }
        Element buttonElement = this.getElement();
        if (buttonElement == null || this.focusHandler == null) {
            return false;
        }
        if (inputEvent == NiftyStandardInputEvent.NextInputElement) {
            this.focusHandler.getNext(buttonElement).setFocus();
            return true;
        }
        if (inputEvent == NiftyStandardInputEvent.PrevInputElement) {
            this.focusHandler.getPrev(buttonElement).setFocus();
            return true;
        }
        if (inputEvent == NiftyStandardInputEvent.MoveCursorDown) {
            this.focusHandler.getNext(buttonElement).setFocus();
            return true;
        }
        if (inputEvent == NiftyStandardInputEvent.MoveCursorUp) {
            this.focusHandler.getPrev(buttonElement).setFocus();
            return true;
        }
        return false;
    }

    @Override
    public void activate() {
        Element element = this.getElement();
        if (element == null) {
            return;
        }
        this.getElement().onClickAndReleasePrimaryMouseButton();
    }

    @Override
    @Nonnull
    public String getText() {
        if (this.buttonTextRenderer == null) {
            return "";
        }
        return this.buttonTextRenderer.getOriginalText();
    }

    @Override
    public void setText(@Nonnull String text) {
        if (this.buttonTextRenderer != null && this.buttonTextElement != null) {
            this.buttonTextRenderer.setText(text);
            if (!this.buttonTextRenderer.isLineWrapping()) {
                this.buttonTextElement.setConstraintWidth(SizeValue.px((int)this.getTextWidth()));
            }
        } else {
            if (!this.isBound()) {
                throw new IllegalStateException("Setting the text is not possible before the binding is done.");
            }
            log.warning("Failed to apply the text because the required references are not set. Maybe the element is not bound yet?");
        }
    }

    @Override
    public int getTextWidth() {
        return this.buttonTextRenderer != null ? this.buttonTextRenderer.getTextWidth() : 0;
    }

    @Override
    public int getTextHeight() {
        return this.buttonTextRenderer != null ? this.buttonTextRenderer.getTextHeight() : 0;
    }

    @Override
    @Nullable
    public RenderFont getFont() {
        return this.buttonTextRenderer != null ? this.buttonTextRenderer.getFont() : null;
    }

    @Override
    public void setFont(@Nullable RenderFont fontParam) {
        if (this.buttonTextRenderer != null) {
            this.buttonTextRenderer.setFont(fontParam);
        } else {
            if (!this.isBound()) {
                throw new IllegalStateException("Setting the font is not possible before the binding is done.");
            }
            log.warning("Failed to set the font of the renderer. Maybe the element is not bound yet?");
        }
    }

    @Override
    @Nonnull
    public VerticalAlign getTextVAlign() {
        return this.buttonTextRenderer != null ? this.buttonTextRenderer.getTextVAlign() : VerticalAlign.center;
    }

    @Override
    public void setTextVAlign(@Nonnull VerticalAlign newTextVAlign) {
        if (this.buttonTextRenderer != null) {
            this.buttonTextRenderer.setTextVAlign(newTextVAlign);
        } else {
            log.warning("Failed to set the vertical text align. Maybe the element is not bound yet?");
        }
    }

    @Override
    @Nonnull
    public HorizontalAlign getTextHAlign() {
        return this.buttonTextRenderer != null ? this.buttonTextRenderer.getTextHAlign() : HorizontalAlign.center;
    }

    @Override
    public void setTextHAlign(@Nonnull HorizontalAlign newTextHAlign) {
        if (this.buttonTextRenderer != null) {
            this.buttonTextRenderer.setTextHAlign(newTextHAlign);
        } else {
            log.warning("Failed to set the horizontal text align. Maybe the element is not bound yet?");
        }
    }

    @Override
    @Nonnull
    public Color getTextColor() {
        return this.buttonTextRenderer != null ? this.buttonTextRenderer.getColor() : TextRenderer.DEFAULT_COLOR;
    }

    @Override
    public void setTextColor(@Nonnull Color newColor) {
        if (this.buttonTextRenderer != null) {
            this.buttonTextRenderer.setColor(newColor);
        } else {
            log.warning("Failed to set the text color. Maybe the element is not bound yet?");
        }
    }
}

