/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls;

import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.controls.Console;
import de.lessvoid.nifty.controls.ConsoleCommandSplitter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConsoleExecuteCommandEvent
implements NiftyEvent {
    @Nonnull
    private final Console console;
    @Nonnull
    private final String commandLine;
    @Nonnull
    private final String command;
    @Nonnull
    private final String[] arguments;

    public ConsoleExecuteCommandEvent(@Nonnull Console console, @Nullable String commandLine) {
        this.console = console;
        if (commandLine == null || commandLine.length() == 0) {
            this.commandLine = "";
            this.command = "";
            this.arguments = new String[0];
        } else {
            this.commandLine = commandLine;
            ConsoleCommandSplitter splitter = new ConsoleCommandSplitter();
            String[] splits = splitter.split(commandLine);
            this.command = splits[0];
            this.arguments = new String[splits.length - 1];
            System.arraycopy(splits, 1, this.arguments, 0, splits.length - 1);
        }
    }

    @Nonnull
    public Console getConsole() {
        return this.console;
    }

    @Nonnull
    public String getCommandLine() {
        return this.commandLine;
    }

    public int getArgumentCount() {
        return this.arguments.length;
    }

    @Nonnull
    public String getCommand() {
        return this.command;
    }

    @Nonnull
    public String[] getArguments() {
        return this.arguments;
    }
}

