/*
 * Decompiled with CFR 0.152.
 */
package com.github.nickrm.jflux.domain;

import java.util.Objects;
import java.util.regex.Pattern;

public final class Version
implements Comparable<Version> {
    private static final Pattern VALID_VERSION_PATTERN = Pattern.compile("v?\\d\\.\\d\\.\\d");
    private final int major;
    private final int minor;
    private final int patch;

    Version(int major, int minor, int patch) {
        if (major < 0 || minor < 0 || patch < 0) {
            throw new IllegalArgumentException("Version numbers cannot be negative");
        }
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public static Version fromString(String input) {
        if (!VALID_VERSION_PATTERN.matcher(input).matches()) {
            throw new IllegalArgumentException("Invalid version format: " + input);
        }
        if (input.startsWith("v")) {
            input = input.substring(1);
        }
        String[] versionParts = input.split("\\.");
        int major = Integer.parseInt(versionParts[0]);
        int minor = Integer.parseInt(versionParts[1]);
        int patch = Integer.parseInt(versionParts[2]);
        return new Version(major, minor, patch);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.major == version.major && this.minor == version.minor && this.patch == version.patch;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch);
    }

    @Override
    public int compareTo(Version other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (this.equals(other)) {
            return 0;
        }
        if (this.major != other.major) {
            return Integer.compare(this.major, other.major);
        }
        if (this.minor != other.minor) {
            return Integer.compare(this.minor, other.minor);
        }
        return Integer.compare(this.patch, other.patch);
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch;
    }
}

