/*
 * Decompiled with CFR 0.152.
 */
package com.github.nickrm.jflux.domain;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum BuildType {
    OPEN_SOURCE("OSS", "OSS"),
    ENTERPRISE("ENT", "Enterprise");

    private static final Map<String, BuildType> LOOKUP_MAP;
    private final String identifier;
    private final String name;

    private BuildType(String identifier, String name) {
        this.identifier = identifier;
        this.name = name;
    }

    String getIdentifier() {
        return this.identifier;
    }

    public String toString() {
        return this.name;
    }

    public static BuildType fromIdentifier(String identifier) {
        if (LOOKUP_MAP.containsKey(identifier)) {
            return LOOKUP_MAP.get(identifier);
        }
        throw new IllegalArgumentException("Invalid identifier " + identifier);
    }

    static {
        LOOKUP_MAP = Arrays.stream(BuildType.values()).collect(Collectors.toMap(BuildType::getIdentifier, Function.identity()));
    }
}

