/*
 * Decompiled with CFR 0.152.
 */
package com.github.nickrm.jflux.api.response;

import com.github.nickrm.jflux.domain.BuildType;
import com.github.nickrm.jflux.domain.Version;
import java.time.Instant;

public final class ResponseMetadata {
    private final Instant timestamp;
    private final String requestId;
    private final BuildType dbBuildType;
    private final Version dbVersion;

    private ResponseMetadata(Builder builder) {
        this.timestamp = builder.timestamp;
        this.requestId = builder.requestId;
        this.dbBuildType = builder.dbBuildType;
        this.dbVersion = builder.dbVersion;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public BuildType getDbBuildType() {
        return this.dbBuildType;
    }

    public Version getDbVersion() {
        return this.dbVersion;
    }

    public String toString() {
        return "ResponseMetadata{timestamp=" + this.timestamp + ", requestId='" + this.requestId + '\'' + ", dbBuildType=" + (Object)((Object)this.dbBuildType) + ", dbVersion=" + this.dbVersion + '}';
    }

    public static final class Builder {
        private Instant timestamp;
        private String requestId;
        private BuildType dbBuildType;
        private Version dbVersion;

        public Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public Builder dbBuildType(BuildType dbBuildType) {
            this.dbBuildType = dbBuildType;
            return this;
        }

        public Builder dbVersion(Version dbVersion) {
            this.dbVersion = dbVersion;
            return this;
        }

        public ResponseMetadata build() {
            return new ResponseMetadata(this);
        }
    }
}

