/*
 * Decompiled with CFR 0.152.
 */
package com.github.nickrm.jflux.api.converter;

import com.github.nickrm.jflux.api.converter.ErrorResponseConverter;
import com.github.nickrm.jflux.api.converter.ResponseBodyConverter;
import com.github.nickrm.jflux.api.converter.ResponseHeaderConverter;
import com.github.nickrm.jflux.api.response.ApiResponse;
import com.github.nickrm.jflux.api.response.QueryResult;
import com.github.nickrm.jflux.api.response.ResponseMetadata;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;

public final class ApiResponseConverter {
    private final ResponseHeaderConverter responseHeaderConverter;
    private final ResponseBodyConverter responseBodyConverter;
    private final ErrorResponseConverter errorResponseConverter;

    public ApiResponseConverter() {
        this(new ResponseHeaderConverter(), new ResponseBodyConverter(), new ErrorResponseConverter());
    }

    ApiResponseConverter(ResponseHeaderConverter responseHeaderConverter, ResponseBodyConverter responseBodyConverter, ErrorResponseConverter errorResponseConverter) {
        this.responseHeaderConverter = responseHeaderConverter;
        this.responseBodyConverter = responseBodyConverter;
        this.errorResponseConverter = errorResponseConverter;
    }

    public ApiResponse convert(Response<ResponseBody> responseWrapper) throws IOException {
        ResponseMetadata metadata = this.responseHeaderConverter.convert(responseWrapper.headers());
        int statusCode = responseWrapper.code();
        String errorMessage = this.errorResponseConverter.convert(responseWrapper);
        List<QueryResult> results = responseWrapper.body() == null ? Collections.emptyList() : this.responseBodyConverter.convert((ResponseBody)responseWrapper.body());
        return new ApiResponse.Builder().metadata(metadata).statusCode(statusCode).errorMessage(errorMessage).results(results).build();
    }
}

